/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker;

import com.oracle.bedrock.runtime.options.Ports;
import com.oracle.bedrock.util.Capture;
import java.util.Collections;
import java.util.Iterator;

public class PortMapping {
    private String m_sName;
    private Capture<Integer> m_capture;
    private int m_portContainer;

    public PortMapping(String sName, int nPortContainer) {
        this(sName, nPortContainer, nPortContainer);
    }

    public PortMapping(String sName, int nPortLocal, int nPortContainer) {
        this(sName, Collections.singleton(nPortLocal).iterator(), nPortContainer);
    }

    public PortMapping(String sName, Iterator<Integer> itPortLocal, int nPortContainer) {
        this(sName, (Capture<Integer>)new Capture(itPortLocal), nPortContainer);
    }

    public PortMapping(String sName, Capture<Integer> localPort, int nPortContainer) {
        this.m_sName = sName;
        this.m_capture = localPort;
        this.m_portContainer = nPortContainer;
    }

    public String toString() {
        return this.m_capture.get() + ":" + this.m_portContainer;
    }

    public Ports.Port getPort() {
        return new Ports.Port(this.m_sName, ((Integer)this.m_capture.get()).intValue(), this.m_portContainer);
    }
}

