/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.remote.options.FileShareDeployer;
import java.io.File;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public class DockerfileDeployer
extends FileShareDeployer {
    private final SortedSet<AddFile> addList = new TreeSet<AddFile>();

    public DockerfileDeployer(String workingDirectory, Option ... options) {
        super(workingDirectory, workingDirectory, options);
    }

    protected boolean performRemoteCopy(String source, String destination, Platform platform, OptionsByType optionsByType) {
        File sourceFile = new File(source);
        String sourceName = sourceFile.getName();
        if (destination == null || destination.trim().isEmpty()) {
            destination = sourceName;
        }
        this.addList.add(new AddFile(sourceName, destination));
        return false;
    }

    public void write(PrintWriter writer) {
        this.addList.forEach(file -> writer.printf("ADD %-50s %s\n", file.getSource(), file.getDestination()));
    }

    protected static class AddFile
    implements Comparable<AddFile> {
        private final String source;
        private final String destination;

        public AddFile(String source, String destination) {
            this.source = Objects.requireNonNull(source);
            this.destination = Objects.requireNonNull(destination);
        }

        public String getSource() {
            return this.source;
        }

        public String getDestination() {
            return this.destination;
        }

        @Override
        public int compareTo(AddFile o) {
            int result = this.source.compareTo(o.source);
            if (result == 0) {
                result = this.destination.compareTo(o.destination);
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddFile addFile = (AddFile)o;
            if (!this.source.equals(addFile.source)) {
                return false;
            }
            return this.destination.equals(addFile.destination);
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + this.destination.hashCode();
            return result;
        }

        public String toString() {
            return "ADD " + this.source + " " + this.destination;
        }
    }
}

