/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.jacoco;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.io.FileHelper;
import com.oracle.bedrock.jacoco.Dump;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.java.ClassPath;
import com.oracle.bedrock.runtime.java.JavaApplication;
import com.oracle.bedrock.runtime.java.options.JavaAgent;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.jacoco.agent.rt.RT;

public class JacocoProfile
implements Profile,
Option {
    private final String parameters;
    private final boolean enabled;

    @OptionsByType.Default
    public JacocoProfile(String parameters) {
        this(parameters, true);
    }

    public JacocoProfile(String parameters, boolean enabled) {
        this.parameters = parameters;
        this.enabled = enabled;
    }

    public static JacocoProfile enabled(String parameters) {
        return new JacocoProfile(parameters, true);
    }

    public static JacocoProfile disabled() {
        return new JacocoProfile("", false);
    }

    public static JacocoProfile fromSystemProperty() {
        return JacocoProfile.fromSystemProperty(null);
    }

    public static JacocoProfile fromSystemProperty(String extraParams) {
        String sJacocoFolder = System.getProperty("jacoco.dest.folder");
        boolean fEnabled = Boolean.getBoolean("jacoco.enabled");
        if (sJacocoFolder == null || sJacocoFolder.trim().isEmpty()) {
            try {
                sJacocoFolder = FileHelper.createTemporaryFolder((String)"jacoco").getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String jacocoFile = sJacocoFolder + "/" + UUID.randomUUID().toString() + ".exec";
        String params = "destfile=" + jacocoFile;
        if (extraParams != null && !extraParams.trim().isEmpty()) {
            params = params + extraParams.trim();
        }
        return new JacocoProfile(params, fEnabled);
    }

    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        if (this.enabled && metaClass != null && JavaApplication.class.isAssignableFrom(metaClass.getImplementationClass(platform, optionsByType))) {
            try {
                ClassPath jacocoPath = ClassPath.ofClass(RT.class);
                JavaAgent javaAgent = JavaAgent.using((String)jacocoPath.toString(), (String)this.parameters);
                optionsByType.add((Option)javaAgent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
        if (this.enabled && application instanceof JavaApplication) {
            JavaApplication javaApplication = (JavaApplication)application;
            CompletableFuture future = javaApplication.submit((RemoteCallable)new Dump(), new Option[0]);
            future.join();
        }
    }
}

