/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.jprofiler;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.JavaApplication;
import com.oracle.bedrock.runtime.java.options.Freeform;
import com.oracle.bedrock.runtime.java.options.WaitToStart;
import com.oracle.bedrock.runtime.network.AvailablePortIterator;
import com.oracle.bedrock.util.Capture;
import com.oracle.bedrock.util.PerpetualIterator;
import java.io.File;
import java.net.InetAddress;
import java.util.Iterator;

public class JprofilerProfile
implements Profile,
Option {
    private static final int DEFAULT_PORT = 8849;
    private static final ListenAddress DEFAULT_ADDRESS = new ListenAddress(8849);
    private final boolean enabled;
    private final String agentLibraryFile;
    private final ListenAddress listenAddress;
    private final boolean startSuspended;
    private final boolean offline;
    private final File configurationFile;
    private final int sessionId;
    private final boolean verbose;
    private final boolean jniInterception;
    private final Integer stack;
    private final Integer samplingStack;

    public JprofilerProfile(boolean enabled, String agentLibraryFile, ListenAddress listenAddress, boolean offline, File configurationFile, int sessionId, boolean startSuspended, boolean verbose, boolean jniInterception, Integer stack, Integer samplingStack) {
        this.enabled = enabled;
        this.agentLibraryFile = agentLibraryFile;
        this.listenAddress = listenAddress;
        this.offline = offline;
        this.configurationFile = configurationFile;
        this.sessionId = sessionId;
        this.startSuspended = startSuspended;
        this.verbose = verbose;
        this.jniInterception = jniInterception;
        this.stack = stack;
        this.samplingStack = samplingStack;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public JprofilerProfile offlineMode(int sessionId) {
        return this.offlineMode(null, sessionId);
    }

    public JprofilerProfile offlineMode(File configurationFile, int sessionId) {
        return new JprofilerProfile(this.enabled, this.agentLibraryFile, this.listenAddress, true, configurationFile, sessionId, false, this.verbose, this.jniInterception, this.stack, this.samplingStack);
    }

    public JprofilerProfile listenMode() {
        return this.listenMode(DEFAULT_ADDRESS);
    }

    public JprofilerProfile listenMode(ListenAddress listenAddress) {
        return new JprofilerProfile(this.enabled, this.agentLibraryFile, listenAddress, false, this.configurationFile, this.sessionId, this.startSuspended, this.verbose, this.jniInterception, this.stack, this.samplingStack);
    }

    public JprofilerProfile noWait() {
        return new JprofilerProfile(this.enabled, this.agentLibraryFile, this.listenAddress, this.offline, this.configurationFile, this.sessionId, false, this.verbose, this.jniInterception, this.stack, this.samplingStack);
    }

    public JprofilerProfile startSuspended() {
        return new JprofilerProfile(this.enabled, this.agentLibraryFile, this.listenAddress, this.offline, this.configurationFile, this.sessionId, true, this.verbose, this.jniInterception, this.stack, this.samplingStack);
    }

    public JprofilerProfile verbose(boolean verbose) {
        return new JprofilerProfile(this.enabled, this.agentLibraryFile, this.listenAddress, this.offline, this.configurationFile, this.sessionId, this.startSuspended, verbose, this.jniInterception, this.stack, this.samplingStack);
    }

    public JprofilerProfile jniInterception(boolean jniInterception) {
        return new JprofilerProfile(this.enabled, this.agentLibraryFile, this.listenAddress, this.offline, this.configurationFile, this.sessionId, this.startSuspended, this.verbose, jniInterception, this.stack, this.samplingStack);
    }

    public JprofilerProfile stack(int stack) {
        return new JprofilerProfile(this.enabled, this.agentLibraryFile, this.listenAddress, this.offline, this.configurationFile, this.sessionId, this.startSuspended, this.verbose, this.jniInterception, stack, this.samplingStack);
    }

    public JprofilerProfile defaultStack() {
        return new JprofilerProfile(this.enabled, this.agentLibraryFile, this.listenAddress, this.offline, this.configurationFile, this.sessionId, this.startSuspended, this.verbose, this.jniInterception, null, this.samplingStack);
    }

    public JprofilerProfile samplingStack(int samplingStack) {
        return new JprofilerProfile(this.enabled, this.agentLibraryFile, this.listenAddress, this.offline, this.configurationFile, this.sessionId, this.startSuspended, this.verbose, this.jniInterception, this.stack, samplingStack);
    }

    public JprofilerProfile defaultSamplingStack() {
        return new JprofilerProfile(this.enabled, this.agentLibraryFile, this.listenAddress, this.offline, this.configurationFile, this.sessionId, this.startSuspended, this.verbose, this.jniInterception, this.stack, null);
    }

    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        if (metaClass != null && JavaApplication.class.isAssignableFrom(metaClass.getImplementationClass(platform, optionsByType)) && this.isEnabled()) {
            StringBuilder agentLib = new StringBuilder("-agentpath:").append(this.agentLibraryFile).append('=');
            if (this.offline) {
                agentLib.append("offline,id=").append(this.sessionId).append(",nowait");
                if (this.configurationFile != null) {
                    agentLib.append(",config=").append(this.configurationFile);
                }
            } else {
                InetAddress listenAddress;
                ListenAddress address;
                ListenAddress listenAddress2 = address = this.listenAddress == null ? (ListenAddress)optionsByType.get(ListenAddress.class, new Object[0]) : this.listenAddress;
                if (address == null) {
                    address = DEFAULT_ADDRESS;
                }
                if ((listenAddress = address.getInetAddress()) != null) {
                    agentLib.append(",address=" + listenAddress.getHostName());
                }
                agentLib.append(",port=").append(address.getPort().get()).append(this.startSuspended ? "" : ",nowait");
                optionsByType.add((Option)address);
            }
            if (this.verbose) {
                agentLib.append(",verbose-instr");
            }
            if (this.jniInterception) {
                agentLib.append(",jniInterception");
            }
            if (this.stack != null) {
                agentLib.append(",stack=").append(this.stack);
            }
            if (this.samplingStack != null) {
                agentLib.append(",samplingstack=").append(this.samplingStack);
            }
            optionsByType.add((Option)new Freeform(new String[]{agentLib.toString()}));
            if (this.startSuspended) {
                optionsByType.add((Option)WaitToStart.disabled());
            }
        }
    }

    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public static JprofilerProfile enabled(String agentLibraryFile) {
        return new JprofilerProfile(true, agentLibraryFile, null, false, null, 0, true, false, false, null, null);
    }

    @OptionsByType.Default
    public static JprofilerProfile enabledNoWait(String agentLibraryFile) {
        return new JprofilerProfile(true, agentLibraryFile, null, false, null, 0, false, false, false, null, null);
    }

    public static JprofilerProfile disabled() {
        return new JprofilerProfile(false, null, null, false, null, 0, false, false, false, null, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JprofilerProfile profile = (JprofilerProfile)o;
        if (this.enabled != profile.enabled) {
            return false;
        }
        if (this.startSuspended != profile.startSuspended) {
            return false;
        }
        if (this.offline != profile.offline) {
            return false;
        }
        if (this.sessionId != profile.sessionId) {
            return false;
        }
        if (this.verbose != profile.verbose) {
            return false;
        }
        if (this.jniInterception != profile.jniInterception) {
            return false;
        }
        if (this.agentLibraryFile != null ? !this.agentLibraryFile.equals(profile.agentLibraryFile) : profile.agentLibraryFile != null) {
            return false;
        }
        if (this.listenAddress != null ? !this.listenAddress.equals(profile.listenAddress) : profile.listenAddress != null) {
            return false;
        }
        if (this.configurationFile != null ? !this.configurationFile.equals(profile.configurationFile) : profile.configurationFile != null) {
            return false;
        }
        if (this.stack != null ? !this.stack.equals(profile.stack) : profile.stack != null) {
            return false;
        }
        return this.samplingStack != null ? this.samplingStack.equals(profile.samplingStack) : profile.samplingStack == null;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("JprofilerProfile(");
        if (this.enabled) {
            str.append("agentLibraryFile=").append(this.agentLibraryFile).append(", listenAddress=").append(this.listenAddress).append(", offline=").append(this.offline).append(", configurationFile=").append(this.configurationFile).append(", sessionId=").append(this.sessionId).append(", startSuspended=").append(this.startSuspended).append(", verbose=").append(this.verbose).append(", jniInterception=").append(this.jniInterception).append(", stack=").append(this.stack == null ? "default" : this.stack).append(", samplingStack=").append(this.samplingStack == null ? "default" : this.samplingStack);
        } else {
            str.append("disabled");
        }
        str.append(')');
        return str.toString();
    }

    public int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + (this.agentLibraryFile != null ? this.agentLibraryFile.hashCode() : 0);
        result = 31 * result + (this.listenAddress != null ? this.listenAddress.hashCode() : 0);
        result = 31 * result + (this.startSuspended ? 1 : 0);
        result = 31 * result + (this.offline ? 1 : 0);
        result = 31 * result + (this.configurationFile != null ? this.configurationFile.hashCode() : 0);
        result = 31 * result + this.sessionId;
        result = 31 * result + (this.verbose ? 1 : 0);
        result = 31 * result + (this.jniInterception ? 1 : 0);
        result = 31 * result + (this.stack != null ? this.stack.hashCode() : 0);
        result = 31 * result + (this.samplingStack != null ? this.samplingStack.hashCode() : 0);
        return result;
    }

    public static class ListenAddress
    implements Option {
        private InetAddress address;
        private Capture<Integer> port;

        public ListenAddress(AvailablePortIterator ports) {
            this((InetAddress)ports.getInetAddresses().iterator().next(), (Capture<Integer>)new Capture((Iterator)ports));
        }

        public ListenAddress(Capture<Integer> port) {
            this(null, port);
        }

        public ListenAddress(int port) {
            this(null, (Capture<Integer>)new Capture((Iterator)new PerpetualIterator((Object)port)));
        }

        public ListenAddress(InetAddress address, Capture<Integer> port) {
            if (port == null) {
                new Capture((Iterator)new PerpetualIterator((Object)8849));
            } else {
                this.address = address;
                this.port = port;
            }
        }

        public ListenAddress(InetAddress address, int port) {
            this(address, (Capture<Integer>)new Capture((Iterator)new PerpetualIterator((Object)port)));
        }

        public InetAddress getInetAddress() {
            return this.address;
        }

        public Capture<Integer> getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ListenAddress)) {
                return false;
            }
            ListenAddress other = (ListenAddress)o;
            if (this.address != null ? !this.address.equals(other.address) : other.address != null) {
                return false;
            }
            return this.port.equals(other.port);
        }

        public int hashCode() {
            int result = this.address != null ? this.address.hashCode() : 0;
            result = 31 * result + this.port.hashCode();
            return result;
        }
    }
}

