/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.k8s;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.options.LaunchLogging;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationConsole;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.SimpleApplication;
import com.oracle.bedrock.runtime.console.CapturingApplicationConsole;
import com.oracle.bedrock.runtime.console.SystemApplicationConsole;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.Console;
import com.oracle.bedrock.runtime.options.DisplayName;
import com.oracle.bedrock.runtime.options.Executable;
import java.io.Closeable;
import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class K8sCluster<K extends K8sCluster>
implements Closeable {
    public static final File DEFAULT_KUBECTL = new File("/usr/local/bin/kubectl");
    private File kubectl = DEFAULT_KUBECTL;
    private File kubectlConfig;
    private String kubectlContext;
    private boolean kubectlInsecure = false;

    public K withKubectlAt(File kubectl) {
        this.kubectl = kubectl == null ? DEFAULT_KUBECTL : kubectl;
        return (K)this;
    }

    public File getKubectl() {
        return this.kubectl;
    }

    public K withKubectlConfig(File config) {
        this.kubectlConfig = config;
        return (K)this;
    }

    public File getKubectlConfig() {
        return this.kubectlConfig;
    }

    public K withKubectlContext(String context) {
        this.kubectlContext = context;
        return (K)this;
    }

    public String getKubectlContext() {
        return this.kubectlContext;
    }

    public K withKubectlInsecure(boolean insecure) {
        this.kubectlInsecure = insecure;
        return (K)this;
    }

    public boolean isKubectlInsecure() {
        return this.kubectlInsecure;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isMasterReady() {
        CapturingApplicationConsole console = new CapturingApplicationConsole();
        try (Application application = this.kubectl(new Option[]{Arguments.of((Object[])new Object[]{"get", "nodes"}), Console.of((ApplicationConsole)console), LaunchLogging.disabled()});){
            if (application.waitFor(new Option[0]) != 0) return false;
            if (application.waitFor(new Option[0]) != 0) return false;
            boolean bl = console.getCapturedOutputLines().stream().filter(this::isMasterNodeLine).anyMatch(line -> "Ready".equalsIgnoreCase(this.getNodeStatus((String)line)));
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public int kubectlAndWait(Option ... options) {
        return this.kubectlAndWait(Timeout.autoDetect(), options);
    }

    public int kubectlAndWait(Timeout timeout, Option ... options) {
        return this.waitFor(this.kubectl(options), timeout);
    }

    public Application kubectl(Option ... options) {
        try {
            OptionsByType optionsByType = OptionsByType.empty();
            optionsByType.addAll(new Option[]{Executable.named((String)this.kubectl.getPath()), DisplayName.of((String)"kubectl"), SystemApplicationConsole.builder()});
            Arguments arguments = Arguments.empty();
            if (this.kubectlConfig != null) {
                arguments = arguments.with(Argument.of((Object)("--kubeconfig=" + this.kubectlConfig), (Option[])new Option[0]));
            }
            if (this.kubectlContext != null) {
                arguments = arguments.with(Argument.of((Object)("--context=" + this.kubectlContext), (Option[])new Option[0]));
            }
            arguments = arguments.with(Argument.of((Object)("--insecure-skip-tls-verify=" + this.kubectlInsecure), (Option[])new Option[0]));
            optionsByType.addAll(options);
            arguments = arguments.with((Arguments)optionsByType.get(Arguments.class, new Object[0]));
            optionsByType.add((Option)arguments);
            return LocalPlatform.get().launch(SimpleApplication.class, optionsByType.asArray());
        }
        catch (Throwable e) {
            throw this.ensureRuntimeException(e);
        }
    }

    public void start() {
        MatcherAssert.assertThat((Object)this.isMasterReady(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Override
    public void close() {
    }

    private int waitFor(Application application, Timeout timeout) {
        try (Application app = application;){
            int n = app.waitFor(new Option[]{timeout});
            return n;
        }
    }

    public boolean isNodeLine(String name, String line) {
        if (line == null || line.trim().isEmpty()) {
            return false;
        }
        String[] parts = line.trim().split("\\s+");
        return parts[0].equals(name);
    }

    public boolean isMasterNodeLine(String line) {
        if (line == null || line.trim().isEmpty()) {
            return false;
        }
        String[] parts = line.trim().split("\\s+");
        return parts.length >= 3 && parts[2].equalsIgnoreCase("master");
    }

    public String getNodeStatus(String line) {
        if (line == null || line.trim().isEmpty()) {
            return "NotReady";
        }
        String[] parts = line.trim().split("\\s+");
        return parts.length >= 2 ? parts[1] : "NotReady";
    }

    protected RuntimeException ensureRuntimeException(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new RuntimeException(t);
    }
}

