/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.k8s.helm;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.EnvironmentVariable;
import com.oracle.bedrock.runtime.options.EnvironmentVariables;
import java.util.Arrays;

public interface CLI<C extends CLI>
extends MetaClass<Application> {
    public String[] getCommands();

    public Arguments getArguments();

    public EnvironmentVariables getEnvironment();

    public Arguments getFlags();

    public boolean isFlagsFirst();

    default public C debug() {
        return this.withFlags(Argument.of((Object)"--debug", (Option[])new Option[0]));
    }

    default public C home(String helmHome) {
        return this.withFlags(Argument.of((String)"--home", (Object)helmHome, (Option[])new Option[0]));
    }

    default public C host(String tillerHost) {
        return this.withFlags(Argument.of((String)"--host", (Object)tillerHost, (Option[])new Option[0]));
    }

    default public C kubeContext(String contextName) {
        return this.withFlags(Argument.of((String)"--kube-context", (Object)contextName, (Option[])new Option[0]));
    }

    default public C kubeConfig(String config) {
        return this.withEnvironment(EnvironmentVariable.of((String)"KUBECONFIG", (String)config));
    }

    default public C tillerNamespace(String namespace) {
        return this.withFlags(Argument.of((String)"--tiller-namespace", (Object)namespace, (Option[])new Option[0]));
    }

    public C newInstance(String var1, Arguments var2, Arguments var3, EnvironmentVariables var4);

    default public C withHelmAt(String helm) {
        return this.newInstance(helm, this.getArguments(), this.getFlags(), this.getEnvironment());
    }

    public String getHelmLocation();

    default public C withArguments(Object ... args) {
        return this.newInstance(this.getHelmLocation(), this.getArguments().with(args), this.getFlags(), this.getEnvironment());
    }

    default public C withArguments(Argument ... args) {
        return this.newInstance(this.getHelmLocation(), this.getArguments().with(args), this.getFlags(), this.getEnvironment());
    }

    default public C withArguments(Arguments args) {
        return this.newInstance(this.getHelmLocation(), this.getArguments().with(args), this.getFlags(), this.getEnvironment());
    }

    default public C withFlags(Object ... flags) {
        return this.newInstance(this.getHelmLocation(), this.getArguments(), this.getFlags().with(flags), this.getEnvironment());
    }

    default public C withFlags(Argument ... flags) {
        return this.newInstance(this.getHelmLocation(), this.getArguments(), this.getFlags().with(flags), this.getEnvironment());
    }

    default public C withFlags(Arguments flags) {
        return this.newInstance(this.getHelmLocation(), this.getArguments(), this.getFlags().with(flags), this.getEnvironment());
    }

    default public C withEnvironment(String envVariable) {
        return this.newInstance(this.getHelmLocation(), this.getArguments(), this.getFlags(), this.getEnvironment().with(EnvironmentVariable.of((String)envVariable)));
    }

    default public C withEnvironment(String name, Object value) {
        return this.newInstance(this.getHelmLocation(), this.getArguments(), this.getFlags(), this.getEnvironment().with(EnvironmentVariable.of((String)name, (Object)value)));
    }

    default public C withEnvironment(EnvironmentVariable ... env) {
        return this.newInstance(this.getHelmLocation(), this.getArguments(), this.getFlags(), this.getEnvironment().with(Arrays.asList(env)));
    }

    default public C withEnvironment(EnvironmentVariables env) {
        return this.newInstance(this.getHelmLocation(), this.getArguments(), this.getFlags(), this.getEnvironment().with(env));
    }

    public static interface WithRepo<C extends WithRepo>
    extends CLI<C> {
        default public C repo(String repoName) {
            return (C)((WithRepo)this.withFlags(Argument.of((String)"--repo", (Object)repoName, (Option[])new Option[0])));
        }

        default public C verify() {
            return (C)((WithRepo)this.withFlags(Argument.of((Object)"--verify", (Option[])new Option[0])));
        }

        default public C version(String version) {
            return (C)((WithRepo)this.withFlags(Argument.of((String)"--version", (Object)version, (Option[])new Option[0])));
        }
    }

    public static interface WithCerts<C extends WithCerts>
    extends CLI<C> {
        default public C caFile(String caBundle) {
            return (C)((WithCerts)this.withFlags(Argument.of((String)"--ca-file", (Object)caBundle, (Option[])new Option[0])));
        }

        default public C certFile(String file) {
            return (C)((WithCerts)this.withFlags(Argument.of((String)"--cert-file", (Object)file, (Option[])new Option[0])));
        }

        default public C keyFile(String file) {
            return (C)((WithCerts)this.withFlags(Argument.of((String)"--key-file", (Object)file, (Option[])new Option[0])));
        }

        default public C keyRing(String file) {
            return (C)((WithCerts)this.withFlags(Argument.of((String)"--keyring", (Object)file, (Option[])new Option[0])));
        }
    }

    public static interface WithTLS<C extends WithTLS>
    extends CLI<C> {
        default public C tls() {
            return (C)((WithTLS)this.withFlags(Argument.of((Object)"--tls", (Option[])new Option[0])));
        }

        default public C tlsCaCert(String path) {
            return (C)((WithTLS)this.withFlags(Argument.of((String)"--tls-ca-cert", (Object)path, (Option[])new Option[0])));
        }

        default public C tlsCert(String path) {
            return (C)((WithTLS)this.withFlags(Argument.of((String)"--tls-cert", (Object)path, (Option[])new Option[0])));
        }

        default public C tlsKey(String path) {
            return (C)((WithTLS)this.withFlags(Argument.of((String)"--tls-key", (Object)path, (Option[])new Option[0])));
        }

        default public C tlsVerify() {
            return (C)((WithTLS)this.withFlags(Argument.of((Object)"--tls-verify", (Option[])new Option[0])));
        }
    }
}

