/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.k8s.helm;

import com.oracle.bedrock.runtime.k8s.helm.HelmCommand;
import com.oracle.bedrock.runtime.k8s.helm.HelmCreate;
import com.oracle.bedrock.runtime.k8s.helm.HelmDelete;
import com.oracle.bedrock.runtime.k8s.helm.HelmDependencyBuild;
import com.oracle.bedrock.runtime.k8s.helm.HelmDependencyList;
import com.oracle.bedrock.runtime.k8s.helm.HelmDependencyUpdate;
import com.oracle.bedrock.runtime.k8s.helm.HelmFetch;
import com.oracle.bedrock.runtime.k8s.helm.HelmGet;
import com.oracle.bedrock.runtime.k8s.helm.HelmGetHooks;
import com.oracle.bedrock.runtime.k8s.helm.HelmGetManifest;
import com.oracle.bedrock.runtime.k8s.helm.HelmGetValues;
import com.oracle.bedrock.runtime.k8s.helm.HelmHistory;
import com.oracle.bedrock.runtime.k8s.helm.HelmInit;
import com.oracle.bedrock.runtime.k8s.helm.HelmInspect;
import com.oracle.bedrock.runtime.k8s.helm.HelmInstall;
import com.oracle.bedrock.runtime.k8s.helm.HelmLint;
import com.oracle.bedrock.runtime.k8s.helm.HelmList;
import com.oracle.bedrock.runtime.k8s.helm.HelmRollback;
import com.oracle.bedrock.runtime.k8s.helm.HelmStatus;
import com.oracle.bedrock.runtime.k8s.helm.HelmTest;
import com.oracle.bedrock.runtime.k8s.helm.HelmUpgrade;
import com.oracle.bedrock.runtime.options.Arguments;
import java.io.File;
import java.net.URL;

public abstract class Helm {
    private Helm() {
    }

    public static HelmCommand.Template template() {
        return new HelmCommand.Template(Arguments.empty());
    }

    public static HelmCreate create(String name) {
        return new HelmCreate(name);
    }

    public static HelmDelete delete(String name) {
        return new HelmDelete(name);
    }

    public static HelmDependencyBuild dependencyBuild(String chart) {
        return new HelmDependencyBuild(chart);
    }

    public static HelmDependencyList dependencyList(String chart) {
        return new HelmDependencyList(chart);
    }

    public static HelmDependencyUpdate dependencyUpdate(String chart) {
        return new HelmDependencyUpdate(chart);
    }

    public static HelmFetch fetch(String ... charts) {
        return new HelmFetch(charts);
    }

    public static HelmGet get(String release) {
        return new HelmGet(release);
    }

    public static HelmGetHooks getHooks(String release) {
        return new HelmGetHooks(release);
    }

    public static HelmGetManifest getManifest(String release) {
        return new HelmGetManifest(release);
    }

    public static HelmGetValues getValues(String release) {
        return new HelmGetValues(release);
    }

    public static HelmHistory history(String release) {
        return new HelmHistory(release);
    }

    public static HelmInit init() {
        return new HelmInit();
    }

    public static HelmInspect inspect(String chart) {
        return new HelmInspect(chart);
    }

    public static HelmInspect inspectChart(String chart) {
        return HelmInspect.chart(chart);
    }

    public static HelmInspect inspectChart(File chart) {
        return HelmInspect.chart(chart);
    }

    public static HelmInspect inspectChart(URL chart) {
        return HelmInspect.chart(chart);
    }

    public static HelmInspect inspectValues(String chart) {
        return HelmInspect.values(chart);
    }

    public static HelmInstall install(String chart) {
        return new HelmInstall(chart);
    }

    public static HelmInstall install(File chart) {
        return new HelmInstall(chart);
    }

    public static HelmInstall install(File parentDir, String chartName) {
        return Helm.install(new File(parentDir, chartName));
    }

    public static HelmLint lint(String chart) {
        return new HelmLint(chart);
    }

    public static HelmLint lint(File chart) {
        return new HelmLint(chart);
    }

    public static HelmLint lint(File parentDir, String chartName) {
        return new HelmLint(new File(parentDir, chartName));
    }

    public static HelmList list() {
        return new HelmList();
    }

    public static HelmList list(String filter) {
        return new HelmList(filter);
    }

    public static HelmRollback rollback(String release, String revision) {
        return new HelmRollback(release, revision);
    }

    public static HelmStatus status(String release) {
        return new HelmStatus(release);
    }

    public static HelmTest test(String release) {
        return new HelmTest(release);
    }

    public static HelmUpgrade upgrade(String release, String chart) {
        return new HelmUpgrade(release, chart);
    }

    public static HelmUpgrade upgrade(String release, File chart) {
        return new HelmUpgrade(release, chart);
    }
}

