/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.k8s.helm;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.SimpleApplication;
import com.oracle.bedrock.runtime.k8s.helm.CLI;
import com.oracle.bedrock.runtime.k8s.helm.HelmCreate;
import com.oracle.bedrock.runtime.k8s.helm.HelmDelete;
import com.oracle.bedrock.runtime.k8s.helm.HelmDependencyBuild;
import com.oracle.bedrock.runtime.k8s.helm.HelmDependencyList;
import com.oracle.bedrock.runtime.k8s.helm.HelmDependencyUpdate;
import com.oracle.bedrock.runtime.k8s.helm.HelmFetch;
import com.oracle.bedrock.runtime.k8s.helm.HelmGet;
import com.oracle.bedrock.runtime.k8s.helm.HelmGetHooks;
import com.oracle.bedrock.runtime.k8s.helm.HelmGetManifest;
import com.oracle.bedrock.runtime.k8s.helm.HelmGetValues;
import com.oracle.bedrock.runtime.k8s.helm.HelmHistory;
import com.oracle.bedrock.runtime.k8s.helm.HelmInit;
import com.oracle.bedrock.runtime.k8s.helm.HelmInspect;
import com.oracle.bedrock.runtime.k8s.helm.HelmInstall;
import com.oracle.bedrock.runtime.k8s.helm.HelmLint;
import com.oracle.bedrock.runtime.k8s.helm.HelmList;
import com.oracle.bedrock.runtime.k8s.helm.HelmRollback;
import com.oracle.bedrock.runtime.k8s.helm.HelmStatus;
import com.oracle.bedrock.runtime.k8s.helm.HelmTest;
import com.oracle.bedrock.runtime.k8s.helm.HelmUpgrade;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.EnvironmentVariables;
import com.oracle.bedrock.runtime.options.Executable;
import java.io.File;
import java.net.URL;
import java.util.Objects;

public abstract class HelmCommand<C extends HelmCommand>
implements CLI<C> {
    public static final String DEFAULT_HELM = System.getProperty("bedrock.helm", "/usr/local/bin/helm");
    private final String helmExecutable;
    private final String[] commands;
    private final Arguments arguments;
    private final Arguments flags;
    private final EnvironmentVariables environmentVariables;
    private final boolean flagsFirst;

    HelmCommand(String helmExecutable, Arguments arguments, Arguments flags, EnvironmentVariables env, boolean flagsFirst, String ... commands) {
        this.helmExecutable = helmExecutable == null || helmExecutable.trim().isEmpty() ? DEFAULT_HELM : helmExecutable;
        this.arguments = Objects.requireNonNull(arguments);
        this.flags = Objects.requireNonNull(flags);
        this.environmentVariables = Objects.requireNonNull(env);
        this.flagsFirst = flagsFirst;
        this.commands = Objects.requireNonNull(commands);
    }

    @Override
    public String getHelmLocation() {
        return this.helmExecutable == null ? DEFAULT_HELM : this.helmExecutable;
    }

    public boolean helmExists() {
        File file = new File(this.helmExecutable);
        return file.exists() && file.canExecute();
    }

    @Override
    public String[] getCommands() {
        return this.commands;
    }

    @Override
    public Arguments getArguments() {
        return this.arguments;
    }

    @Override
    public EnvironmentVariables getEnvironment() {
        return this.environmentVariables;
    }

    @Override
    public Arguments getFlags() {
        return this.flags;
    }

    @Override
    public boolean isFlagsFirst() {
        return this.flagsFirst;
    }

    public Application execute(Option ... options) {
        return LocalPlatform.get().launch((MetaClass)this, options);
    }

    public int executeAndWait(Option ... options) {
        try (Application app = LocalPlatform.get().launch((MetaClass)this, options);){
            int n = app.waitFor(options);
            return n;
        }
    }

    public Class<? extends Application> getImplementationClass(Platform platform, OptionsByType options) {
        return SimpleApplication.class;
    }

    public void onLaunching(Platform platform, OptionsByType optionsByType) {
        optionsByType.add((Option)Executable.named((String)this.getHelmLocation()));
        Arguments args = (Arguments)optionsByType.get(Arguments.class, new Object[0]);
        for (String cmd : this.commands) {
            args = args.with(new Object[]{cmd});
        }
        args = this.flagsFirst ? args.with(this.flags).with(this.arguments) : args.with(this.arguments).with(this.flags);
        optionsByType.add((Option)args);
        if (this.environmentVariables != null) {
            EnvironmentVariables env = (EnvironmentVariables)optionsByType.get(EnvironmentVariables.class, new Object[0]);
            optionsByType.add((Option)env.with(this.environmentVariables));
        }
    }

    public void onLaunch(Platform platform, OptionsByType optionsByType) {
    }

    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public static class Template
    extends HelmCommand<Template> {
        Template(Arguments flags) {
            super(null, Arguments.empty(), flags, EnvironmentVariables.custom(), false, new String[0]);
        }

        Template(String helm, Arguments arguments, Arguments flags, EnvironmentVariables env) {
            super(helm, arguments, flags, env, false, new String[0]);
        }

        @Override
        public Template newInstance(String helm, Arguments arguments, Arguments flags, EnvironmentVariables env) {
            return new Template(this.getHelmLocation(), arguments, flags, env);
        }

        public HelmCreate create(String name) {
            return (HelmCreate)((HelmCreate)((HelmCreate)((HelmCreate)new HelmCreate(name).withHelmAt(this.getHelmLocation())).withArguments(this.getArguments())).withFlags(this.getFlags())).withEnvironment(this.getEnvironment());
        }

        public HelmDelete delete(String name) {
            return (HelmDelete)((HelmDelete)((HelmDelete)((HelmDelete)new HelmDelete(name).withHelmAt(this.getHelmLocation())).withArguments(this.getArguments())).withFlags(this.getFlags())).withEnvironment(this.getEnvironment());
        }

        public HelmDependencyBuild dependencyBuild(String chart) {
            return (HelmDependencyBuild)((HelmDependencyBuild)((HelmDependencyBuild)((HelmDependencyBuild)new HelmDependencyBuild(chart).withHelmAt(this.getHelmLocation())).withArguments(this.getArguments())).withFlags(this.getFlags())).withEnvironment(this.getEnvironment());
        }

        public HelmDependencyList dependencyList(String chart) {
            return (HelmDependencyList)((HelmDependencyList)((HelmDependencyList)((HelmDependencyList)new HelmDependencyList(chart).withHelmAt(this.getHelmLocation())).withArguments(this.getArguments())).withFlags(this.getFlags())).withEnvironment(this.getEnvironment());
        }

        public HelmDependencyUpdate dependencyUpdate(String chart) {
            return (HelmDependencyUpdate)((HelmDependencyUpdate)((HelmDependencyUpdate)((HelmDependencyUpdate)new HelmDependencyUpdate(chart).withHelmAt(this.getHelmLocation())).withArguments(this.getArguments())).withFlags(this.getFlags())).withEnvironment(this.getEnvironment());
        }

        public HelmFetch fetch(String ... charts) {
            return (HelmFetch)((HelmFetch)((HelmFetch)((HelmFetch)new HelmFetch(charts).withHelmAt(this.getHelmLocation())).withArguments(this.getArguments())).withFlags(this.getFlags())).withEnvironment(this.getEnvironment());
        }

        public HelmGet get(String releaseName) {
            return (HelmGet)((HelmGet)((HelmGet)((HelmGet)new HelmGet(releaseName).withHelmAt(this.getHelmLocation())).withArguments(this.getArguments())).withFlags(this.getFlags())).withEnvironment(this.getEnvironment());
        }

        public HelmGetHooks getHooks(String releaseName) {
            return (HelmGetHooks)((HelmGetHooks)((HelmGetHooks)((HelmGetHooks)new HelmGetHooks(releaseName).withHelmAt(this.getHelmLocation())).withArguments(this.getArguments())).withFlags(this.getFlags())).withEnvironment(this.getEnvironment());
        }

        public HelmGetManifest getManifest(String releaseName) {
            return (HelmGetManifest)((HelmGetManifest)((HelmGetManifest)((HelmGetManifest)new HelmGetManifest(releaseName).withHelmAt(this.getHelmLocation())).withArguments(this.getArguments())).withFlags(this.getFlags())).withEnvironment(this.getEnvironment());
        }

        public HelmGetValues getValues(String releaseName) {
            return (HelmGetValues)((HelmGetValues)((HelmGetValues)((HelmGetValues)new HelmGetValues(releaseName).withHelmAt(this.getHelmLocation())).withArguments(this.getArguments())).withFlags(this.getFlags())).withEnvironment(this.getEnvironment());
        }

        public HelmHistory history(String releaseName) {
            return (HelmHistory)((HelmHistory)((HelmHistory)((HelmHistory)new HelmHistory(releaseName).withHelmAt(this.getHelmLocation())).withArguments(this.getArguments())).withFlags(this.getFlags())).withEnvironment(this.getEnvironment());
        }

        public HelmInit init() {
            return new HelmInit(this.getHelmLocation(), this.getArguments(), this.getFlags(), this.getEnvironment());
        }

        public HelmInspect inspect(String chart) {
            return new HelmInspect(this.getHelmLocation(), Arguments.of((Object[])new Object[]{chart}).with(this.getArguments()), this.getFlags(), this.getEnvironment(), new String[0]);
        }

        public HelmInspect inspect(File chart) {
            return new HelmInspect(this.getHelmLocation(), Arguments.of((Object[])new Object[]{chart}).with(this.getArguments()), this.getFlags(), this.getEnvironment(), new String[0]);
        }

        public HelmInspect inspect(URL chart) {
            return new HelmInspect(this.getHelmLocation(), Arguments.of((Object[])new Object[]{chart}).with(this.getArguments()), this.getFlags(), this.getEnvironment(), new String[0]);
        }

        public HelmInstall install(String chart) {
            return new HelmInstall(this.getHelmLocation(), Arguments.of((Object[])new Object[]{chart}).with(this.getArguments()), this.getFlags(), this.getEnvironment());
        }

        public HelmInstall install(File chart) {
            return new HelmInstall(this.getHelmLocation(), Arguments.of((Object[])new Object[]{chart}).with(this.getArguments()), this.getFlags(), this.getEnvironment());
        }

        public HelmInstall install(File directory, String chart) {
            File file = new File(directory, chart);
            return new HelmInstall(this.getHelmLocation(), Arguments.of((Object[])new Object[]{file}).with(this.getArguments()), this.getFlags(), this.getEnvironment());
        }

        public HelmLint lint(String chart) {
            return new HelmLint(this.getHelmLocation(), Arguments.of((Object[])new Object[]{chart}).with(this.getArguments()), this.getFlags(), this.getEnvironment());
        }

        public HelmLint lint(File chart) {
            return new HelmLint(this.getHelmLocation(), Arguments.of((Object[])new Object[]{chart}).with(this.getArguments()), this.getFlags(), this.getEnvironment());
        }

        public HelmLint lint(File directory, String chart) {
            File file = new File(directory, chart);
            return new HelmLint(this.getHelmLocation(), Arguments.of((Object[])new Object[]{file}).with(this.getArguments()), this.getFlags(), this.getEnvironment());
        }

        public HelmList list() {
            return new HelmList();
        }

        public HelmList list(String filter) {
            return new HelmList(filter);
        }

        public HelmRollback rollback(String release, String revision) {
            return new HelmRollback(this.getHelmLocation(), Arguments.of((Object[])new Object[]{release, revision}).with(this.getArguments()), this.getFlags(), this.getEnvironment());
        }

        public HelmStatus status(String release) {
            return new HelmStatus(this.getHelmLocation(), Arguments.of((Object[])new Object[]{release}).with(this.getArguments()), this.getFlags(), this.getEnvironment());
        }

        public HelmTest test(String release) {
            return new HelmTest(this.getHelmLocation(), Arguments.of((Object[])new Object[]{release}).with(this.getArguments()), this.getFlags(), this.getEnvironment());
        }

        public HelmUpgrade upgrade(String release, String chart) {
            return new HelmUpgrade(this.getHelmLocation(), Arguments.of((Object[])new Object[]{release, chart}).with(this.getArguments()), this.getFlags(), this.getEnvironment());
        }

        public HelmUpgrade upgrade(String release, File chart) {
            return new HelmUpgrade(this.getHelmLocation(), Arguments.of((Object[])new Object[]{release, chart}).with(this.getArguments()), this.getFlags(), this.getEnvironment());
        }
    }
}

