/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.k8s.helm;

import com.oracle.bedrock.runtime.k8s.helm.HelmCommand;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.EnvironmentVariables;

public class HelmInit
extends HelmCommand<HelmInit> {
    HelmInit() {
        this(DEFAULT_HELM, Arguments.empty(), Arguments.empty(), EnvironmentVariables.custom());
    }

    HelmInit(String helm, Arguments arguments, Arguments flags, EnvironmentVariables env) {
        super(helm, arguments, flags, env, false, "init");
    }

    @Override
    public HelmInit newInstance(String helm, Arguments arguments, Arguments flags, EnvironmentVariables env) {
        return new HelmInit(helm, arguments, flags, env);
    }

    public HelmInit canaryImage() {
        return (HelmInit)this.withFlags(Arguments.of((Object[])new Object[]{"--canary-image"}));
    }

    public HelmInit clientOnly() {
        return (HelmInit)this.withFlags(Arguments.of((Object[])new Object[]{"--client-only"}));
    }

    public HelmInit dryRun() {
        return (HelmInit)this.withFlags(Arguments.of((Object[])new Object[]{"--dry-run"}));
    }

    public HelmInit localRepoURL(String url) {
        return (HelmInit)this.withFlags(Arguments.of((Object[])new Object[]{"--local-repo-url", url}));
    }

    public HelmInit netHost() {
        return (HelmInit)this.withFlags(Arguments.of((Object[])new Object[]{"--net-host"}));
    }

    public HelmInit serviceAccount(String name) {
        return (HelmInit)this.withFlags(Arguments.of((Object[])new Object[]{"--service-account", name}));
    }

    public HelmInit skipRefresh() {
        return (HelmInit)this.withFlags(Arguments.of((Object[])new Object[]{"--skip-refresh"}));
    }

    public HelmInit stableRepoURL(String url) {
        return (HelmInit)this.withFlags(Arguments.of((Object[])new Object[]{"--stable-repo-url", url}));
    }

    public HelmInit tillerImage(String image) {
        return (HelmInit)this.withFlags(Arguments.of((Object[])new Object[]{"--tiller-image", image}));
    }

    public HelmInit tillerTLS() {
        return (HelmInit)this.withFlags(Arguments.of((Object[])new Object[]{"--tiller-tls"}));
    }

    public HelmInit tillerTLSCert(String cert) {
        return (HelmInit)this.withFlags(Arguments.of((Object[])new Object[]{"--tiller-tls-cert", cert}));
    }

    public HelmInit tillerTLSKey(String key) {
        return (HelmInit)this.withFlags(Arguments.of((Object[])new Object[]{"--tiller-tls-key", key}));
    }

    public HelmInit tillerTLSVerify() {
        return (HelmInit)this.withFlags(Arguments.of((Object[])new Object[]{"--tiller-tls-verify"}));
    }

    public HelmInit tlsCACert(String cert) {
        return (HelmInit)this.withFlags(Arguments.of((Object[])new Object[]{"--tls-ca-cert", cert}));
    }

    public HelmInit upgrade() {
        return (HelmInit)this.withFlags(Arguments.of((Object[])new Object[]{"--upgrade"}));
    }
}

