/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.k8s.helm;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.k8s.helm.CLI;
import com.oracle.bedrock.runtime.k8s.helm.HelmCommand;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.EnvironmentVariables;
import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;

public class HelmInstall
extends HelmCommand<HelmInstall>
implements CLI.WithCerts<HelmInstall>,
CLI.WithTLS<HelmInstall>,
CLI.WithRepo<HelmInstall> {
    HelmInstall(File chart) {
        this(DEFAULT_HELM, Arguments.of((Object[])new Object[]{chart}), Arguments.empty(), EnvironmentVariables.custom());
    }

    HelmInstall(String chart) {
        this(DEFAULT_HELM, Arguments.of((Object[])new Object[]{chart}), Arguments.empty(), EnvironmentVariables.custom());
    }

    HelmInstall(String helm, Arguments arguments, Arguments flags, EnvironmentVariables env) {
        super(helm, arguments, flags, env, false, "install");
    }

    public HelmInstall development() {
        return (HelmInstall)this.withFlags(Argument.of((Object)"--devel", (Option[])new Option[0]));
    }

    public HelmInstall dryRun() {
        return (HelmInstall)this.withFlags(Argument.of((Object)"--dry-run", (Option[])new Option[0]));
    }

    public HelmInstall name(String name) {
        return (HelmInstall)this.withFlags(Argument.of((String)"--name", (Object)name, (Option[])new Option[0]));
    }

    public HelmInstall nameTemplate(String template) {
        return (HelmInstall)this.withFlags(Argument.of((String)"--name-template", (Object)template, (Option[])new Option[0]));
    }

    public HelmInstall namespace(String namespace) {
        return (HelmInstall)this.withFlags(Argument.of((String)"--namespace", (Object)namespace, (Option[])new Option[0]));
    }

    public HelmInstall noHooks() {
        return (HelmInstall)this.withFlags(Argument.of((Object)"--no-hooks", (Option[])new Option[0]));
    }

    public HelmInstall replace() {
        return (HelmInstall)this.withFlags(Argument.of((Object)"--replace", (Option[])new Option[0]));
    }

    @Override
    public HelmInstall repo(String repo) {
        return (HelmInstall)this.withFlags(Argument.of((String)"--repo", (Object)repo, (Option[])new Option[0]));
    }

    public HelmInstall set(String ... values) {
        if (values == null || values.length == 0) {
            return this;
        }
        String valueString = Arrays.stream(values).collect(Collectors.joining(","));
        return (HelmInstall)this.withFlags(Argument.of((String)"--set", (Object)valueString, (Option[])new Option[0]));
    }

    public HelmInstall timeout(int seconds) {
        return (HelmInstall)this.withFlags(Argument.of((String)"--timeout", (Object)seconds, (Option[])new Option[0]));
    }

    public HelmInstall values(String valuesFile) {
        return (HelmInstall)this.withFlags(Argument.of((String)"--values", (Object)valuesFile, (Option[])new Option[0]));
    }

    public HelmInstall values(File valuesFile) {
        return (HelmInstall)this.withFlags(Argument.of((String)"--values", (Object)valuesFile, (Option[])new Option[0]));
    }

    @Override
    public HelmInstall version(String version) {
        return (HelmInstall)this.withFlags(Argument.of((String)"--version", (Object)version, (Option[])new Option[0]));
    }

    public HelmInstall waitForK8s() {
        return (HelmInstall)this.withFlags(Argument.of((Object)"--wait", (Option[])new Option[0]));
    }

    public HelmInstall waitForK8s(int seconds) {
        return (HelmInstall)this.withFlags(Argument.of((Object)"--wait", (Option[])new Option[0]), Argument.of((String)"--timeout", (Object)seconds, (Option[])new Option[0]));
    }

    @Override
    public HelmInstall newInstance(String helm, Arguments arguments, Arguments flags, EnvironmentVariables env) {
        return new HelmInstall(helm, arguments, flags, env);
    }
}

