/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.k8s.helm;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.k8s.helm.CLI;
import com.oracle.bedrock.runtime.k8s.helm.HelmCommand;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.EnvironmentVariables;
import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;

public class HelmUpgrade
extends HelmCommand<HelmUpgrade>
implements CLI.WithCerts<HelmUpgrade>,
CLI.WithTLS<HelmUpgrade>,
CLI.WithRepo<HelmUpgrade> {
    HelmUpgrade(String release, File chart) {
        this(DEFAULT_HELM, Arguments.of((Object[])new Object[]{release, chart}), Arguments.empty(), EnvironmentVariables.custom());
    }

    HelmUpgrade(String release, String chart) {
        this(DEFAULT_HELM, Arguments.of((Object[])new Object[]{release, chart}), Arguments.empty(), EnvironmentVariables.custom());
    }

    HelmUpgrade(String helm, Arguments arguments, Arguments flags, EnvironmentVariables env) {
        super(helm, arguments, flags, env, false, "upgrade");
    }

    public HelmUpgrade development() {
        return (HelmUpgrade)this.withFlags(Argument.of((Object)"--devel", (Option[])new Option[0]));
    }

    public HelmUpgrade dryRun() {
        return (HelmUpgrade)this.withFlags(Argument.of((Object)"--dry-run", (Option[])new Option[0]));
    }

    public HelmUpgrade force() {
        return (HelmUpgrade)this.withFlags(Argument.of((Object)"--force", (Option[])new Option[0]));
    }

    public HelmUpgrade install() {
        return (HelmUpgrade)this.withFlags(Argument.of((Object)"--install", (Option[])new Option[0]));
    }

    public HelmUpgrade name(String name) {
        return (HelmUpgrade)this.withFlags(Argument.of((String)"--name", (Object)name, (Option[])new Option[0]));
    }

    public HelmUpgrade nameTemplate(String template) {
        return (HelmUpgrade)this.withFlags(Argument.of((String)"--name-template", (Object)template, (Option[])new Option[0]));
    }

    public HelmUpgrade namespace(String namespace) {
        return (HelmUpgrade)this.withFlags(Argument.of((String)"--namespace", (Object)namespace, (Option[])new Option[0]));
    }

    public HelmUpgrade noHooks() {
        return (HelmUpgrade)this.withFlags(Argument.of((Object)"--no-hooks", (Option[])new Option[0]));
    }

    public HelmUpgrade replace() {
        return (HelmUpgrade)this.withFlags(Argument.of((Object)"--replace", (Option[])new Option[0]));
    }

    @Override
    public HelmUpgrade repo(String repo) {
        return (HelmUpgrade)this.withFlags(Argument.of((String)"--repo", (Object)repo, (Option[])new Option[0]));
    }

    public HelmUpgrade set(String ... values) {
        if (values == null || values.length == 0) {
            return this;
        }
        String valueString = Arrays.stream(values).collect(Collectors.joining(","));
        return (HelmUpgrade)this.withFlags(Argument.of((String)"--set", (Object)valueString, (Option[])new Option[0]));
    }

    public HelmUpgrade timeout(int seconds) {
        return (HelmUpgrade)this.withFlags(Argument.of((String)"--timeout", (Object)seconds, (Option[])new Option[0]));
    }

    public HelmUpgrade values(String valuesFile) {
        return (HelmUpgrade)this.withFlags(Argument.of((String)"--values", (Object)valuesFile, (Option[])new Option[0]));
    }

    public HelmUpgrade values(File valuesFile) {
        return (HelmUpgrade)this.withFlags(Argument.of((String)"--values", (Object)valuesFile, (Option[])new Option[0]));
    }

    @Override
    public HelmUpgrade version(String version) {
        return (HelmUpgrade)this.withFlags(Argument.of((String)"--version", (Object)version, (Option[])new Option[0]));
    }

    public HelmUpgrade waitForK8s() {
        return (HelmUpgrade)this.withFlags(Argument.of((Object)"--wait", (Option[])new Option[0]));
    }

    public HelmUpgrade waitForK8s(int seconds) {
        return (HelmUpgrade)this.withFlags(Argument.of((Object)"--wait", (Option[])new Option[0]), Argument.of((String)"--timeout", (Object)seconds, (Option[])new Option[0]));
    }

    @Override
    public HelmUpgrade newInstance(String helm, Arguments arguments, Arguments flags, EnvironmentVariables env) {
        return new HelmUpgrade(helm, arguments, flags, env);
    }
}

