/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.k8s.linuxkit;

import com.oracle.bedrock.runtime.options.CommandInterceptor;
import java.io.File;
import java.util.List;
import java.util.Properties;

public class ContainerdCommandInterceptor
implements CommandInterceptor {
    public static final String CMD_TEMPLATE = "ctr -n %s tasks exec -cwd %s --exec-id bedrock %s %s";
    public static final String DEFAULT_NAMESPACE = "services.linuxkit";
    public static final String DEFAULT_CONTAINER = "kubelet";
    private final String namespace;
    private final String container;

    private ContainerdCommandInterceptor(String namespace, String container) {
        this.namespace = namespace;
        this.container = container;
    }

    public String onExecute(String executableName, List<String> arguments, Properties envVariables, File workingDirectory) {
        StringBuilder command = new StringBuilder(executableName);
        for (String arg : arguments) {
            command.append(" ").append(arg);
        }
        return String.format(CMD_TEMPLATE, this.namespace, workingDirectory, this.container, command);
    }

    public static ContainerdCommandInterceptor instance() {
        return new ContainerdCommandInterceptor(DEFAULT_NAMESPACE, DEFAULT_CONTAINER);
    }

    public static ContainerdCommandInterceptor instance(String namespace, String container) {
        return new ContainerdCommandInterceptor(namespace, container);
    }
}

