/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.k8s.linuxkit;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.deferred.DeferredHelper;
import com.oracle.bedrock.io.FileHelper;
import com.oracle.bedrock.options.LaunchLogging;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationConsole;
import com.oracle.bedrock.runtime.ApplicationConsoleBuilder;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.SimpleApplication;
import com.oracle.bedrock.runtime.console.CapturingApplicationConsole;
import com.oracle.bedrock.runtime.console.FileWriterApplicationConsole;
import com.oracle.bedrock.runtime.console.SystemApplicationConsole;
import com.oracle.bedrock.runtime.k8s.K8sCluster;
import com.oracle.bedrock.runtime.k8s.linuxkit.ContainerdCommandInterceptor;
import com.oracle.bedrock.runtime.network.AvailablePortIterator;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.Console;
import com.oracle.bedrock.runtime.options.DisplayName;
import com.oracle.bedrock.runtime.options.Executable;
import com.oracle.bedrock.runtime.options.WorkingDirectory;
import com.oracle.bedrock.runtime.remote.Authentication;
import com.oracle.bedrock.runtime.remote.RemotePlatform;
import com.oracle.bedrock.runtime.remote.SecureKeys;
import com.oracle.bedrock.runtime.remote.options.Deployer;
import com.oracle.bedrock.runtime.remote.options.StrictHostChecking;
import com.oracle.bedrock.runtime.remote.options.UserKnownHostsFile;
import com.oracle.bedrock.testsupport.deferred.Eventually;
import com.oracle.bedrock.util.Capture;
import com.oracle.bedrock.util.Pair;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class LinuxKitK8sCluster
extends K8sCluster<LinuxKitK8sCluster>
implements Closeable {
    private static Logger LOGGER = Logger.getLogger(LinuxKitK8sCluster.class.getName());
    private static final String K8S_ADMIN_CONF = "/etc/kubernetes/admin.conf";
    public static final String LINUXKIT_CMD;
    public static final String BEDROCK_LINUXKIT_K8S_HOME = "bedrock.linuxkit.k8s.home";
    private String linuxKit;
    private String linuxKitK8sHome;
    private ApplicationConsoleBuilder consoleBuilder = SystemApplicationConsole.builder();
    private File tempFolder;
    private Application appMaster;
    private RemotePlatform platformMaster;
    private Capture<Integer> sshPort;
    private Capture<Integer> k8sPort;
    private File logDir;
    private int workerNodeCount = 2;
    private int masterMemory = 1024;
    private int nodeMemory = 2048;
    private int masterDiscSize = 4;
    private int nodeDiscSize = 4;
    private boolean clearState = true;
    private boolean copyISO = true;
    private final List<Pair<Application, RemotePlatform>> workerNodes = new ArrayList<Pair<Application, RemotePlatform>>();

    public LinuxKitK8sCluster() {
        this(LINUXKIT_CMD, null);
    }

    public LinuxKitK8sCluster(String linuxKitK8sHome) {
        this(LINUXKIT_CMD, linuxKitK8sHome);
    }

    public LinuxKitK8sCluster(String linuxKit, String linuxKitK8sHome) {
        this.linuxKit = linuxKit;
        this.linuxKitK8sHome = linuxKitK8sHome;
        if (this.linuxKitK8sHome == null || this.linuxKit.isEmpty()) {
            this.linuxKitK8sHome = System.getProperty(BEDROCK_LINUXKIT_K8S_HOME);
        }
        if (this.linuxKitK8sHome == null || this.linuxKitK8sHome.isEmpty()) {
            throw new IllegalArgumentException("LinuxKit K8s Home not provided either as a parameter of via the bedrock.linuxkit.k8s.home System property");
        }
        try {
            this.tempFolder = FileHelper.createTemporaryFolder((String)"bedrock-linuxkit");
        }
        catch (IOException e) {
            throw this.ensureRuntimeException(e);
        }
    }

    @Override
    public void start() {
        LOGGER.info("Starting linuxkit k8s cluster in " + this.linuxKitK8sHome);
        try {
            String kubeEfi;
            String masterImage;
            LocalPlatform platform = LocalPlatform.get();
            AvailablePortIterator ports = platform.getAvailablePorts();
            File k8sHome = new File(this.linuxKitK8sHome);
            String master = "kube-master-state";
            File masterDir = new File(k8sHome, master);
            String os = System.getProperty("os.name");
            String masterDisc = String.format("size=%dG", this.masterDiscSize);
            boolean efi = false;
            String sshKey = System.getProperty("user.home") + "/.ssh/id_rsa";
            ApplicationConsoleBuilder console = this.consoleBuilder;
            if (this.logDir != null) {
                this.logDir.mkdirs();
                console = FileWriterApplicationConsole.builder((String)this.logDir.getCanonicalPath(), (String)"", (String)".log");
            }
            this.sshPort = new Capture((Iterator)ports);
            this.k8sPort = new Capture((Iterator)ports);
            if (this.clearState) {
                LOGGER.info("Deleting previous k8s master state in " + masterDir);
                FileHelper.recursiveDelete((File)masterDir);
            }
            masterDir.mkdirs();
            this.ensureMasterMetaData(masterDir);
            if ("Mac OS X".equals(os)) {
                efi = true;
            }
            if (efi) {
                masterImage = "kube-master-efi.iso";
                kubeEfi = "--uefi";
            } else {
                masterImage = "kube-master.iso";
                kubeEfi = "";
            }
            LOGGER.info("Starting linuxkit k8s master");
            this.appMaster = platform.launch(this.linuxKit, new Option[]{Argument.of((Object)"run", (Option[])new Option[0]), Argument.of((String)"-publish", (Object)(this.sshPort.get() + ":22"), (Option[])new Option[0]), Argument.of((String)"-publish", (Object)(this.k8sPort.get() + ":8443"), (Option[])new Option[0]), Argument.of((String)"-networking", (Object)"default", (Option[])new Option[0]), Argument.of((String)"-cpus", (Object)"2", (Option[])new Option[0]), Argument.of((String)"-mem", (Object)this.masterMemory, (Option[])new Option[0]), Argument.of((String)"-disk", (Object)masterDisc, (Option[])new Option[0]), Argument.of((String)"-state", (Object)masterDir.getName(), (Option[])new Option[0]), Argument.of((String)"-data-file", (Object)(master + "/metadata.json"), (Option[])new Option[0]), Argument.of((Object)kubeEfi, (Option[])new Option[0]), Argument.of((Object)masterImage, (Option[])new Option[0]), WorkingDirectory.at((Object)this.linuxKitK8sHome), DisplayName.of((String)"k8s-master"), console});
            this.platformMaster = new RemotePlatform("master", InetAddress.getByName("localhost"), ((Integer)this.sshPort.get()).intValue(), "root", (Authentication)SecureKeys.fromPrivateKeyFile((String)sshKey), new Option[]{WorkingDirectory.at((Object)"/root"), Deployer.NULL, ContainerdCommandInterceptor.instance(), StrictHostChecking.disabled(), UserKnownHostsFile.at((String)"/dev/null")});
            LOGGER.info("Waiting to connect to k8s master...");
            Eventually.assertThat((Object)((LinuxKitK8sCluster)DeferredHelper.invoking((Object)this)).canConnectTo(this.platformMaster), (Matcher)CoreMatchers.is((Object)true), (Option[])new Option[]{Timeout.after((long)2L, (TimeUnit)TimeUnit.MINUTES)});
            LOGGER.info("Connected to k8s master");
            this.writeKubectlConfig();
            LOGGER.info("Waiting for k8s master status to be Ready...");
            Thread.sleep(60000L);
            Eventually.assertThat((Object)((LinuxKitK8sCluster)DeferredHelper.invoking((Object)this)).isMasterReady(), (Matcher)CoreMatchers.is((Object)true), (Option[])new Option[]{Timeout.after((long)2L, (TimeUnit)TimeUnit.MINUTES)});
            LOGGER.info("k8s master status is Ready");
            LOGGER.info("Starting " + this.workerNodeCount + " k8s worker nodes...");
            for (int i = 0; i < this.workerNodeCount; ++i) {
                int nodeId = this.addWorkerNode();
                Thread.sleep(30000L);
                LOGGER.info("Waiting for all " + (1 + nodeId) + " k8s nodes to be ready...");
                Eventually.assertThat((Object)((LinuxKitK8sCluster)DeferredHelper.invoking((Object)this)).areAllNodesReady(1 + nodeId), (Matcher)CoreMatchers.is((Object)true), (Option[])new Option[]{Timeout.after((long)2L, (TimeUnit)TimeUnit.MINUTES)});
            }
            LOGGER.info("Started " + this.workerNodeCount + " k8s worker nodes");
            LOGGER.info("K8s Cluster is Ready");
        }
        catch (Exception e) {
            throw this.ensureRuntimeException(e);
        }
    }

    @Override
    public void close() {
        for (Pair<Application, RemotePlatform> pair : this.workerNodes) {
            this.close((Application)pair.getX(), (RemotePlatform)pair.getY());
        }
        this.workerNodes.clear();
        if (this.appMaster != null) {
            this.close(this.appMaster, this.platformMaster);
        }
    }

    private void close(Application application, RemotePlatform platform) {
        try {
            platform.launch("poweroff -f", new Option[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            application.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized int addWorkerNode() throws Exception {
        String kubeEfi;
        String nodeImage;
        LocalPlatform platform = LocalPlatform.get();
        AvailablePortIterator ports = platform.getAvailablePorts();
        File k8sHome = new File(this.linuxKitK8sHome);
        String os = System.getProperty("os.name");
        boolean efi = false;
        ApplicationConsoleBuilder console = this.consoleBuilder;
        String nodeDisc = String.format("size=%dG", this.nodeDiscSize);
        String sshKey = System.getProperty("user.home") + "/.ssh/id_rsa";
        if (this.logDir != null) {
            this.logDir.mkdirs();
            console = FileWriterApplicationConsole.builder((String)this.logDir.getCanonicalPath(), (String)"", (String)".log");
        }
        if ("Mac OS X".equals(os)) {
            efi = true;
        }
        if (efi) {
            nodeImage = "kube-node-efi.iso";
            kubeEfi = "--uefi";
        } else {
            nodeImage = "kube-node.iso";
            kubeEfi = "";
        }
        String masterAddress = this.getMasterAddress();
        String joinToken = this.getJoinToken();
        int nodeId = 1 + this.workerNodes.size();
        String node = "kube-node-" + nodeId + "-state";
        File nodeDir = new File(k8sHome, node);
        Capture port = new Capture((Iterator)ports);
        if (this.clearState) {
            LOGGER.info("Deleting previous k8s master state in " + nodeDir);
            FileHelper.recursiveDelete((File)nodeDir);
        }
        nodeDir.mkdirs();
        File fileNodeISO = new File(nodeDir, nodeImage);
        if (!fileNodeISO.exists()) {
            Files.copy(new File(k8sHome, nodeImage).toPath(), fileNodeISO.toPath(), new CopyOption[0]);
        }
        this.ensureNodeMetaData(nodeDir, joinToken, masterAddress);
        LOGGER.info("Starting k8s worker node " + nodeId + "...");
        Application appNode = platform.launch(this.linuxKit, new Option[]{Argument.of((Object)"run", (Option[])new Option[0]), Argument.of((String)"-publish", (Object)(port.get() + ":22"), (Option[])new Option[0]), Argument.of((String)"-networking", (Object)"default", (Option[])new Option[0]), Argument.of((String)"-cpus", (Object)"2", (Option[])new Option[0]), Argument.of((String)"-mem", (Object)this.nodeMemory, (Option[])new Option[0]), Argument.of((String)"-disk", (Object)nodeDisc, (Option[])new Option[0]), Argument.of((String)"-state", (Object)nodeDir.getName(), (Option[])new Option[0]), Argument.of((String)"-data-file", (Object)(node + "/metadata.json"), (Option[])new Option[0]), Argument.of((Object)kubeEfi, (Option[])new Option[0]), Argument.of((Object)(nodeDir + "/" + nodeImage), (Option[])new Option[0]), WorkingDirectory.at((Object)this.linuxKitK8sHome), DisplayName.of((String)("k8s-node-" + nodeId)), console});
        RemotePlatform platformNode = new RemotePlatform("node-" + nodeId, InetAddress.getByName("localhost"), ((Integer)port.get()).intValue(), "root", (Authentication)SecureKeys.fromPrivateKeyFile((String)sshKey), new Option[]{WorkingDirectory.at((Object)"/root"), Deployer.NULL, ContainerdCommandInterceptor.instance(), StrictHostChecking.disabled(), UserKnownHostsFile.at((String)"/dev/null")});
        LOGGER.info("Waiting for k8s worker node " + nodeId + " VM to start...");
        Eventually.assertThat((Object)((LinuxKitK8sCluster)DeferredHelper.invoking((Object)this)).canConnectTo(platformNode), (Matcher)CoreMatchers.is((Object)true), (Option[])new Option[]{Timeout.after((long)2L, (TimeUnit)TimeUnit.MINUTES)});
        LOGGER.info("K8s worker node " + nodeId + " VM started");
        this.workerNodes.add((Pair<Application, RemotePlatform>)new Pair((Object)appNode, (Object)platformNode));
        return nodeId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isMasterReady() {
        CapturingApplicationConsole console = new CapturingApplicationConsole();
        String command = "kubectl";
        try (Application application = this.platformMaster.launch(command, new Option[]{Argument.of((Object)"--kubeconfig", (Option[])new Option[0]), Argument.of((Object)K8S_ADMIN_CONF, (Option[])new Option[0]), Arguments.of((Object[])new Object[]{"get", "nodes"}), Console.of((ApplicationConsole)console), LaunchLogging.disabled()});){
            int exitCode = application.waitFor(new Option[0]);
            if (exitCode == 0) {
                String line = console.getCapturedOutputLines().stream().filter(this::isMasterNodeLine).findFirst().orElse("");
                LOGGER.info("Master status check: line=" + line);
                boolean bl = "Ready".equalsIgnoreCase(this.getNodeStatus(line));
                return bl;
            }
            String lines = console.getCapturedOutputLines().stream().collect(Collectors.joining("\n")) + console.getCapturedErrorLines().stream().collect(Collectors.joining("\n"));
            LOGGER.info("Master status check: return code=" + exitCode + " console=\n" + lines);
            return false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean areAllNodesReady(int nodeCount) {
        CapturingApplicationConsole console = new CapturingApplicationConsole();
        String command = "kubectl";
        try (Application application = this.platformMaster.launch(command, new Option[]{Argument.of((Object)"--kubeconfig", (Option[])new Option[0]), Argument.of((Object)K8S_ADMIN_CONF, (Option[])new Option[0]), Arguments.of((Object[])new Object[]{"get", "nodes"}), Console.of((ApplicationConsole)console), LaunchLogging.disabled()});){
            int exitCode = application.waitFor(new Option[0]);
            LOGGER.info("Node status check: return code=" + exitCode + " console=\n" + console.getCapturedOutputLines().stream().collect(Collectors.joining("\n")) + console.getCapturedErrorLines().stream().collect(Collectors.joining("\n")));
            if (exitCode != 0) return false;
            Queue lines = console.getCapturedOutputLines();
            lines.poll();
            long readyCount = lines.stream().filter(s -> !"(terminated)".equals(s)).filter(s -> "ready".equalsIgnoreCase(this.getNodeStatus((String)s))).count();
            boolean bl = readyCount == (long)nodeCount;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isMasterVmRunning() {
        return this.appMaster != null && this.appMaster.isOperational();
    }

    public RemotePlatform getMasterPlatform() {
        if (this.isMasterVmRunning() && this.platformMaster != null) {
            throw new IllegalStateException("Master node is not running");
        }
        return this.platformMaster;
    }

    public LinuxKitK8sCluster withConsoleBuilder(ApplicationConsoleBuilder builder) {
        this.consoleBuilder = builder;
        return this;
    }

    public LinuxKitK8sCluster withLogsAt(File logDir) {
        this.logDir = logDir;
        return this;
    }

    public LinuxKitK8sCluster withWorkerCount(int count) {
        this.workerNodeCount = count;
        return this;
    }

    public LinuxKitK8sCluster withClearedState(boolean clear) {
        this.clearState = clear;
        return this;
    }

    public LinuxKitK8sCluster withIsoCopy(boolean copy) {
        this.copyISO = copy;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canConnectTo(RemotePlatform platform) {
        if (!this.isMasterVmRunning()) return false;
        try (Application application = platform.launch("echo connection test", new Option[]{LaunchLogging.disabled()});){
            int exitCode = application.waitFor(new Option[0]);
            boolean bl = exitCode == 0;
            return bl;
        }
        catch (Throwable throwable6) {
            // empty catch block
        }
        return false;
    }

    private void ensureMasterMetaData(File masterDir) throws IOException {
        File file = new File(masterDir, "metadata.json");
        if (!file.exists()) {
            try (PrintWriter writer = new PrintWriter(file);){
                writer.print("{ \"kubeadm\": { \"entries\": { \"init\": { \"content\": \"\" } } } }");
            }
        }
    }

    private void ensureNodeMetaData(File nodeDir, String joinToken, String masterAddress) throws IOException {
        File file = new File(nodeDir, "metadata.json");
        if (!file.exists()) {
            String nodeMetaData = String.format("{ \"kubeadm\": { \"entries\": { \"join\": { \"content\": \"--token %s %s:6443 --discovery-token-unsafe-skip-ca-verification\" }}}}", joinToken, masterAddress);
            try (PrintWriter writer = new PrintWriter(file);){
                writer.print(nodeMetaData);
            }
        }
    }

    private void writeKubectlConfig() throws IOException {
        LOGGER.info("Obtaining kubectl configuration from master...");
        Eventually.assertThat((Object)((LinuxKitK8sCluster)DeferredHelper.invoking((Object)this)).masterKubectlConfigExists(), (Matcher)CoreMatchers.is((Object)true), (Option[])new Option[]{Timeout.after((long)2L, (TimeUnit)TimeUnit.MINUTES)});
        CapturingApplicationConsole console = new CapturingApplicationConsole();
        String catCmd = "cat /etc/kubernetes/admin.conf";
        try (Application application = this.platformMaster.launch(catCmd, new Option[]{Console.of((ApplicationConsole)console)});){
            application.waitFor(new Option[0]);
        }
        File kubectlConfigFile = new File(this.tempFolder, "admin.conf");
        try (PrintWriter writer = new PrintWriter(kubectlConfigFile);){
            console.getCapturedOutputLines().stream().filter(line -> !line.contains("(terminated)")).map(this::convertLine).forEach(writer::println);
        }
        var5_7 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(kubectlConfigFile));){
            LOGGER.info(() -> "Saved kubectl configuration to " + kubectlConfigFile + "\n" + reader.lines().collect(Collectors.joining("\n")));
        }
        catch (Throwable throwable) {
            var5_7 = throwable;
            throw throwable;
        }
        this.withKubectlConfig(kubectlConfigFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean masterKubectlConfigExists() {
        try {
            String cmdTest = "test -f /etc/kubernetes/admin.conf";
            try (Application application = this.platformMaster.launch(cmdTest, new Option[]{DisplayName.of((String)"test"), LaunchLogging.disabled(), SystemApplicationConsole.builder()});){
                boolean bl = application.waitFor(new Option[0]) == 0;
                return bl;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    protected String getMasterAddress() {
        CapturingApplicationConsole console = new CapturingApplicationConsole();
        String command = "ip -f inet -o addr show eth0";
        try (Application kubectl = this.platformMaster.launch(command, new Option[]{Console.of((ApplicationConsole)console), LaunchLogging.disabled()});){
            if (kubectl.waitFor(new Option[0]) == 0) {
                String line = (String)console.getCapturedOutputLines().poll();
                String[] parts = line.split("\\s+");
                String ip = parts[3];
                String string = ip.split("/")[0];
                return string;
            }
        }
        return null;
    }

    protected String getJoinToken() {
        CapturingApplicationConsole console = new CapturingApplicationConsole();
        try (Application kubeadm = this.platformMaster.launch(SimpleApplication.class, new Option[]{Executable.named((String)"kubeadm"), Arguments.of((Object[])new Object[]{"token", "list"}), Console.of((ApplicationConsole)console), DisplayName.of((String)"kubeadm")});){
            Queue lines;
            if (kubeadm.waitFor(new Option[0]) == 0 && (lines = console.getCapturedOutputLines()).size() > 1) {
                lines.poll();
                String line = (String)lines.poll();
                String string = line.split("\\s+")[0];
                return string;
            }
        }
        return null;
    }

    private String convertLine(String line) {
        if (line.startsWith("    server: https://")) {
            return "    server: https://127.0.0.1:" + this.k8sPort.get();
        }
        return line;
    }

    static {
        String linux = System.getProperty("bedrock.linuxkit");
        if (linux == null || linux.isEmpty()) {
            linux = "/usr/local/bin/linuxkit";
        }
        LINUXKIT_CMD = linux;
    }
}

