/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.virtual.vagrant;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.OperatingSystem;
import com.oracle.bedrock.runtime.remote.options.HostName;
import com.oracle.bedrock.runtime.virtual.vagrant.VagrantFileBuilder;
import com.oracle.bedrock.runtime.virtual.vagrant.options.BoxName;
import com.oracle.bedrock.runtime.virtual.vagrant.options.Networks;
import com.oracle.bedrock.runtime.virtual.vagrant.options.UpdateBox;
import com.oracle.bedrock.runtime.virtual.vagrant.options.VagrantConfigurations;
import com.oracle.bedrock.runtime.virtual.vagrant.options.VagrantProperties;
import com.oracle.bedrock.runtime.virtual.vagrant.options.VagrantProperty;
import com.oracle.bedrock.runtime.virtual.vagrant.options.VagrantProvisioners;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Optional;

class OptionsBasedVagrantFileBuilder
implements VagrantFileBuilder {
    public static final String CONFIG_VM_BOX = ".vm.box";
    public static final String CONFIG_VM_BOX_CHECK_UPDATE = ".vm.box_check_update";
    private OptionsByType optionsByType;

    OptionsBasedVagrantFileBuilder(Option ... options) {
        this.optionsByType = OptionsByType.of((Option[])options);
        BoxName boxName = (BoxName)this.optionsByType.get(BoxName.class, new Object[0]);
        UpdateBox updateBox = (UpdateBox)this.optionsByType.get(UpdateBox.class, new Object[0]);
        this.optionsByType.add((Option)VagrantProperty.of(CONFIG_VM_BOX, boxName.get()));
        this.optionsByType.add((Option)VagrantProperty.of(CONFIG_VM_BOX_CHECK_UPDATE, updateBox.isEnabled()));
    }

    @Override
    public Optional<HostName> create(File file, OptionsByType createOptions) throws IOException {
        try (PrintWriter writer = new PrintWriter(file);){
            OptionsByType vagrantOptions = OptionsByType.of((OptionsByType)this.optionsByType).addAll(createOptions);
            writer.println("# -*- mode: ruby -*-");
            writer.println("# vi: set ft=ruby :");
            writer.println("");
            writer.println("# Vagrantfile API/syntax version. Don't touch unless you know what you're doing!");
            writer.println("VAGRANTFILE_API_VERSION = \"2\"");
            writer.println("");
            writer.println("Vagrant.configure(VAGRANTFILE_API_VERSION) do |config|");
            String prefix = "config";
            String padding = "";
            OperatingSystem operatingSystem = (OperatingSystem)vagrantOptions.getOrDefault(OperatingSystem.class, null);
            if (operatingSystem != null) {
                writer.println();
                writer.println(padding + operatingSystem.getName());
            }
            VagrantProvisioners provisioners = (VagrantProvisioners)vagrantOptions.get(VagrantProvisioners.class, new Object[0]);
            provisioners.write(writer, prefix, padding);
            VagrantConfigurations configurations = (VagrantConfigurations)vagrantOptions.get(VagrantConfigurations.class, new Object[0]);
            configurations.write(writer, padding);
            VagrantProperties properties = (VagrantProperties)vagrantOptions.get(VagrantProperties.class, new Object[0]);
            properties.write(writer, prefix, padding);
            Networks networks = (Networks)vagrantOptions.get(Networks.class, new Object[0]);
            Optional<HostName> hostName = networks.write(writer, prefix, padding);
            writer.println("end");
            writer.flush();
            Optional<HostName> optional = hostName;
            return optional;
        }
    }
}

