/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.virtual.vagrant;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.DisplayName;
import com.oracle.bedrock.runtime.options.Executable;
import com.oracle.bedrock.runtime.options.WorkingDirectory;
import com.oracle.bedrock.runtime.remote.SecureKeys;
import com.oracle.bedrock.runtime.remote.options.HostName;
import com.oracle.bedrock.runtime.remote.options.StrictHostChecking;
import com.oracle.bedrock.runtime.virtual.CloseAction;
import com.oracle.bedrock.runtime.virtual.VirtualPlatform;
import com.oracle.bedrock.runtime.virtual.vagrant.VagrantFileBuilder;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class VagrantPlatform
extends VirtualPlatform {
    public static final String DEFAULT_VAGRANT_COMMAND = "vagrant";
    private String vagrantCommand = VagrantPlatform.getDefaultVagrantCommand();
    private File workingDirectory;

    public VagrantPlatform(String name, VagrantFileBuilder builder, Option ... options) {
        this(name, builder, 22, options);
    }

    public VagrantPlatform(String name, VagrantFileBuilder builder, int port, Option ... options) {
        super(name, null, port, null, null, options);
        this.getOptions().addIfAbsent((Option)CloseAction.Destroy);
        this.getOptions().addIfAbsent((Option)Timeout.after((long)5L, (TimeUnit)TimeUnit.MINUTES));
        this.getOptions().add((Option)StrictHostChecking.disabled());
        this.getOptions().add((Option)DisplayName.of((String)name));
        WorkingDirectory directory = (WorkingDirectory)this.getOptions().getOrSetDefault(WorkingDirectory.class, (Option)WorkingDirectory.subDirectoryOf((File)new File(".")));
        File base = directory.resolve((Platform)this, this.getOptions());
        File file = this.workingDirectory = base == null ? new File(".", name) : new File(base, name);
        if (!this.workingDirectory.exists() && !this.workingDirectory.mkdirs()) {
            throw new RuntimeException("Could not create working directory: " + directory);
        }
        try {
            File vagrantFile = new File(this.workingDirectory, "Vagrantfile");
            Optional<HostName> hostName = builder.create(vagrantFile, this.getOptions());
            if (hostName.isPresent()) {
                this.getOptions().add((Option)hostName.get());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create VagrantFile at " + this.workingDirectory, e);
        }
        this.start();
    }

    public String getVagrantCommand() {
        return this.vagrantCommand;
    }

    public void setVagrantCommand(String vagrantCommand) {
        this.vagrantCommand = vagrantCommand;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getPublicHostName() {
        return ((HostName)this.getOptions().get(HostName.class, new Object[0])).get();
    }

    public void close() throws IOException {
        this.close(new Option[0]);
    }

    public void close(Option ... closeOptions) throws IOException {
        OptionsByType optionsByType = OptionsByType.of((OptionsByType)this.getOptions()).addAll(this.getDefaultOptions());
        optionsByType.addAll(closeOptions);
        CloseAction action = (CloseAction)optionsByType.getOrDefault(CloseAction.class, (Option)CloseAction.Destroy);
        switch (action) {
            case None: {
                return;
            }
            case Destroy: 
            case PowerButton: {
                optionsByType.add((Option)Arguments.of((Object[])new Object[]{"destroy", "--force"}));
                break;
            }
            case Shutdown: {
                optionsByType.add((Option)Argument.of((Object)"halt", (Option[])new Option[0]));
                break;
            }
            case SaveState: {
                optionsByType.add((Option)Argument.of((Object)"suspend", (Option[])new Option[0]));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported CloseAction " + action);
            }
        }
        this.execute(optionsByType);
    }

    public void start() {
        OptionsByType options = this.getDefaultOptions().add((Option)Argument.of((Object)"up", (Option[])new Option[0]));
        this.execute(options);
        Properties sshProperties = this.detectSSH();
        try {
            HostName hostName = (HostName)this.getOptions().get(HostName.class, new Object[0]);
            if (hostName == null || hostName.get().isEmpty()) {
                this.address = InetAddress.getLoopbackAddress();
                this.port = Integer.parseInt(sshProperties.getProperty("Port"));
                this.userName = sshProperties.getProperty("User");
                this.authentication = SecureKeys.fromPrivateKeyFile((String)sshProperties.getProperty("IdentityFile"));
            } else {
                this.address = InetAddress.getByName(hostName.get());
                this.userName = sshProperties.getProperty("User");
                this.authentication = SecureKeys.fromPrivateKeyFile((String)sshProperties.getProperty("IdentityFile"));
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Error setting public InetAddress", e);
        }
    }

    /*
     * Exception decompiling
     */
    protected Properties detectSSH() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void execute(OptionsByType optionsByType) {
        LocalPlatform platform = LocalPlatform.get();
        Timeout timeout = (Timeout)optionsByType.getOrDefault(Timeout.class, (Option)Timeout.after((long)5L, (TimeUnit)TimeUnit.MINUTES));
        try (Application application = platform.launch(Application.class, optionsByType.asArray());){
            application.waitFor(new Option[]{timeout});
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing Vagrant command", e);
        }
    }

    protected OptionsByType getDefaultOptions() {
        return OptionsByType.of((Option[])new Option[]{Executable.named((String)this.vagrantCommand), WorkingDirectory.at((File)this.workingDirectory), Timeout.after((long)5L, (TimeUnit)TimeUnit.MINUTES), DisplayName.of((String)"Vagrant")});
    }

    public static String getDefaultVagrantCommand() {
        return System.getProperty("vagrant.command", DEFAULT_VAGRANT_COMMAND);
    }
}

