/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.virtual.vagrant.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.remote.options.HostName;
import com.oracle.bedrock.runtime.virtual.vagrant.options.Network;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Collectors;

public class Networks
implements Option.Collector<Network, Networks> {
    private HashMap<String, Network> networks = new HashMap();

    private Networks() {
    }

    private Networks(Networks other) {
        this.networks.putAll(other.networks);
    }

    public Optional<HostName> write(PrintWriter writer, String prefix, String padding) {
        Optional<HostName> result = Optional.empty();
        for (Network network : this.networks.values()) {
            Optional<HostName> hostName = network.write(writer, prefix, padding);
            if (!network.isPublic() || !hostName.isPresent()) continue;
            result = hostName;
        }
        return result;
    }

    @OptionsByType.Default
    public static Networks none() {
        return new Networks();
    }

    public Networks with(Network network) {
        Networks networks = new Networks(this);
        networks.networks.put(network.getId(), network);
        return networks;
    }

    public Networks without(Network network) {
        if (this.networks.containsKey(network.getId())) {
            Networks networks = new Networks(this);
            networks.networks.remove(network.getId());
            return networks;
        }
        return this;
    }

    public <O> Iterable<O> getInstancesOf(Class<O> requiredClass) {
        return this.networks.values().stream().filter(network -> requiredClass.isInstance(network)).map(requiredClass::cast).collect(Collectors.toList());
    }

    public Iterator<Network> iterator() {
        return this.networks.values().iterator();
    }
}

