/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.virtual.vagrant.options;

import com.oracle.bedrock.ComposableOption;
import com.oracle.bedrock.OptionsByType;
import java.io.PrintWriter;
import java.util.ArrayList;

public class VagrantConfigurations
implements ComposableOption<VagrantConfigurations> {
    private ArrayList<String> configurations;

    public VagrantConfigurations() {
        this.configurations = new ArrayList();
    }

    public VagrantConfigurations(VagrantConfigurations other) {
        this.configurations = new ArrayList<String>(other.configurations);
    }

    @OptionsByType.Default
    public static VagrantConfigurations none() {
        return new VagrantConfigurations();
    }

    public static VagrantConfigurations of(String ... configurations) {
        VagrantConfigurations result = new VagrantConfigurations();
        if (configurations != null) {
            for (String configuration : configurations) {
                result.configurations.add(configuration);
            }
        }
        return result;
    }

    public VagrantConfigurations compose(VagrantConfigurations other) {
        VagrantConfigurations result = new VagrantConfigurations(this);
        result.configurations.addAll(other.configurations);
        return result;
    }

    public void write(PrintWriter writer, String padding) {
        for (String configuration : this.configurations) {
            writer.printf("%s%s\n", padding, configuration);
        }
        writer.println();
    }
}

