/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.virtual.vagrant.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.virtual.vagrant.options.VagrantProperties;
import java.io.PrintWriter;
import java.util.Iterator;

public class VagrantProperty
implements Option.Collectable {
    private final String name;
    private final Object value;

    private VagrantProperty(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public static VagrantProperty of(String name, String value) {
        return new VagrantProperty(name, value);
    }

    public static VagrantProperty of(String name, Iterator iterator) {
        return new VagrantProperty(name, iterator);
    }

    public static VagrantProperty of(String name, Object object) {
        return new VagrantProperty(name, object);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void write(PrintWriter writer, String sPrefix, String sPad) {
        Object resolvedValue = this.value;
        while (resolvedValue instanceof Iterator) {
            Iterator iterator = (Iterator)resolvedValue;
            if (iterator.hasNext()) {
                resolvedValue = iterator.next();
                continue;
            }
            throw new IndexOutOfBoundsException(String.format("No more values available for the property [%s]", this.name));
        }
        String valueString = resolvedValue instanceof String ? "'" + String.valueOf(resolvedValue) + "'" : (resolvedValue != null ? String.valueOf(resolvedValue) : "");
        writer.printf("%s    %s%s = %s\n", sPad, sPrefix, this.name, valueString);
    }

    public String toString() {
        return String.format("{name=%s, value=%s}", this.name, this.value);
    }

    public Class<VagrantProperties> getCollectorClass() {
        return VagrantProperties.class;
    }
}

