/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.virtual.vagrant;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationConsole;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.console.PipedApplicationConsole;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.Console;
import com.oracle.bedrock.runtime.options.DisplayName;
import com.oracle.bedrock.runtime.options.Executable;
import com.oracle.bedrock.runtime.options.WorkingDirectory;
import com.oracle.bedrock.runtime.remote.SecureKeys;
import com.oracle.bedrock.runtime.remote.options.HostName;
import com.oracle.bedrock.runtime.remote.options.StrictHostChecking;
import com.oracle.bedrock.runtime.virtual.CloseAction;
import com.oracle.bedrock.runtime.virtual.VirtualPlatform;
import com.oracle.bedrock.runtime.virtual.vagrant.VagrantFileBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class VagrantPlatform
extends VirtualPlatform {
    public static final String DEFAULT_VAGRANT_COMMAND = "vagrant";
    private String vagrantCommand = VagrantPlatform.getDefaultVagrantCommand();
    private File workingDirectory;

    public VagrantPlatform(String name, VagrantFileBuilder builder, Option ... options) {
        this(name, builder, 22, options);
    }

    public VagrantPlatform(String name, VagrantFileBuilder builder, int port, Option ... options) {
        super(name, null, port, null, null, options);
        this.getOptions().addIfAbsent((Option)CloseAction.Destroy);
        this.getOptions().addIfAbsent((Option)Timeout.after((long)5L, (TimeUnit)TimeUnit.MINUTES));
        this.getOptions().add((Option)StrictHostChecking.disabled());
        this.getOptions().add((Option)DisplayName.of((String)name));
        WorkingDirectory directory = (WorkingDirectory)this.getOptions().getOrSetDefault(WorkingDirectory.class, (Option)WorkingDirectory.subDirectoryOf((File)new File(".")));
        File base = directory.resolve((Platform)this, this.getOptions());
        File file = this.workingDirectory = base == null ? new File(".", name) : new File(base, name);
        if (!this.workingDirectory.exists() && !this.workingDirectory.mkdirs()) {
            throw new RuntimeException("Could not create working directory: " + directory);
        }
        try {
            File vagrantFile = new File(this.workingDirectory, "Vagrantfile");
            Optional<HostName> hostName = builder.create(vagrantFile, this.getOptions());
            if (hostName.isPresent()) {
                this.getOptions().add((Option)hostName.get());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create VagrantFile at " + this.workingDirectory, e);
        }
        this.start();
    }

    public String getVagrantCommand() {
        return this.vagrantCommand;
    }

    public void setVagrantCommand(String vagrantCommand) {
        this.vagrantCommand = vagrantCommand;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getPublicHostName() {
        return ((HostName)this.getOptions().get(HostName.class, new Object[0])).get();
    }

    public void close() throws IOException {
        this.close(new Option[0]);
    }

    public void close(Option ... closeOptions) throws IOException {
        OptionsByType optionsByType = OptionsByType.of((OptionsByType)this.getOptions()).addAll(this.getDefaultOptions());
        optionsByType.addAll(closeOptions);
        CloseAction action = (CloseAction)optionsByType.getOrDefault(CloseAction.class, (Option)CloseAction.Destroy);
        switch (action) {
            case None: {
                return;
            }
            case Destroy: 
            case PowerButton: {
                optionsByType.add((Option)Arguments.of((Object[])new Object[]{"destroy", "--force"}));
                break;
            }
            case Shutdown: {
                optionsByType.add((Option)Argument.of((Object)"halt", (Option[])new Option[0]));
                break;
            }
            case SaveState: {
                optionsByType.add((Option)Argument.of((Object)"suspend", (Option[])new Option[0]));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported CloseAction " + action);
            }
        }
        this.execute(optionsByType);
    }

    public void start() {
        OptionsByType options = this.getDefaultOptions().add((Option)Argument.of((Object)"up", (Option[])new Option[0]));
        this.execute(options);
        Properties sshProperties = this.detectSSH();
        try {
            HostName hostName = (HostName)this.getOptions().get(HostName.class, new Object[0]);
            if (hostName == null || hostName.get().isEmpty()) {
                this.address = InetAddress.getLoopbackAddress();
                this.port = Integer.parseInt(sshProperties.getProperty("Port"));
                this.userName = sshProperties.getProperty("User");
                this.authentication = SecureKeys.fromPrivateKeyFile((String)sshProperties.getProperty("IdentityFile"));
            } else {
                this.address = InetAddress.getByName(hostName.get());
                this.userName = sshProperties.getProperty("User");
                this.authentication = SecureKeys.fromPrivateKeyFile((String)sshProperties.getProperty("IdentityFile"));
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Error setting public InetAddress", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Properties detectSSH() {
        OptionsByType optionsByType = this.getDefaultOptions().add((Option)Argument.of((Object)"ssh-config", (Option[])new Option[0]));
        LocalPlatform platform = LocalPlatform.get();
        try (PipedApplicationConsole console = new PipedApplicationConsole();){
            Properties properties;
            block18: {
                Application application = platform.launch(Application.class, optionsByType.add((Option)Console.of((ApplicationConsole)console)).asArray());
                try {
                    application.waitFor(new Option[0]);
                    application.close();
                    Properties sshProperties = new Properties();
                    BufferedReader reader = console.getOutputReader();
                    String line = reader.readLine();
                    while (line != null) {
                        line = line.trim();
                        int index = line.indexOf(93);
                        index = line.indexOf(58, index);
                        if ((index = (line = line.substring(index + 1).trim()).indexOf(32)) > 0) {
                            String key = line.substring(0, index).trim();
                            String value = line.substring(index + 1).trim();
                            if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                                value = value.substring(1, value.length() - 1);
                            }
                            sshProperties.setProperty(key, value);
                        }
                        try {
                            line = reader.readLine();
                        }
                        catch (IOException e) {
                            line = null;
                        }
                    }
                    properties = sshProperties;
                    if (application == null) break block18;
                }
                catch (Throwable throwable) {
                    if (application != null) {
                        try {
                            application.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                application.close();
            }
            return properties;
        }
        catch (Exception e) {
            throw new RuntimeException("Error attempting to detect VM's SSH settings", e);
        }
    }

    protected void execute(OptionsByType optionsByType) {
        LocalPlatform platform = LocalPlatform.get();
        Timeout timeout = (Timeout)optionsByType.getOrDefault(Timeout.class, (Option)Timeout.after((long)5L, (TimeUnit)TimeUnit.MINUTES));
        try (Application application = platform.launch(Application.class, optionsByType.asArray());){
            application.waitFor(new Option[]{timeout});
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing Vagrant command", e);
        }
    }

    protected OptionsByType getDefaultOptions() {
        return OptionsByType.of((Option[])new Option[]{Executable.named((String)this.vagrantCommand), WorkingDirectory.at((File)this.workingDirectory), Timeout.after((long)5L, (TimeUnit)TimeUnit.MINUTES), DisplayName.of((String)"Vagrant")});
    }

    public static String getDefaultVagrantCommand() {
        return System.getProperty("vagrant.command", DEFAULT_VAGRANT_COMMAND);
    }
}

