/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.virtual.vagrant.options;

import com.oracle.bedrock.runtime.remote.options.HostName;
import com.oracle.bedrock.runtime.virtual.vagrant.options.AbstractNetwork;
import java.io.PrintWriter;
import java.util.Optional;

public class BridgedNetwork
extends AbstractNetwork {
    private String bridgeInterface;

    public BridgedNetwork(String id, String macAddress, String bridgeInterface) {
        super(id, macAddress);
        this.bridgeInterface = bridgeInterface;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    public String getBridgeInterface() {
        return this.bridgeInterface;
    }

    @Override
    public Optional<HostName> write(PrintWriter writer, String prefix, String padding) {
        String sMacAddress;
        writer.printf("%s    %s.vm.network ", padding, prefix);
        writer.print("\"public_network\"");
        if (this.bridgeInterface != null && !this.bridgeInterface.isEmpty()) {
            writer.printf(", bridge: %s", this.bridgeInterface);
        }
        if ((sMacAddress = this.getMacAddress()) != null && !sMacAddress.isEmpty()) {
            writer.printf(", mac: \"%s\"", sMacAddress);
        }
        writer.println();
        return Optional.empty();
    }
}

