/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.virtual.vagrant.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.virtual.vagrant.options.VagrantProvisioners;
import java.io.PrintWriter;

public class VagrantProvisioner
implements Option.Collectable {
    protected boolean runAlways = false;
    private final String type;
    private final String configuration;

    protected VagrantProvisioner(String type, String configuration) {
        this.type = type;
        this.configuration = configuration;
    }

    public boolean isRunAlways() {
        return this.runAlways;
    }

    public VagrantProvisioner runAlways() {
        this.runAlways = true;
        return this;
    }

    public VagrantProvisioner runOnce() {
        this.runAlways = false;
        return this;
    }

    public void write(PrintWriter writer, String prefix, String padding) {
        String sRunAlways = this.runAlways ? ", run: \"always\"" : "";
        writer.printf("%s    %s.vm.provision \"%s\"%s, ", padding, prefix, this.type, sRunAlways);
        writer.printf(this.configuration, new Object[0]);
        writer.println();
    }

    public Class<? extends Option.Collector> getCollectorClass() {
        return VagrantProvisioners.class;
    }

    public static VagrantProvisioner inlineShell(String cmd) {
        return new VagrantProvisioner("shell", String.format("inline: \"%s\"", cmd));
    }

    public static VagrantProvisioner file(String source, String destination) {
        return new VagrantProvisioner("file", String.format("source: \"%s\", destination: \"%s\"", source, destination));
    }

    public static VagrantProvisioner custom(String type, String configuraton) {
        return new VagrantProvisioner(type, configuraton);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VagrantProvisioner)) {
            return false;
        }
        VagrantProvisioner that = (VagrantProvisioner)o;
        if (this.runAlways != that.runAlways) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return this.configuration != null ? this.configuration.equals(that.configuration) : that.configuration == null;
    }

    public int hashCode() {
        int result = this.runAlways ? 1 : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
        return result;
    }
}

