/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.virtual.vagrant.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.virtual.vagrant.options.VagrantProvisioner;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Collectors;

public class VagrantProvisioners
implements Option.Collector<VagrantProvisioner, VagrantProvisioners> {
    private ArrayList<VagrantProvisioner> provisioners;

    public VagrantProvisioners() {
        this.provisioners = new ArrayList();
    }

    public VagrantProvisioners(VagrantProvisioners other) {
        this.provisioners = new ArrayList<VagrantProvisioner>(other.provisioners);
    }

    public void write(PrintWriter writer, String prefix, String padding) {
        this.provisioners.forEach(provisioner -> provisioner.write(writer, prefix, padding));
        writer.println();
    }

    @OptionsByType.Default
    public static VagrantProvisioners none() {
        return new VagrantProvisioners();
    }

    public VagrantProvisioners with(VagrantProvisioner provisioner) {
        VagrantProvisioners vagrantProvisioners = new VagrantProvisioners(this);
        vagrantProvisioners.provisioners.add(provisioner);
        return vagrantProvisioners;
    }

    public VagrantProvisioners without(VagrantProvisioner provisioner) {
        VagrantProvisioners vagrantProvisioners = new VagrantProvisioners(this);
        vagrantProvisioners.provisioners.remove(provisioner);
        return vagrantProvisioners;
    }

    public <O> Iterable<O> getInstancesOf(Class<O> requiredClass) {
        return this.provisioners.stream().filter(provisioner -> requiredClass.isInstance(provisioner)).map(provisioner -> provisioner).collect(Collectors.toList());
    }

    public Iterator<VagrantProvisioner> iterator() {
        return this.provisioners.iterator();
    }
}

