/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.virtual.vagrant.options;

import com.oracle.bedrock.runtime.remote.options.HostName;
import com.oracle.bedrock.runtime.virtual.HostAddressIterator;
import com.oracle.bedrock.runtime.virtual.vagrant.options.AbstractNetwork;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;

public class HostOnlyNetwork
extends AbstractNetwork {
    private Iterator<String> addresses;

    public HostOnlyNetwork(String id, String macAddress, Iterator<String> addresses) {
        super(id, macAddress);
        this.addresses = addresses;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    public HostOnlyNetwork withMacAddress(String macAddress) {
        return new HostOnlyNetwork(this.getId(), macAddress, this.addresses);
    }

    @Override
    public Optional<HostName> write(PrintWriter writer, String prefix, String padding) {
        String address;
        writer.printf("%s    %s.vm.network ", padding, prefix);
        writer.print("'private_network'");
        String string = this.addresses == null ? null : (address = this.addresses.hasNext() ? this.addresses.next() : null);
        if (address == null || address.isEmpty()) {
            writer.print(", type: 'dhcp'");
        } else {
            writer.printf(", ip: '%s'", address);
        }
        boolean autoConfig = true;
        writer.printf(", auto_config: %s", autoConfig);
        String sMacAddress = this.getMacAddress();
        if (sMacAddress != null && !sMacAddress.isEmpty()) {
            writer.printf(", mac: '%s'", sMacAddress);
        }
        writer.println();
        return address == null ? Optional.empty() : Optional.of(HostName.of((String)address));
    }

    public static HostOnlyNetwork dhcp() {
        return new HostOnlyNetwork(null, null, null);
    }

    public static HostOnlyNetwork of(String address) {
        return new HostOnlyNetwork(null, null, Collections.singleton(address).iterator());
    }

    public static HostOnlyNetwork from(Iterator<String> addresses) {
        return new HostOnlyNetwork(null, null, addresses);
    }

    public static HostOnlyNetwork startingAt(String startingAddress) {
        return new HostOnlyNetwork(null, null, (Iterator<String>)HostAddressIterator.startingAt((String)startingAddress));
    }
}

