/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.virtual.vagrant.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.virtual.vagrant.options.VagrantProperty;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class VagrantProperties
implements Option.Collector<VagrantProperty, VagrantProperties> {
    private LinkedHashMap<String, VagrantProperty> properties = new LinkedHashMap();

    @OptionsByType.Default
    public VagrantProperties() {
    }

    public VagrantProperties(Map<String, String> properties) {
        this();
        for (String name : properties.keySet()) {
            this.properties.put(name, VagrantProperty.of(name, properties.get(name)));
        }
    }

    public VagrantProperties(Properties properties) {
        this();
        for (String key : properties.stringPropertyNames()) {
            this.properties.put(key, VagrantProperty.of(key, properties.getProperty(key)));
        }
    }

    public VagrantProperties(VagrantProperties vagrantProperties) {
        this();
        this.properties.putAll(vagrantProperties.properties);
    }

    public VagrantProperties(VagrantProperty ... properties) {
        this();
        if (properties != null) {
            for (VagrantProperty property : properties) {
                this.add(property);
            }
        }
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public VagrantProperties add(VagrantProperty ... properties) {
        if (properties == null || properties.length == 0) {
            return this;
        }
        VagrantProperties vagrantProperties = new VagrantProperties(this);
        for (VagrantProperty property : properties) {
            vagrantProperties.properties.put(property.getName(), property);
        }
        return vagrantProperties;
    }

    public VagrantProperties addIfAbsent(VagrantProperty property) {
        if (property == null || this.properties.containsKey(property.getName())) {
            return this;
        }
        return this.add(property);
    }

    public VagrantProperties remove(String propertyName) {
        if (propertyName == null || propertyName.isEmpty() || !this.contains(propertyName)) {
            return this;
        }
        VagrantProperties vagrantProperties = new VagrantProperties(this);
        vagrantProperties.properties.remove(propertyName);
        return vagrantProperties;
    }

    public VagrantProperties addAll(Map<String, Object> properties) {
        VagrantProperties vagrantProperties = new VagrantProperties(this);
        for (String name : properties.keySet()) {
            vagrantProperties.properties.put(name, VagrantProperty.of(name, properties.get(name)));
        }
        return vagrantProperties;
    }

    public VagrantProperties addAll(VagrantProperties properties) {
        VagrantProperties vagrantProperties = new VagrantProperties(this);
        Iterator<VagrantProperty> iterator = properties.iterator();
        while (iterator.hasNext()) {
            VagrantProperty property = iterator.next();
            vagrantProperties.properties.put(property.getName(), property);
        }
        return vagrantProperties;
    }

    public boolean contains(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public VagrantProperty get(String propertyName) {
        return this.properties.get(propertyName);
    }

    public Object getProperty(String name) {
        if (this.properties.containsKey(name)) {
            VagrantProperty property = this.properties.get(name);
            return property.getValue();
        }
        return null;
    }

    public VagrantProperties with(VagrantProperty property) {
        return this.add(property);
    }

    public VagrantProperties without(VagrantProperty property) {
        return this.remove(property.getName());
    }

    public <O> Iterable<O> getInstancesOf(Class<O> requiredClass) {
        if (requiredClass.isAssignableFrom(VagrantProperty.class)) {
            return this.properties.values();
        }
        return Collections.EMPTY_LIST;
    }

    public Iterator<VagrantProperty> iterator() {
        return this.properties.values().iterator();
    }

    public void write(PrintWriter writer, String sPrefix, String sPad) {
        for (VagrantProperty property : this.properties.values()) {
            property.write(writer, sPrefix, sPad);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VagrantProperties)) {
            return false;
        }
        VagrantProperties that = (VagrantProperties)o;
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        return this.properties.hashCode();
    }
}

