/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.windows.winrm;

import com.oracle.bedrock.runtime.remote.windows.winrm.WindowsSession;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class InputStreamConnector
extends Thread
implements Closeable {
    private final WindowsSession session;
    private final InputStream inputStream;

    protected InputStreamConnector(WindowsSession session, InputStream inputStream) {
        super("InputStreamConnector-" + session.getCommandId());
        this.session = session;
        this.inputStream = inputStream;
        this.setDaemon(true);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public WindowsSession getSession() {
        return this.session;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public void run() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
        boolean run = true;
        while (run) {
            run = this.pollForInput(reader);
        }
    }

    protected boolean pollForInput(BufferedReader reader) {
        try {
            String line = reader.readLine();
            if (line == null) {
                return false;
            }
            this.session.writeToInputStream(line);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

