/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.windows.winrm;

import com.microsoft.wsman.shell.CommandStateType;
import com.microsoft.wsman.shell.ReceiveResponse;
import com.microsoft.wsman.shell.StreamType;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.remote.windows.winrm.WindowsSession;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class OutputStreamConnector
extends Thread
implements Closeable {
    private final AtomicBoolean run = new AtomicBoolean(true);
    private Integer exitCode = null;
    private final WindowsSession session;
    private OutputStream stdOut;
    private OutputStream stdErr;

    protected OutputStreamConnector(WindowsSession session, OutputStream stdOut, OutputStream stdErr) {
        super("OutputStreamConnector-" + session.getCommandId());
        this.session = session;
        this.stdOut = stdOut;
        this.stdErr = stdErr;
        this.setDaemon(true);
    }

    public OutputStream getOutputStream() {
        return this.stdOut;
    }

    public OutputStream getErrorStream() {
        return this.stdErr;
    }

    public WindowsSession getSession() {
        return this.session;
    }

    @Override
    public void close() {
        this.run.set(false);
        this.waitFor(new Option[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer waitFor(Option ... options) {
        OutputStreamConnector outputStreamConnector = this;
        synchronized (outputStreamConnector) {
            if (this.exitCode != null) {
                return this.exitCode;
            }
            OptionsByType optionsByType = OptionsByType.of((Option[])options);
            Timeout timeout = (Timeout)optionsByType.get(Timeout.class, new Object[0]);
            try {
                this.wait(timeout.to(TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.exitCode;
    }

    public int getExitCode() {
        return this.exitCode != null ? this.exitCode : -1;
    }

    public boolean pollOutput() throws IOException {
        CommandStateType commandState;
        ReceiveResponse response = this.session.readOutputStreams();
        boolean shouldContinue = true;
        for (StreamType output : response.getStream()) {
            if (!output.isSetName() || !output.isSetValue()) continue;
            if ("stderr".equals(output.getName()) && this.stdErr != null) {
                this.stdErr.write(output.getValue());
                this.stdErr.flush();
                continue;
            }
            if (!"stdout".equals(output.getName()) || this.stdOut == null) continue;
            this.stdOut.write(output.getValue());
            this.stdOut.flush();
        }
        if (response.isSetCommandState() && (commandState = response.getCommandState()).isSetExitCode()) {
            this.exitCode = commandState.getExitCode().intValue();
            shouldContinue = false;
        }
        return shouldContinue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.run.get()) {
                this.run.compareAndSet(true, this.pollOutput());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.exitCode = 1;
        }
        OutputStreamConnector outputStreamConnector = this;
        synchronized (outputStreamConnector) {
            if (this.exitCode == null) {
                this.exitCode = 0;
            }
            this.notifyAll();
        }
    }
}

