/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.windows.winrm;

import com.microsoft.wsman.fault.ProviderFaultType;
import com.microsoft.wsman.fault.WSManFaultType;
import java.io.Serializable;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.w3c.soap.envelope.Fault;
import org.w3c.soap.envelope.Faultreason;
import org.w3c.soap.envelope.Reasontext;

public class SoapFaultException
extends Exception {
    private Fault fault;

    public SoapFaultException(Fault fault) {
        this.fault = fault;
    }

    @Override
    public String getMessage() {
        List<Reasontext> textList;
        StringBuilder sb = new StringBuilder();
        if (this.fault.isSetDetail() && this.fault.getDetail().isSetAny()) {
            for (Object obj : this.fault.getDetail().getAny()) {
                if (obj instanceof JAXBElement) {
                    obj = ((JAXBElement)obj).getValue();
                }
                if (obj instanceof WSManFaultType) {
                    sb.append(this.faultTypeToString((WSManFaultType)obj));
                    continue;
                }
                if (obj == null) continue;
                sb.append(obj.toString());
            }
        } else {
            sb.append("Unknown SOAP Fault");
        }
        Faultreason reason = this.fault.getReason();
        if (reason != null && (textList = reason.getText()) != null) {
            for (int i = 0; i < textList.size(); ++i) {
                if (i == 0) {
                    sb.append(' ');
                } else {
                    sb.append('\n');
                }
                sb.append(textList.get(i).getValue());
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected String faultTypeToString(WSManFaultType type) {
        StringBuilder sb = new StringBuilder();
        if (type.isSetMessage() && type.getMessage().isSetContent()) {
            boolean first = true;
            for (Serializable serializable : type.getMessage().getContent()) {
                void var5_6;
                void var5_9;
                if (serializable instanceof JAXBElement) {
                    Object object = ((JAXBElement)serializable).getValue();
                }
                if (var5_9 instanceof ProviderFaultType) {
                    ProviderFaultType pft = (ProviderFaultType)var5_9;
                    if (pft.isSetProviderId()) {
                        sb.append("Provider: ").append(pft.getProviderId());
                    }
                    if (pft.isSetContent()) {
                        for (Object content : pft.getContent()) {
                            if (content instanceof JAXBElement) {
                                content = ((JAXBElement)content).getValue();
                            }
                            if (!(content instanceof WSManFaultType)) continue;
                            String string = this.faultTypeToString((WSManFaultType)content);
                        }
                    }
                }
                if (var5_6 == null) continue;
                if (!first) {
                    sb.append(' ');
                }
                sb.append(var5_6.toString().trim());
                first = false;
            }
        }
        if (type.isSetCode()) {
            String code = "Code: " + type.getCode();
            if (sb.length() == 0) {
                sb.append(code);
            } else if (sb.indexOf(code) == -1) {
                sb.append(" [").append(code).append("]");
            }
        }
        return sb.toString();
    }
}

