/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.windows.winrm;

import com.oracle.bedrock.ComposableOption;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.remote.windows.winrm.ObjectFactories;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.Duration;

public class WindowsSoapOptions
implements Option,
ComposableOption<WindowsSoapOptions> {
    public static final BigInteger DEFAULT_MAX_ENVELOPE_SIZE = new BigInteger("153600");
    public static final Duration DEFAULT_TIMEOUT = ObjectFactories.DATATYPE.newDuration(true, 0, 0, 0, 0, 5, 0);
    private Map<Type, Object> options;

    protected WindowsSoapOptions(Map<Type, Object> options) {
        this.options = new HashMap<Type, Object>(options);
    }

    public static WindowsSoapOptions basic() {
        return new WindowsSoapOptions(new HashMap<Type, Object>()).withMaxEnvelopeSize(DEFAULT_MAX_ENVELOPE_SIZE).withTimeout(5L, TimeUnit.MINUTES);
    }

    public Map<Type, Object> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public WindowsSoapOptions withMaxEnvelopeSize(BigInteger size) {
        this.options.put(Type.MaxEnvelopeSize, size);
        return this;
    }

    public BigInteger getMaxEnvelopeSize() {
        BigInteger size = (BigInteger)this.options.get((Object)Type.MaxEnvelopeSize);
        return size != null ? size : DEFAULT_MAX_ENVELOPE_SIZE;
    }

    public WindowsSoapOptions withTimeout(long timeout, TimeUnit units) {
        this.options.put(Type.Timeout, ObjectFactories.DATATYPE.newDuration(units.toMillis(timeout)));
        return this;
    }

    public Duration getTimeout() {
        Duration timeout = (Duration)this.options.get((Object)Type.Timeout);
        return timeout != null ? timeout : DEFAULT_TIMEOUT;
    }

    public WindowsSoapOptions compose(WindowsSoapOptions other) {
        HashMap<Type, Object> copy = new HashMap<Type, Object>(this.options);
        copy.putAll(other.options);
        return new WindowsSoapOptions(copy);
    }

    public static enum Type {
        MaxEnvelopeSize,
        Timeout;

    }
}

