/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.windows.winrm;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.options.HttpProxy;
import com.oracle.bedrock.runtime.remote.Authentication;
import com.oracle.bedrock.runtime.remote.http.HttpBasedAuthentication;
import com.oracle.bedrock.runtime.remote.windows.winrm.SoapFaultException;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.w3c.soap.envelope.Envelope;
import org.w3c.soap.envelope.Fault;

public class SoapConnection {
    private final URL url;
    private final String userName;
    private final HttpBasedAuthentication authentication;
    private final OptionsByType optionsByType;
    private JAXBContext jaxbContext;
    private final Marshaller marshaller;
    private final Unmarshaller unmarshaller;

    public SoapConnection(String hostName, int port, String servicePath, String userName, Authentication authentication, Option ... options) {
        this.userName = userName;
        this.optionsByType = OptionsByType.of((Option[])options);
        if (authentication instanceof HttpBasedAuthentication) {
            this.authentication = (HttpBasedAuthentication)authentication;
        } else if (authentication == null) {
            this.authentication = null;
        } else {
            throw new IllegalArgumentException("Authentication parameter must implement HttpBasedAuthentication");
        }
        try {
            this.url = new URL("http", hostName, port, servicePath);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Properties props = new Properties();
            props.load(classLoader.getResourceAsStream("ws-man.properties"));
            this.jaxbContext = JAXBContext.newInstance((String)props.getProperty("ws-man.packages"), (ClassLoader)classLoader);
            this.marshaller = this.createMarshaller();
            this.unmarshaller = this.createUnmarshaller();
        }
        catch (JAXBException | IOException e) {
            throw new RuntimeException("Could not create SoapConnection", e);
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public HttpBasedAuthentication getAuthentication() {
        return this.authentication;
    }

    Marshaller createMarshaller() throws JAXBException {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        return marshaller;
    }

    Unmarshaller createUnmarshaller() throws JAXBException {
        return this.jaxbContext.createUnmarshaller();
    }

    public List<Object> send(Envelope envelope) throws IOException {
        HttpURLConnection httpConnection;
        if (this.authentication == null) {
            HttpProxy proxy = (HttpProxy)this.optionsByType.getOrSetDefault(HttpProxy.class, (Option)HttpProxy.none());
            httpConnection = proxy.openConnection(this.url);
        } else {
            httpConnection = this.authentication.openConnection(this.url, this.userName, this.optionsByType);
        }
        return this.send(envelope, httpConnection);
    }

    /*
     * Exception decompiling
     */
    protected List<Object> send(Envelope envelope, HttpURLConnection httpConnection) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CASE], 8[SWITCH]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Object> getSOAPBodyContents(InputStream stream) throws JAXBException, IOException, SoapFaultException {
        Object result;
        try {
            Unmarshaller unmarshaller = this.unmarshaller;
            synchronized (unmarshaller) {
                result = this.unmarshaller.unmarshal(stream);
            }
        }
        finally {
            stream.close();
        }
        if (result instanceof JAXBElement) {
            JAXBElement elt = (JAXBElement)result;
            if (elt.getValue() instanceof Envelope) {
                List<Object> list = ((Envelope)elt.getValue()).getBody().getAny();
                for (int i = 0; i < list.size(); ++i) {
                    Object o = list.get(i);
                    if (o instanceof JAXBElement) {
                        o = ((JAXBElement)o).getValue();
                        list.set(i, o);
                    }
                    if (!(o instanceof Fault)) continue;
                    throw new SoapFaultException((Fault)o);
                }
                return list;
            }
            System.out.println("Unsupported element contents: " + elt.getValue().getClass().getName());
        } else {
            System.out.println("Unsupported class: " + result.getClass().getName());
        }
        return null;
    }
}

