/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.windows.winrm;

import com.microsoft.wsman.shell.CommandLine;
import com.microsoft.wsman.shell.CommandResponse;
import com.microsoft.wsman.shell.DesiredStreamType;
import com.microsoft.wsman.shell.EnvironmentVariable;
import com.microsoft.wsman.shell.EnvironmentVariableList;
import com.microsoft.wsman.shell.Receive;
import com.microsoft.wsman.shell.ReceiveResponse;
import com.microsoft.wsman.shell.Send;
import com.microsoft.wsman.shell.ShellType;
import com.microsoft.wsman.shell.Signal;
import com.microsoft.wsman.shell.StreamType;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.lang.StringHelper;
import com.oracle.bedrock.runtime.remote.Authentication;
import com.oracle.bedrock.runtime.remote.windows.winrm.InputStreamConnector;
import com.oracle.bedrock.runtime.remote.windows.winrm.ObjectFactories;
import com.oracle.bedrock.runtime.remote.windows.winrm.OutputStreamConnector;
import com.oracle.bedrock.runtime.remote.windows.winrm.SoapConnection;
import com.oracle.bedrock.runtime.remote.windows.winrm.WindowsShellOptions;
import com.oracle.bedrock.runtime.remote.windows.winrm.WindowsSoapOptions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.dmtf.wsman.AttributableDuration;
import org.dmtf.wsman.AttributableURI;
import org.dmtf.wsman.MaxEnvelopeSizeType;
import org.dmtf.wsman.OptionSet;
import org.dmtf.wsman.OptionType;
import org.dmtf.wsman.SelectorSetType;
import org.dmtf.wsman.SelectorType;
import org.w3c.soap.envelope.Body;
import org.w3c.soap.envelope.Envelope;
import org.w3c.soap.envelope.Header;
import org.xmlsoap.ws.addressing.AttributedURI;
import org.xmlsoap.ws.addressing.EndpointReferenceType;

public class WindowsSession
implements Closeable {
    public static final String ACTION_CREATE = "http://schemas.xmlsoap.org/ws/2004/09/transfer/Create";
    public static final String ACTION_COMMAND = "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/Command";
    public static final String ACTION_RECEIVE = "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/Receive";
    public static final String ACTION_SIGNAL = "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/Signal";
    public static final String ACTION_DELETE = "http://schemas.xmlsoap.org/ws/2004/09/transfer/Delete";
    public static final String ACTION_SEND = "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/Send";
    public static final String SIGNAL_TERM = "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/signal/terminate";
    public static final String URI_WINRM_RESOURCE = "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/cmd";
    public static final String URI_REPLY_TO = "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous";
    public static final int DEFAULT_WINRM_PORT = 5985;
    public static final String WSMAN_PATH = "/wsman";
    private OptionsByType optionsByType;
    private SoapConnection connection;
    private String shellReferenceId;
    private String commandId;
    private OutputStreamConnector outputStreamConnector;
    private InputStreamConnector inputStreamConnector;

    public WindowsSession(SoapConnection connection, Option ... options) {
        this.connection = connection;
        this.optionsByType = OptionsByType.of((Option[])options);
    }

    public WindowsSession(String hostName, int port, String userName, Authentication authentication, Option ... options) {
        this(new SoapConnection(hostName, port, WSMAN_PATH, userName, authentication, options), options);
    }

    public SoapConnection getSoapConnection() {
        return this.connection;
    }

    public String getShellReferenceId() {
        return this.shellReferenceId;
    }

    protected void setShellReferenceId(String id) {
        this.shellReferenceId = id;
    }

    public String getCommandId() {
        return this.commandId;
    }

    protected void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    protected InputStreamConnector getInputStreamConnector() {
        return this.inputStreamConnector;
    }

    protected void setInputStreamConnector(InputStreamConnector inputStreamConnector) {
        this.inputStreamConnector = inputStreamConnector;
    }

    protected OutputStreamConnector getOutputStreamConnector() {
        return this.outputStreamConnector;
    }

    protected void setOutputStreamConnector(OutputStreamConnector outputStreamConnector) {
        this.outputStreamConnector = outputStreamConnector;
    }

    @Override
    public void close() {
        if (this.shellReferenceId == null) {
            return;
        }
        try {
            try {
                this.terminateCommand();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.connection.send(this.createEnvelope(ACTION_DELETE));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.commandId = null;
            this.shellReferenceId = null;
        }
    }

    protected void connect() throws Exception {
        this.connect(null);
    }

    protected void connect(String workingDirectory) throws Exception {
        this.connect(workingDirectory, null);
    }

    protected void connect(String workingDirectory, Properties environment) throws IOException {
        if (this.shellReferenceId != null) {
            throw new IllegalStateException("Already connected to shell " + this.shellReferenceId);
        }
        WindowsShellOptions shellOptions = (WindowsShellOptions)this.optionsByType.getOrSetDefault(WindowsShellOptions.class, (Option)WindowsShellOptions.basic());
        ShellType shellType = ObjectFactories.SHELL.createShellType();
        if (workingDirectory == null || workingDirectory.isEmpty()) {
            shellType.setWorkingDirectory("%USERPROFILE%");
        } else {
            shellType.setWorkingDirectory(workingDirectory);
        }
        shellType.setLifetime(shellOptions.getShellLifetime());
        shellType.getInputStreams().add("stdin");
        shellType.getOutputStreams().add("stdout");
        shellType.getOutputStreams().add("stderr");
        if (environment != null && environment.size() > 0) {
            EnvironmentVariableList environmentVariableList = ObjectFactories.SHELL.createEnvironmentVariableList();
            List<EnvironmentVariable> variables = environmentVariableList.getVariable();
            for (String name : environment.stringPropertyNames()) {
                EnvironmentVariable variable = ObjectFactories.SHELL.createEnvironmentVariable();
                variable.setName(name);
                variable.setValue(StringHelper.doubleQuoteIfNecessary((String)environment.getProperty(name)));
                variables.add(variable);
            }
            shellType.setEnvironment(environmentVariableList);
        }
        AttributedURI toURI = ObjectFactories.ADDRESSING.createAttributedURI();
        toURI.setValue(this.connection.getUrl().toExternalForm());
        Properties properties = shellOptions.getBuilder().realize();
        OptionSet optionSet = ObjectFactories.WSMAN.createOptionSet();
        List<OptionType> optionsList = optionSet.getOption();
        for (String name : properties.stringPropertyNames()) {
            OptionType optionType = ObjectFactories.WSMAN.createOptionType();
            optionType.setName(name);
            optionType.setValue(properties.getProperty(name));
            optionsList.add(optionType);
        }
        Envelope envelope = this.createEnvelope(ACTION_CREATE);
        Header header = envelope.getHeader();
        List<Object> headerElements = header.getAny();
        headerElements.add(optionSet);
        envelope.getBody().getAny().add(ObjectFactories.SHELL.createShell(shellType));
        List<Object> results = this.connection.send(envelope);
        if (results != null) {
            ShellType resultShell = this.findFirst(results, ShellType.class);
            this.shellReferenceId = resultShell.getShellId();
        }
    }

    public void execute(String command, List<String> args, InputStream stdIn, OutputStream stdOut, OutputStream stdErr) throws IOException {
        Envelope envelope = this.createEnvelope(ACTION_COMMAND);
        Header header = envelope.getHeader();
        List<Object> headerElements = header.getAny();
        OptionType optionWinRSProfile = ObjectFactories.WSMAN.createOptionType();
        optionWinRSProfile.setName("WINRS_CONSOLEMODE_STDIN");
        optionWinRSProfile.setValue("TRUE");
        OptionSet optionSet = ObjectFactories.WSMAN.createOptionSet();
        List<OptionType> options = optionSet.getOption();
        options.add(optionWinRSProfile);
        headerElements.add(optionSet);
        CommandLine commandLine = ObjectFactories.SHELL.createCommandLine();
        List<String> arguments = commandLine.getArguments();
        commandLine.setCommand(command);
        arguments.addAll(args);
        envelope.getBody().getAny().add(ObjectFactories.SHELL.createCommandLine(commandLine));
        List<Object> results = this.connection.send(envelope);
        CommandResponse response = this.findFirst(results, CommandResponse.class);
        this.commandId = response.getCommandId();
        this.outputStreamConnector = this.createOutputStreamConnector(stdOut, stdErr);
        this.inputStreamConnector = this.createInputStreamConnector(stdIn);
        this.outputStreamConnector.start();
        this.inputStreamConnector.start();
    }

    protected OutputStreamConnector createOutputStreamConnector(OutputStream stdOut, OutputStream stdErr) {
        return new OutputStreamConnector(this, stdOut, stdErr);
    }

    protected InputStreamConnector createInputStreamConnector(InputStream stdIn) {
        return new InputStreamConnector(this, stdIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminateCommand() throws IOException {
        if (this.commandId == null || this.commandId.isEmpty()) {
            return;
        }
        try {
            Signal signal = ObjectFactories.SHELL.createSignal();
            signal.setCommandId(this.commandId);
            signal.setCode(SIGNAL_TERM);
            Envelope envelope = this.createEnvelope(ACTION_SIGNAL);
            envelope.getBody().getAny().add(ObjectFactories.SHELL.createSignal(signal));
            this.connection.send(envelope);
            if (this.outputStreamConnector != null) {
                this.outputStreamConnector.close();
            }
            try {
                if (this.inputStreamConnector != null) {
                    this.inputStreamConnector.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.commandId = null;
        }
    }

    protected ReceiveResponse readOutputStreams() throws IOException {
        Envelope envelope = this.createEnvelope(ACTION_RECEIVE);
        Header header = envelope.getHeader();
        List<Object> headerElements = header.getAny();
        OptionType optionType = ObjectFactories.WSMAN.createOptionType();
        optionType.setName("WSMAN_CMDSHELL_OPTION_KEEPALIVE");
        optionType.setValue("TRUE");
        OptionSet optionSet = ObjectFactories.WSMAN.createOptionSet();
        List<OptionType> options = optionSet.getOption();
        options.add(optionType);
        headerElements.add(optionSet);
        Receive receive = ObjectFactories.SHELL.createReceive();
        DesiredStreamType streamType = ObjectFactories.SHELL.createDesiredStreamType();
        streamType.setCommandId(this.commandId);
        streamType.getValue().add("stdout");
        streamType.getValue().add("stderr");
        receive.setDesiredStream(streamType);
        envelope.getBody().getAny().add(ObjectFactories.SHELL.createReceive(receive));
        List<Object> results = this.connection.send(envelope);
        return this.findFirst(results, ReceiveResponse.class);
    }

    protected void writeToInputStream(String message) throws IOException {
        if (this.commandId == null) {
            throw new IllegalStateException("Cannot pipe to StdIn if not executing a command");
        }
        Envelope envelope = this.createEnvelope(ACTION_SEND);
        Send send = ObjectFactories.SHELL.createSend();
        StreamType streamType = ObjectFactories.SHELL.createStreamType();
        streamType.setCommandId(this.commandId);
        streamType.setName("stdin");
        streamType.unsetEnd();
        streamType.setValue(message.getBytes());
        send.getStream().add(streamType);
        envelope.getBody().getAny().add(ObjectFactories.SHELL.createSend(send));
        this.connection.send(envelope);
    }

    protected Envelope createEnvelope(String action) throws IOException {
        if (action == null || action.isEmpty()) {
            throw new IllegalArgumentException("Actions string cannot be null or empty string");
        }
        Envelope envelope = ObjectFactories.SOAP.createEnvelope();
        Header header = ObjectFactories.SOAP.createHeader();
        Body body = ObjectFactories.SOAP.createBody();
        envelope.setHeader(header);
        envelope.setBody(body);
        List<Object> headerElements = header.getAny();
        AttributedURI toURI = ObjectFactories.ADDRESSING.createAttributedURI();
        toURI.setValue(this.connection.getUrl().toExternalForm());
        AttributedURI replyToURI = ObjectFactories.ADDRESSING.createAttributedURI();
        replyToURI.setValue(URI_REPLY_TO);
        EndpointReferenceType endpoint = ObjectFactories.ADDRESSING.createEndpointReferenceType();
        endpoint.setAddress(replyToURI);
        AttributedURI messageId = ObjectFactories.ADDRESSING.createAttributedURI();
        messageId.setValue("uuid:" + UUID.randomUUID().toString().toUpperCase());
        AttributableURI resourceURI = ObjectFactories.WSMAN.createAttributableURI();
        resourceURI.setValue(URI_WINRM_RESOURCE);
        WindowsSoapOptions soapOptions = (WindowsSoapOptions)this.optionsByType.getOrSetDefault(WindowsSoapOptions.class, (Option)WindowsSoapOptions.basic());
        MaxEnvelopeSizeType maxEnvelopeSize = ObjectFactories.WSMAN.createMaxEnvelopeSizeType();
        maxEnvelopeSize.setValue(soapOptions.getMaxEnvelopeSize());
        AttributableDuration timeout = ObjectFactories.WSMAN.createAttributableDuration();
        timeout.setValue(soapOptions.getTimeout());
        headerElements.add(ObjectFactories.ADDRESSING.createTo(toURI));
        headerElements.add(ObjectFactories.ADDRESSING.createReplyTo(endpoint));
        headerElements.add(ObjectFactories.ADDRESSING.createMessageID(messageId));
        headerElements.add(ObjectFactories.WSMAN.createResourceURI(resourceURI));
        headerElements.add(ObjectFactories.WSMAN.createMaxEnvelopeSize(maxEnvelopeSize));
        headerElements.add(ObjectFactories.WSMAN.createOperationTimeout(timeout));
        AttributedURI actionURI = ObjectFactories.ADDRESSING.createAttributedURI();
        actionURI.setValue(action);
        headerElements.add(ObjectFactories.ADDRESSING.createAction(actionURI));
        if (this.shellReferenceId != null) {
            SelectorSetType selectorSet = ObjectFactories.WSMAN.createSelectorSetType();
            List<SelectorType> selectors = selectorSet.getSelector();
            SelectorType shellSelector = ObjectFactories.WSMAN.createSelectorType();
            shellSelector.setName("ShellId");
            shellSelector.getContent().add((Serializable)((Object)this.shellReferenceId));
            selectors.add(shellSelector);
            headerElements.add(ObjectFactories.WSMAN.createSelectorSet(selectorSet));
        }
        return envelope;
    }

    protected <T> T findFirst(Collection<?> collection, Class<T> type) {
        for (Object o : collection) {
            if (!type.isAssignableFrom(o.getClass())) continue;
            return (T)o;
        }
        return null;
    }

    public int exitValue() {
        return this.outputStreamConnector != null ? this.outputStreamConnector.getExitCode() : -1;
    }

    public int waitFor(Option ... options) {
        return this.outputStreamConnector.waitFor(options);
    }
}

