/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.windows.winrm;

import com.oracle.bedrock.ComposableOption;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.PropertiesBuilder;
import com.oracle.bedrock.runtime.remote.windows.winrm.ObjectFactories;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.Duration;

public class WindowsShellOptions
implements Option,
ComposableOption<WindowsShellOptions> {
    public static final Duration DEFAULT_SHELL_LIFETIME = ObjectFactories.DATATYPE.newDuration(TimeUnit.MINUTES.toMillis(30L));
    private final PropertiesBuilder options;
    private Duration shellLifetime;

    private WindowsShellOptions() {
        this(new PropertiesBuilder(), DEFAULT_SHELL_LIFETIME);
    }

    private WindowsShellOptions(PropertiesBuilder variables, Duration shellLifetime) {
        this.options = variables;
        this.shellLifetime = shellLifetime;
    }

    public static WindowsShellOptions with(PropertiesBuilder builder) {
        WindowsShellOptions options = WindowsShellOptions.basic();
        options.options.addProperties(builder);
        return new WindowsShellOptions(new PropertiesBuilder(builder), DEFAULT_SHELL_LIFETIME);
    }

    public static WindowsShellOptions basic() {
        WindowsShellOptions shellOptions = new WindowsShellOptions();
        shellOptions.options.setProperty("WINRS_CONSOLEMODE_STDIN", (Object)true);
        shellOptions.options.setProperty("WINRS_NOPROFILE", (Object)false);
        shellOptions.options.setProperty("WINRS_CODEPAGE", (Object)437);
        return shellOptions;
    }

    public PropertiesBuilder getBuilder() {
        return this.options;
    }

    public WindowsShellOptions set(String name, Object value) {
        this.options.setProperty(name, value);
        return this;
    }

    public WindowsShellOptions setIfAbsent(String name, Object value) {
        this.options.setPropertyIfAbsent(name, value);
        return this;
    }

    public WindowsShellOptions set(String name, Iterator<?> iterator) {
        this.options.setProperty(name, iterator);
        return this;
    }

    public WindowsShellOptions setIfAbsent(String name, Iterator<?> iterator) {
        this.options.setPropertyIfAbsent(name, iterator);
        return this;
    }

    public WindowsShellOptions withLifetime(long lifetime, TimeUnit units) {
        this.shellLifetime = ObjectFactories.DATATYPE.newDuration(units.toMillis(lifetime));
        return this;
    }

    public Duration getShellLifetime() {
        return this.shellLifetime;
    }

    public WindowsShellOptions compose(WindowsShellOptions other) {
        WindowsShellOptions shellOptions = new WindowsShellOptions(new PropertiesBuilder(this.options), DEFAULT_SHELL_LIFETIME);
        shellOptions.options.addProperties(other.options);
        shellOptions.shellLifetime = other.shellLifetime != null ? other.shellLifetime : this.shellLifetime;
        return shellOptions;
    }
}

