/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.windows;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.remote.RemotePlatform;
import com.oracle.bedrock.runtime.remote.options.FileShareDeployer;
import com.oracle.bedrock.runtime.remote.windows.winrm.WindowsRemoteTerminal;
import java.io.IOException;

public class WindowsFileShareDeployer
extends FileShareDeployer {
    public WindowsFileShareDeployer(String localShareName, String remoteShareName, Option ... options) {
        super(localShareName, remoteShareName, options);
    }

    protected boolean performRemoteCopy(String source, String destination, Platform platform, OptionsByType deploymentOptions) throws IOException {
        if (platform instanceof RemotePlatform) {
            WindowsRemoteTerminal terminal = new WindowsRemoteTerminal((RemotePlatform)platform);
            OptionsByType optionsByType = OptionsByType.of((OptionsByType)platform.getOptions());
            optionsByType.addAll(deploymentOptions.asArray());
            terminal.moveFile(source, destination, optionsByType);
            return false;
        }
        throw new IllegalArgumentException("The platform argument must be an instance of a RemotePlatform");
    }
}

