/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.windows.http;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.lang.StringHelper;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationConsole;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.console.CapturingApplicationConsole;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Console;
import com.oracle.bedrock.runtime.options.DisplayName;
import com.oracle.bedrock.runtime.options.Executable;
import com.oracle.bedrock.runtime.options.WorkingDirectory;
import com.oracle.bedrock.runtime.remote.http.HttpDeployer;
import java.io.File;
import java.net.URL;

public class PowerShellHttpDeployer
extends HttpDeployer {
    public PowerShellHttpDeployer(Option ... options) {
        super(options);
    }

    protected void deployArtifact(URL sourceURL, String targetFileName, Platform platform) {
        int index = targetFileName.lastIndexOf(92);
        String parentFolder = index > 0 ? targetFileName.substring(0, index) : "C:\\";
        CapturingApplicationConsole console = new CapturingApplicationConsole();
        try (Application application = platform.launch(Application.class, new Option[]{Executable.named((String)"powershell"), Argument.of((Object)"-Command", (Option[])new Option[0]), Argument.of((Object)"Invoke-WebRequest", (Option[])new Option[0]), Argument.of((Object)"-Uri", (Option[])new Option[0]), Argument.of((Object)sourceURL.toExternalForm(), (Option[])new Option[0]), Argument.of((Object)"-OutFile", (Option[])new Option[0]), Argument.of((Object)StringHelper.doubleQuoteIfNecessary((String)targetFileName), (Option[])new Option[0]), WorkingDirectory.at((File)new File(parentFolder)), DisplayName.of((String)"Deploy"), Console.of((ApplicationConsole)console)});){
            int exitCode = application.waitFor(new Option[0]);
            if (exitCode != 0) {
                StringBuilder message = new StringBuilder("Error deploying ").append(targetFileName).append(" - PowerShell returned ").append(application.exitValue()).append("\n").append("Invoke-WebRequest output:");
                for (String line : console.getCapturedOutputLines()) {
                    message.append('\n').append(line);
                }
                for (String line : console.getCapturedErrorLines()) {
                    message.append('\n').append(line);
                }
                throw new RuntimeException(message.toString());
            }
        }
    }
}

