/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.windows.winrm;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.remote.RemoteApplicationProcess;
import com.oracle.bedrock.runtime.remote.windows.winrm.WindowsSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class WindowsRemoteApplicationProcess
implements RemoteApplicationProcess {
    private static AtomicLong idCounter = new AtomicLong(0L);
    private final WindowsSession session;
    private PipedInputStream pipedStdOutInputStream;
    private PipedOutputStream pipedStdOutOutputStream;
    private PipedInputStream pipedStdErrInputStream;
    private PipedOutputStream pipedStdErrOutputStream;
    private PipedInputStream pipedStdInInputStream;
    private PipedOutputStream pipedStdInOutputStream;
    private long id;

    public WindowsRemoteApplicationProcess(WindowsSession session) {
        try {
            this.session = session;
            this.id = idCounter.incrementAndGet();
            this.pipedStdOutInputStream = new PipedInputStream(2048);
            this.pipedStdErrInputStream = new PipedInputStream(2048);
            this.pipedStdInInputStream = new PipedInputStream(2048);
            this.pipedStdOutOutputStream = new PipedOutputStream(this.pipedStdOutInputStream);
            this.pipedStdErrOutputStream = new PipedOutputStream(this.pipedStdErrInputStream);
            this.pipedStdInOutputStream = new PipedOutputStream(this.pipedStdInInputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating remote process streams", e);
        }
    }

    public void close() {
        this.session.close();
    }

    public long getId() {
        return this.id;
    }

    public int exitValue() {
        return this.session.exitValue();
    }

    public InputStream getErrorStream() {
        return this.pipedStdErrInputStream;
    }

    public InputStream getInputStream() {
        return this.pipedStdOutInputStream;
    }

    public OutputStream getOutputStream() {
        return this.pipedStdInOutputStream;
    }

    public int waitFor(Option ... options) {
        return this.session.waitFor(new Option[0]);
    }

    public void execute(String command, List<String> args) throws IOException {
        this.session.execute(command, args, this.pipedStdInInputStream, this.pipedStdOutOutputStream, this.pipedStdErrOutputStream);
    }
}

