/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.remote.windows.winrm;

import com.oracle.bedrock.Bedrock;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.options.WorkingDirectory;
import com.oracle.bedrock.runtime.remote.AbstractRemoteTerminal;
import com.oracle.bedrock.runtime.remote.RemoteApplicationProcess;
import com.oracle.bedrock.runtime.remote.RemotePlatform;
import com.oracle.bedrock.runtime.remote.RemoteTerminal;
import com.oracle.bedrock.runtime.remote.windows.winrm.WindowsRemoteApplicationProcess;
import com.oracle.bedrock.runtime.remote.windows.winrm.WindowsSession;
import com.oracle.bedrock.table.Table;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WindowsRemoteTerminal
extends AbstractRemoteTerminal {
    private static final Logger LOGGER = Logger.getLogger(WindowsRemoteTerminal.class.getName());

    public WindowsRemoteTerminal(RemotePlatform platform) {
        super(platform);
    }

    public RemoteApplicationProcess launch(RemoteTerminal.Launchable launchable, Class<? extends Application> applicationClass, OptionsByType optionsByType) {
        try {
            String command = launchable.getCommandToExecute((Platform)this.getRemotePlatform(), optionsByType);
            List args = launchable.getCommandLineArguments((Platform)this.getRemotePlatform(), optionsByType);
            WindowsSession session = this.createSession();
            WorkingDirectory workingDirectory = (WorkingDirectory)optionsByType.get(WorkingDirectory.class, new Object[0]);
            session.connect(workingDirectory.resolve((Platform)this.getRemotePlatform(), optionsByType).toString(), launchable.getEnvironmentVariables((Platform)this.getRemotePlatform(), optionsByType));
            WindowsRemoteApplicationProcess process = new WindowsRemoteApplicationProcess(session);
            Table diagnosticsTable = (Table)optionsByType.get(Table.class, new Object[0]);
            if (diagnosticsTable != null && LOGGER.isLoggable(Level.INFO)) {
                diagnosticsTable.addRow(new String[]{"Application Executable ", command});
                LOGGER.log(Level.INFO, "Oracle Bedrock " + Bedrock.getVersion() + ": Starting Application...\n------------------------------------------------------------------------\n" + diagnosticsTable.toString() + "\n------------------------------------------------------------------------\n");
            }
            process.execute(command, args);
            return process;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create remote application", e);
        }
    }

    public void makeDirectories(String directoryName, OptionsByType optionsByType) {
        try (WindowsSession session = this.createSession();){
            session.connect();
            try (WindowsRemoteApplicationProcess process = new WindowsRemoteApplicationProcess(session);){
                process.execute("mkdir", Collections.singletonList(directoryName));
                int rc = process.waitFor(new Option[0]);
                if (rc != 0 && rc != 1) {
                    throw new RuntimeException("Error creating directory " + directoryName + " - mkdir returned " + rc);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating directory " + directoryName, e);
        }
    }

    public void moveFile(String source, String destination, OptionsByType optionsByType) {
        try (WindowsSession session = this.createSession();){
            session.connect();
            try (WindowsRemoteApplicationProcess process = new WindowsRemoteApplicationProcess(session);){
                process.execute("move", Arrays.asList(source, destination));
                int rc = process.waitFor(new Option[0]);
                if (rc != 0 && rc != 1) {
                    throw new RuntimeException("Error moving file from " + source + " to " + destination + " - move return code = " + rc);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error moving file from " + source + " to " + destination, e);
        }
    }

    protected WindowsSession createSession() {
        RemotePlatform platform = this.getRemotePlatform();
        return new WindowsSession(platform.getAddress().getHostName(), platform.getPort(), platform.getUserName(), platform.getAuthentication(), new Option[0]);
    }
}

