/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.console;

import com.oracle.bedrock.runtime.ApplicationConsole;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;
import java.io.Reader;

public abstract class AbstractPipedApplicationConsole
implements ApplicationConsole {
    public static final int DEFAULT_PIPE_SIZE = 1024;
    protected BufferedReader stdoutReader;
    protected PrintWriter stdoutWriter;
    protected PipedWriter stdoutPipedWriter;
    protected BufferedReader stderrReader;
    protected PrintWriter stderrWriter;
    protected PipedWriter stderrPipedWriter;
    protected PipedReader stdinReader;
    protected PrintWriter stdinWriter;
    protected boolean diagnosticMode;

    public AbstractPipedApplicationConsole(int pipeSize, boolean diagnosticMode) {
        try {
            PipedReader pipedOutputReader = new PipedReader(pipeSize);
            this.diagnosticMode = diagnosticMode;
            this.stdoutReader = new BufferedReader(pipedOutputReader);
            this.stdoutPipedWriter = new PipedWriter(pipedOutputReader);
            this.stdoutWriter = new PrintWriter(this.stdoutPipedWriter);
            PipedReader pipedErrorReader = new PipedReader(pipeSize);
            this.stderrReader = new BufferedReader(pipedErrorReader);
            this.stderrPipedWriter = new PipedWriter(pipedErrorReader);
            this.stderrWriter = new PrintWriter(this.stderrPipedWriter);
            this.stdinReader = new PipedReader(pipeSize);
            this.stdinWriter = new PrintWriter(new PipedWriter(this.stdinReader));
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating console streams", e);
        }
    }

    @Override
    public PrintWriter getOutputWriter() {
        return this.stdoutWriter;
    }

    @Override
    public PrintWriter getErrorWriter() {
        return this.stderrWriter;
    }

    @Override
    public Reader getInputReader() {
        return this.stdinReader;
    }

    @Override
    public boolean isDiagnosticsEnabled() {
        return this.diagnosticMode;
    }

    @Override
    public void close() {
        try {
            this.stdinReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.stdoutPipedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.stderrPipedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

