/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.console;

import com.oracle.bedrock.runtime.console.OutputRedirector;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class OutputToOutputStreamRedirector
extends OutputRedirector {
    public static final int DEFAULT_PIPE_SIZE = 1024;
    private final OutputStream outputStream;
    private final int bufferSize;
    private CountDownLatch running = new CountDownLatch(1);

    public OutputToOutputStreamRedirector(OutputStream outputStream) {
        this(outputStream, 1024);
    }

    public OutputToOutputStreamRedirector(OutputStream outputStream, int bufferSize) {
        this.outputStream = outputStream;
        this.bufferSize = bufferSize <= 0 ? 1024 : bufferSize;
    }

    public boolean isRunning() {
        return this.running.getCount() > 0L;
    }

    public boolean awaitRunning(long timeout, TimeUnit unit) throws InterruptedException {
        return this.running.await(timeout, unit);
    }

    @Override
    public void run() {
        try (OutputStream out = this.outputStream;){
            this.running.countDown();
            InputStream inputStream = this.getInputStream();
            byte[] buffer = new byte[this.bufferSize];
            int len = inputStream.read(buffer);
            while (len >= 0) {
                if (len > 0) {
                    out.write(buffer, 0, len);
                    out.flush();
                }
                len = inputStream.read(buffer);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

