/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.lang.StringHelper;
import com.oracle.bedrock.runtime.java.ClassPathModifier;
import com.oracle.bedrock.runtime.java.options.JavaModules;
import com.oracle.bedrock.runtime.options.PlatformSeparators;
import com.oracle.bedrock.table.Row;
import com.oracle.bedrock.table.Table;
import com.oracle.bedrock.table.Tabular;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassPath
implements Iterable<String>,
Tabular,
Option {
    public static final String[] JAVA_ARCHIVE_TYPES = new String[]{"aar", "car", "ear", "gar", "jar", "rar", "sar", "war", "zip"};
    private final LinkedHashSet<String> paths = new LinkedHashSet();
    private final Set<Pattern> excludes = new LinkedHashSet<Pattern>();
    private final boolean useDefaultExcludes;
    private static final Set<Pattern> defaultExcludes = new HashSet<Pattern>(Arrays.asList(Pattern.compile(".*idea_rt.*"), Pattern.compile(".*junit-rt.*"), Pattern.compile(".*junit5-rt.*"), Pattern.compile(".*surefire-.*")));

    public ClassPath() {
        this.useDefaultExcludes = true;
    }

    public ClassPath(ClassPath ... classPaths) {
        this(Arrays.stream(classPaths).allMatch(cp -> cp.useDefaultExcludes), classPaths);
    }

    private ClassPath(boolean defaultsExcludes, ClassPath ... classPaths) {
        this.useDefaultExcludes = defaultsExcludes;
        if (classPaths != null && classPaths.length > 0) {
            for (ClassPath classPath : classPaths) {
                for (String path : classPath) {
                    path = ClassPath.sanitizePath(path);
                    this.paths.add(path);
                }
                this.excludes.addAll(classPath.excludes);
            }
        }
    }

    public ClassPath(Iterable<ClassPath> classPaths) {
        boolean useDefaults = true;
        if (classPaths != null) {
            for (ClassPath classPath : classPaths) {
                useDefaults = useDefaults && classPath.useDefaultExcludes;
                for (String path : classPath) {
                    path = ClassPath.sanitizePath(path);
                    this.paths.add(path);
                }
                this.excludes.addAll(classPath.excludes);
            }
        }
        this.useDefaultExcludes = useDefaults;
    }

    public ClassPath(String ... classPaths) {
        this.useDefaultExcludes = true;
        if (classPaths != null) {
            for (String classPath : classPaths) {
                String[] paths;
                classPath = classPath == null ? "" : classPath.trim();
                if ((classPath = StringHelper.dequote((String)classPath)).isEmpty()) continue;
                for (String path : paths = classPath.split(File.pathSeparator)) {
                    if ((path = ClassPath.sanitizePath(path)).isEmpty()) continue;
                    this.paths.add(path);
                }
            }
        }
    }

    public int size() {
        return (int)this.paths.stream().filter(this::include).count();
    }

    public boolean isEmpty() {
        return this.paths.stream().noneMatch(this::include);
    }

    public URL[] getURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : this) {
            if (!this.include(path)) continue;
            try {
                urls.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to convert the path [" + path + "] into a URL", e);
            }
        }
        return (URL[])urls.toArray(URL[]::new);
    }

    public boolean contains(String path) {
        if (path == null || !this.include(path)) {
            return false;
        }
        path = ClassPath.sanitizePath(path);
        for (String aPath : this.paths) {
            if (!aPath.equals(path)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ClassPath classPath) {
        if (classPath == null) {
            return false;
        }
        for (String path : classPath) {
            if (this.contains(path)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<String> iterator() {
        return this.paths.stream().filter(this::include).collect(Collectors.toList()).iterator();
    }

    public String toString() {
        return this.toString(PlatformSeparators.autoDetect());
    }

    public String toString(OptionsByType optionsByType) {
        StringBuilder builder = new StringBuilder();
        PlatformSeparators separators = (PlatformSeparators)optionsByType.get(PlatformSeparators.class, new Object[0]);
        ClassPathModifier modifier = (ClassPathModifier)optionsByType.get(ClassPathModifier.class, new Object[0]);
        String pathSeparator = separators.getPathSeparator();
        Stream<String> stream = this.excludes.isEmpty() ? this.paths.stream().filter(this::include) : this.paths.stream().filter(this::include);
        stream.forEach(path -> {
            if (builder.length() > 0) {
                builder.append(pathSeparator);
            }
            builder.append((String)path);
        });
        return modifier.modify(builder.toString());
    }

    public String toString(Option ... options) {
        return this.toString(OptionsByType.of((Option[])options));
    }

    public Table getTable() {
        Table table = new Table(new Row[0]);
        for (String path : this) {
            if ("./".equals(path) || "./*".equals(path)) {
                table.addRow(new String[]{path});
                continue;
            }
            File file = new File(path);
            String parent = file.getParent();
            table.addRow(new String[]{file.getName(), parent == null ? "" : "(" + parent + ")"});
        }
        return table;
    }

    public ClassPath withDefaultExcludes() {
        return new ClassPath(true, this);
    }

    public ClassPath withoutDefaultExcludes() {
        return new ClassPath(false, this);
    }

    public ClassPath excluding(String ... exclude) {
        if (exclude == null || exclude.length == 0) {
            return this;
        }
        ClassPath classPath = new ClassPath(this);
        for (String ex : exclude) {
            classPath.excludes.add(Pattern.compile(ex));
        }
        return classPath;
    }

    public ClassPath excluding(ClassPath exclude) {
        if (exclude.isEmpty()) {
            return this;
        }
        ClassPath classPath = new ClassPath(this);
        for (String path : exclude.paths) {
            classPath.paths.remove(path);
        }
        return classPath;
    }

    private boolean include(String path) {
        boolean exclude = false;
        if (this.useDefaultExcludes) {
            exclude = defaultExcludes.stream().anyMatch(pattern -> pattern.matcher(path).matches());
        }
        if (!this.excludes.isEmpty()) {
            exclude = exclude || this.excludes.stream().anyMatch(pattern -> pattern.matcher(path).matches());
        }
        return !exclude;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClassPath classPath = (ClassPath)other;
        if (this.useDefaultExcludes != classPath.useDefaultExcludes) {
            return false;
        }
        return this.paths.equals(classPath.paths);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static String sanitizePath(String path) {
        if (path == null) {
            return "";
        }
        path = path.trim();
        if (!(path = StringHelper.unquote((String)path)).isEmpty()) {
            path = ClassPath.isResourceAnArchive(path) || path.endsWith(File.separator) || path.endsWith("*") ? path : path + File.separator;
        }
        return path;
    }

    public static boolean isResourceAnArchive(String resourceName) {
        return ClassPath.getResourceArchiveType(resourceName) != null;
    }

    public static String getResourceArchiveType(String resourceName) {
        String extension;
        resourceName = resourceName == null ? "" : resourceName.trim();
        int index = resourceName.lastIndexOf(".");
        if (index >= 0 && (index = Arrays.binarySearch(JAVA_ARCHIVE_TYPES, extension = resourceName.substring(index + 1).toLowerCase())) >= 0) {
            return JAVA_ARCHIVE_TYPES[index];
        }
        for (String archiveType : JAVA_ARCHIVE_TYPES) {
            if (!resourceName.startsWith(archiveType + ":")) continue;
            return archiveType;
        }
        return null;
    }

    public static ClassPath ofResource(String resourceName, ClassLoader classLoader) throws IOException {
        if (resourceName == null) {
            throw new NullPointerException("Resource name must not be null");
        }
        Enumeration<URL> resources = (classLoader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader).getResources(resourceName);
        if (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            String location = URLDecoder.decode(url.toExternalForm(), "UTF-8");
            location = location.replace(" ", "%20");
            String archiveType = ClassPath.getResourceArchiveType(location = location.substring(0, location.length() - resourceName.length() - 1));
            if (archiveType != null && location.startsWith(archiveType + ":")) {
                location = location.substring(archiveType.length() + 1, location.length() - 1);
            }
            try {
                return new ClassPath(new File(new URI(location)).getAbsolutePath());
            }
            catch (URISyntaxException e) {
                throw new IOException("Unable to create a ClassPath for [" + location + "] using ClassLoader [" + classLoader + "] as an illegal URI was encountered", e);
            }
        }
        throw new IOException("Unable to locate the specified resource [" + resourceName + "] using ClassLoader [" + classLoader + "] with ClassPath [" + ClassPath.ofSystem() + "]");
    }

    public static ClassPath ofResource(String resourceName) throws IOException {
        return ClassPath.ofResource(resourceName, Thread.currentThread().getContextClassLoader());
    }

    public static ClassPath ofClass(Class<?> clazz) throws IOException {
        if (clazz == null) {
            throw new NullPointerException("Class must not be null");
        }
        while (clazz.getEnclosingClass() != null) {
            clazz = clazz.getEnclosingClass();
        }
        String resourceName = clazz.getCanonicalName().replace(".", "/") + ".class";
        return ClassPath.ofResource(resourceName, clazz.getClassLoader());
    }

    public static ClassPath ofClass(String className, ClassLoader classLoader) throws ClassNotFoundException, IOException {
        Class<?> clazz = classLoader.loadClass(className);
        return ClassPath.ofClass(clazz);
    }

    public static ClassPath ofFile(File file) {
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        return new ClassPath(file.toString());
    }

    @OptionsByType.Default
    public static ClassPath automatic() {
        return JavaModules.useModules() ? ClassPath.ofModulePath() : ClassPath.ofSystem();
    }

    public static ClassPath ofModulePath() {
        String sProperty = System.getProperty("jdk.module.path");
        return sProperty == null || sProperty.isBlank() ? new ClassPath() : new ClassPath(sProperty);
    }

    public static ClassPath ofSystem() {
        String sProperty = System.getProperty("java.class.path");
        return sProperty == null || sProperty.isBlank() ? new ClassPath() : new ClassPath(sProperty);
    }

    public static ClassPath of(Iterable<String> paths) {
        if (paths == null) {
            return new ClassPath();
        }
        ArrayList<ClassPath> classPaths = new ArrayList<ClassPath>();
        for (String path : paths) {
            classPaths.add(new ClassPath(path));
        }
        return new ClassPath(classPaths);
    }

    public static ClassPath of(ClassPath ... classPaths) {
        if (classPaths == null) {
            return new ClassPath();
        }
        return new ClassPath(classPaths);
    }

    public static ClassPath of(String ... classPaths) {
        if (classPaths == null) {
            return new ClassPath();
        }
        return new ClassPath(classPaths);
    }
}

