/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java;

import com.oracle.bedrock.Bedrock;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.options.Variable;
import com.oracle.bedrock.runtime.ApplicationListener;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.Profiles;
import com.oracle.bedrock.runtime.PropertiesBuilder;
import com.oracle.bedrock.runtime.concurrent.PipeBasedRemoteChannel;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.concurrent.RemoteChannel;
import com.oracle.bedrock.runtime.concurrent.RemoteEvent;
import com.oracle.bedrock.runtime.concurrent.RemoteEventListener;
import com.oracle.bedrock.runtime.concurrent.RemoteRunnable;
import com.oracle.bedrock.runtime.concurrent.callable.RemoteCallableStaticMethod;
import com.oracle.bedrock.runtime.java.ClassPath;
import com.oracle.bedrock.runtime.java.JavaApplication;
import com.oracle.bedrock.runtime.java.JavaApplicationLauncher;
import com.oracle.bedrock.runtime.java.JavaApplicationProcess;
import com.oracle.bedrock.runtime.java.container.Container;
import com.oracle.bedrock.runtime.java.container.ContainerClassLoader;
import com.oracle.bedrock.runtime.java.container.ContainerScope;
import com.oracle.bedrock.runtime.java.features.JmxFeature;
import com.oracle.bedrock.runtime.java.options.ClassName;
import com.oracle.bedrock.runtime.java.options.RemoteEvents;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.profiles.CommercialFeatures;
import com.oracle.bedrock.runtime.java.profiles.RemoteDebugging;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.DisplayName;
import com.oracle.bedrock.table.Cell;
import com.oracle.bedrock.table.Row;
import com.oracle.bedrock.table.Table;
import com.oracle.bedrock.util.ReflectionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Internal
public class ContainerBasedJavaApplicationLauncher<A extends JavaApplication>
implements JavaApplicationLauncher<A> {
    private static final Logger LOGGER = Logger.getLogger(ContainerBasedJavaApplicationLauncher.class.getName());

    @Override
    public A launch(Platform platform, MetaClass<A> metaClass, OptionsByType optionsByType) {
        Table diagnosticsTable = new Table(new Row[0]);
        diagnosticsTable.getOptions().add((Option)Table.orderByColumn((int)0));
        if (platform != null) {
            diagnosticsTable.addRow(new String[]{"Target Platform", platform.getName()});
        }
        OptionsByType launchOptions = OptionsByType.of((Option[])platform.getOptions().asArray());
        metaClass.onLaunching(platform, launchOptions);
        launchOptions.addAll(optionsByType);
        launchOptions.add((Option)Variable.with((String)"bedrock.runtime.id", (Object)UUID.randomUUID()));
        launchOptions.get(RemoteDebugging.class, new Object[0]);
        launchOptions.get(CommercialFeatures.class, new Object[0]);
        launchOptions.addAll(Profiles.getProfiles());
        for (Profile profile : launchOptions.getInstancesOf(Profile.class)) {
            profile.onLaunching(platform, metaClass, launchOptions);
        }
        metaClass.onLaunch(platform, launchOptions);
        DisplayName displayName = this.getDisplayName(launchOptions);
        try {
            JavaApplication application;
            Table systemPropertiesTable = new Table(new Row[0]);
            systemPropertiesTable.getOptions().add((Option)Table.orderByColumn((int)0));
            systemPropertiesTable.getOptions().add((Option)Cell.Separator.of((String)""));
            Properties systemProperties = ((SystemProperties)launchOptions.get(SystemProperties.class, new Object[0])).resolve(platform, launchOptions);
            for (String propertyName : systemProperties.stringPropertyNames()) {
                String propertyValue = systemProperties.getProperty(propertyName);
                systemPropertiesTable.addRow(new String[]{propertyName, propertyValue});
            }
            diagnosticsTable.addRow(new String[]{"System Properties", systemPropertiesTable.toString()});
            ClassPath classPath = (ClassPath)launchOptions.get(ClassPath.class, new Object[0]);
            Table classPathTable = classPath.getTable();
            classPathTable.getOptions().add((Option)Cell.Separator.of((String)""));
            diagnosticsTable.addRow(new String[]{"Class Path", classPathTable.toString()});
            ContainerClassLoader classLoader = ContainerClassLoader.newInstance(displayName.resolve(launchOptions), classPath, systemProperties);
            List<String> argList = ((Arguments)launchOptions.get(Arguments.class, new Object[0])).resolve(platform, launchOptions);
            launchOptions.add((Option)Arguments.of(argList));
            ClassName className = (ClassName)launchOptions.get(ClassName.class, new Object[0]);
            if (className == null) {
                throw new IllegalArgumentException("Java Application ClassName not specified");
            }
            String applicationClassName = className.getName();
            ApplicationController controller = (ApplicationController)launchOptions.getOrSetDefault(ApplicationController.class, (Option)(metaClass instanceof ApplicationController ? (ApplicationController)((Object)metaClass) : null));
            if (controller == null) {
                controller = new StandardController(applicationClassName, argList);
                Class<?> clazz = classLoader.loadClass(applicationClassName);
            }
            diagnosticsTable.addRow(new String[]{"Application Class", applicationClassName});
            diagnosticsTable.addRow(new String[]{"Application", displayName.resolve(launchOptions)});
            Object arguments = "";
            for (String argument : argList) {
                arguments = (String)arguments + argument + " ";
            }
            if (((String)arguments).length() > 0) {
                diagnosticsTable.addRow(new String[]{"Application Arguments", arguments});
            }
            diagnosticsTable.addRow(new String[]{"Application Launch Time", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())});
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Oracle Bedrock " + Bedrock.getVersion() + ": Starting Application...\n------------------------------------------------------------------------\n" + diagnosticsTable.toString() + "\n------------------------------------------------------------------------\n");
            }
            ContainerBasedJavaApplicationProcess process = new ContainerBasedJavaApplicationProcess(classLoader, controller, systemProperties);
            RemoteEvents remoteEvents = (RemoteEvents)launchOptions.get(RemoteEvents.class, new Object[0]);
            remoteEvents.forEach((remoteEventListener, listenerOptions) -> process.addListener((RemoteEventListener)remoteEventListener, (Option)listenerOptions));
            Container.manage(classLoader.getContainerScope());
            process.start(launchOptions);
            Properties environmentVariables = PropertiesBuilder.fromCurrentEnvironmentVariables().realize();
            diagnosticsTable.addRow(new String[]{"Environment Variables", "(based on this Java Virtual Machine)"});
            Class<A> applicationClass = metaClass.getImplementationClass(platform, launchOptions);
            try {
                Constructor constructor = ReflectionHelper.getCompatibleConstructor(applicationClass, (Class[])new Class[]{platform.getClass(), process.getClass(), launchOptions.getClass()});
                application = (JavaApplication)constructor.newInstance(platform, process, launchOptions);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate the Application class specified by the MetaClass:" + metaClass);
            }
            if (JmxFeature.isSupportedBy(application)) {
                application.add((Object)new JmxFeature());
            }
            metaClass.onLaunched(platform, application, launchOptions);
            for (Profile profile : launchOptions.getInstancesOf(Profile.class)) {
                profile.onLaunched(platform, application, launchOptions);
            }
            for (ApplicationListener listener : launchOptions.getInstancesOf(ApplicationListener.class)) {
                listener.onLaunched(application);
            }
            return (A)application;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start ContainerBasedJavaProcess", e);
        }
    }

    public static void configureRemoteChannel(ContainerClassLoader containerClassLoader, PipedOutputStream pipedOutputStream, PipedInputStream pipedInputStream, String targetClassName) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(containerClassLoader);
            Container.associateThreadWith(containerClassLoader.getContainerScope());
            Class<?> remoteChannelClass = containerClassLoader.loadClass(PipeBasedRemoteChannel.class.getName());
            Constructor<?> constructor = remoteChannelClass.getConstructor(PipedOutputStream.class, PipedInputStream.class);
            Object remoteChannel = constructor.newInstance(pipedOutputStream, pipedInputStream);
            remoteChannelClass.getMethod("open", new Class[0]).invoke(remoteChannel, new Object[0]);
            containerClassLoader.getContainerScope().setRemoteChannel(remoteChannel);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Container.dissociateThread();
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public static interface ApplicationController
    extends Option {
        public CompletableFuture<Void> start(ControllableApplication var1);

        public CompletableFuture<Void> destroy(ControllableApplication var1);

        public void configure(ContainerClassLoader var1, PipedOutputStream var2, PipedInputStream var3, OptionsByType var4);
    }

    public static class StandardController
    implements ApplicationController {
        private String applicationClassName;
        private List<String> arguments;

        public StandardController(String applicationClassName, List<String> arguments) {
            this.applicationClassName = applicationClassName;
            this.arguments = arguments == null ? new ArrayList<String>(0) : new ArrayList<String>(arguments);
        }

        public String getApplicationClassName() {
            return this.applicationClassName;
        }

        public List<String> getArguments() {
            return new ArrayList<String>(this.arguments);
        }

        @Override
        public CompletableFuture<Void> start(ControllableApplication application) {
            RemoteCallableStaticMethod callable = new RemoteCallableStaticMethod(this.applicationClassName, "main", this.arguments);
            return application.submit(callable, new Option[0]);
        }

        @Override
        public CompletableFuture<Void> destroy(ControllableApplication application) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public void configure(ContainerClassLoader containerClassLoader, PipedOutputStream pipedOutputStream, PipedInputStream pipedInputStream, OptionsByType optionsByType) {
            ContainerBasedJavaApplicationLauncher.configureRemoteChannel(containerClassLoader, pipedOutputStream, pipedInputStream, this.applicationClassName);
        }
    }

    public static class ContainerBasedJavaApplicationProcess
    implements JavaApplicationProcess,
    ControllableApplication {
        private Properties systemProperties;
        private ContainerClassLoader containerClassLoader;
        private ApplicationController applicationController;
        private CompletableFuture<Void> startListener;
        private CompletableFuture<Void> destroyListener;
        private PipeBasedRemoteChannel channel;
        private PipedInputStream inboundChannelInputStream;
        private PipedOutputStream inboundChannelOutputStream;
        private PipedInputStream outboundChannelInputStream;
        private PipedOutputStream outboundChannelOutputStream;

        public ContainerBasedJavaApplicationProcess(ContainerClassLoader classLoader, ApplicationController controller, Properties systemProperties) throws IOException {
            if (controller == null) {
                throw new NullPointerException("ApplicationController must not be null");
            }
            this.containerClassLoader = classLoader;
            this.applicationController = controller;
            int bufferSizeInBytes = 65536;
            this.inboundChannelInputStream = new PipedInputStream(bufferSizeInBytes);
            this.inboundChannelOutputStream = new PipedOutputStream(this.inboundChannelInputStream);
            this.outboundChannelInputStream = new PipedInputStream(bufferSizeInBytes);
            this.outboundChannelOutputStream = new PipedOutputStream(this.outboundChannelInputStream);
            this.channel = new PipeBasedRemoteChannel(this.outboundChannelOutputStream, this.inboundChannelInputStream);
            this.systemProperties = systemProperties;
        }

        @Override
        public Properties getSystemProperties() {
            return this.systemProperties;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.containerClassLoader;
        }

        @Override
        public long getId() {
            return -1L;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.containerClassLoader.getContainerScope().getStandardInputOutputStream();
        }

        @Override
        public InputStream getInputStream() {
            return this.containerClassLoader.getContainerScope().getStandardOutputInputStream();
        }

        @Override
        public InputStream getErrorStream() {
            return this.containerClassLoader.getContainerScope().getStandardErrorInputStream();
        }

        @Override
        public int waitFor(Option ... options) {
            if (this.applicationController != null) {
                try {
                    if (this.startListener != null) {
                        this.startListener.get();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while waiting for application to terminate", e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getCause());
                }
            }
            return 0;
        }

        @Override
        public int exitValue() {
            return 0;
        }

        public void start(OptionsByType optionsByType) {
            if (this.applicationController == null) {
                this.startListener = null;
            } else {
                this.applicationController.configure(this.containerClassLoader, this.inboundChannelOutputStream, this.outboundChannelInputStream, optionsByType);
                this.channel.open();
                this.startListener = this.applicationController.start(this);
            }
        }

        @Override
        public void close() {
            if (this.applicationController != null) {
                try {
                    this.destroyListener = this.applicationController.destroy(this);
                    this.destroyListener.get();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "An exception occurred while closing the application", e);
                }
                this.applicationController = null;
            }
            this.channel.close();
            ContainerScope scope = this.containerClassLoader.getContainerScope();
            scope.close();
            Container.unmanage(scope);
        }

        @Override
        public <T> CompletableFuture<T> submit(RemoteCallable<T> callable, Option ... options) {
            if (this.applicationController == null) {
                IllegalStateException e = new IllegalStateException("Attempting to submit to a ContainerBasedJavaProcess that has been destroyed");
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(e);
                return future;
            }
            return this.channel.submit(callable, new Option[0]);
        }

        @Override
        public CompletableFuture<Void> submit(RemoteRunnable runnable, Option ... options) throws IllegalStateException {
            if (this.applicationController == null) {
                throw new IllegalStateException("Attempting to submit to a ContainerBasedJavaProcess that has been destroyed");
            }
            return this.channel.submit(runnable, new Option[0]);
        }

        @Override
        public void addListener(RemoteEventListener listener, Option ... options) {
            if (this.applicationController == null) {
                throw new IllegalStateException("Attempting to add a listener to a ContainerBasedJavaProcess that has been destroyed");
            }
            this.channel.addListener(listener, options);
        }

        @Override
        public void removeListener(RemoteEventListener listener, Option ... options) {
            if (this.applicationController == null) {
                throw new IllegalStateException("Attempting to remove a listener from a ContainerBasedJavaProcess that has been destroyed");
            }
            this.channel.removeListener(listener, options);
        }

        @Override
        public CompletableFuture<Void> raise(RemoteEvent event, Option ... options) {
            if (this.applicationController == null) {
                throw new IllegalStateException("Attempting to raise a RemoteEvent on a ContainerBasedJavaProcess that has been destroyed");
            }
            return this.channel.raise(event, options);
        }
    }

    public static class NullController
    implements ApplicationController {
        @Override
        public CompletableFuture<Void> start(ControllableApplication application) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> destroy(ControllableApplication application) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public void configure(ContainerClassLoader containerClassLoader, PipedOutputStream pipedOutputStream, PipedInputStream pipedInputStream, OptionsByType optionsByType) {
            ContainerBasedJavaApplicationLauncher.configureRemoteChannel(containerClassLoader, pipedOutputStream, pipedInputStream, null);
        }
    }

    public static class CustomController
    implements ApplicationController {
        private RemoteCallableStaticMethod<Void> m_callableStartStaticMethod;
        private RemoteCallableStaticMethod<Void> m_callableDestroyStaticMethod;

        public CustomController(RemoteCallableStaticMethod<Void> callableStartStaticMethod) {
            this(callableStartStaticMethod, null);
        }

        public CustomController(RemoteCallableStaticMethod<Void> callableStartStaticMethod, RemoteCallableStaticMethod<Void> callableDestroyStaticMethod) {
            this.m_callableStartStaticMethod = callableStartStaticMethod;
            this.m_callableDestroyStaticMethod = callableDestroyStaticMethod;
        }

        @Override
        public CompletableFuture<Void> start(ControllableApplication application) {
            if (this.m_callableStartStaticMethod == null) {
                return CompletableFuture.completedFuture(null);
            }
            return application.submit(this.m_callableStartStaticMethod, new Option[0]);
        }

        @Override
        public CompletableFuture<Void> destroy(ControllableApplication application) {
            if (this.m_callableDestroyStaticMethod == null) {
                return CompletableFuture.completedFuture(null);
            }
            return application.submit(this.m_callableDestroyStaticMethod, new Option[0]);
        }

        @Override
        public void configure(ContainerClassLoader containerClassLoader, PipedOutputStream pipedOutputStream, PipedInputStream pipedInputStream, OptionsByType optionsByType) {
            ContainerBasedJavaApplicationLauncher.configureRemoteChannel(containerClassLoader, pipedOutputStream, pipedInputStream, null);
        }
    }

    public static interface ControllableApplication
    extends RemoteChannel {
        public ClassLoader getClassLoader();
    }
}

