/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.options.EnvironmentVariables;
import java.util.Iterator;
import java.util.Objects;

public class EnvironmentVariable
implements Option.Collectable {
    private String name;
    private Object value;

    private EnvironmentVariable(EnvironmentVariable property) {
        this.name = property.getName();
        this.value = property.getValue();
    }

    private EnvironmentVariable(String name) {
        this.name = name;
        this.value = "";
    }

    private EnvironmentVariable(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public static EnvironmentVariable of(String name) {
        return new EnvironmentVariable(name, "");
    }

    public static EnvironmentVariable of(String name, String value) {
        return new EnvironmentVariable(name, value);
    }

    public static EnvironmentVariable of(String name, ContextSensitiveValue value) {
        return new EnvironmentVariable(name, value);
    }

    public static EnvironmentVariable of(String name, Iterator iterator) {
        return new EnvironmentVariable(name, iterator);
    }

    public static EnvironmentVariable of(String name, Object object) {
        return new EnvironmentVariable(name, object);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("{name=%s, value=%s}", this.name, this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentVariable that = (EnvironmentVariable)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public Class<EnvironmentVariables> getCollectorClass() {
        return EnvironmentVariables.class;
    }

    public static interface ContextSensitiveValue {
        public Object getValue(String var1, Platform var2, Option ... var3);
    }
}

