/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.junit;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.deferred.DeferredHelper;
import com.oracle.bedrock.junit.SessionBuilder;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.coherence.CoherenceCluster;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterBuilder;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterMember;
import com.oracle.bedrock.runtime.coherence.callables.GetAutoStartServiceNames;
import com.oracle.bedrock.runtime.coherence.options.ClusterName;
import com.oracle.bedrock.runtime.coherence.options.ClusterPort;
import com.oracle.bedrock.runtime.coherence.options.LocalHost;
import com.oracle.bedrock.runtime.coherence.options.LocalStorage;
import com.oracle.bedrock.runtime.coherence.options.Multicast;
import com.oracle.bedrock.runtime.coherence.options.RoleName;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.java.options.Headless;
import com.oracle.bedrock.runtime.java.options.HeapSize;
import com.oracle.bedrock.runtime.java.options.HotSpot;
import com.oracle.bedrock.runtime.java.options.SystemProperty;
import com.oracle.bedrock.runtime.options.Console;
import com.oracle.bedrock.runtime.options.DisplayName;
import com.oracle.bedrock.testsupport.deferred.Eventually;
import com.oracle.bedrock.util.Capture;
import com.oracle.bedrock.util.SystemProperties;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Deprecated
public class CoherenceClusterOrchestration
extends ExternalResource {
    private int storageMemberCount = 2;
    private LocalPlatform platform = LocalPlatform.get();
    private OptionsByType commonMemberOptions;
    private OptionsByType storageMemberOptions;
    private OptionsByType proxyMemberOptions;
    private OptionsByType clusterCreationOptions;
    private OptionsByType clusterClosingOptions;
    private CoherenceCluster cluster;
    private Properties systemProperties;
    private HashMap<SessionBuilder, ConfigurableCacheFactory> sessions;
    private Capture<Integer> clusterPort = new Capture((Iterator)this.platform.getAvailablePorts());
    private Capture<Integer> extendPort = new Capture((Iterator)this.platform.getAvailablePorts());

    public CoherenceClusterOrchestration() {
        this.commonMemberOptions = OptionsByType.empty();
        String hostAddress = this.platform.getLoopbackAddress().getHostAddress();
        this.commonMemberOptions.add((Option)LocalHost.of((String)hostAddress));
        this.commonMemberOptions.add((Option)ClusterPort.of(this.clusterPort));
        this.commonMemberOptions.add((Option)Multicast.ttl((int)0));
        this.commonMemberOptions.add((Option)SystemProperty.of((String)"tangosol.coherence.extend.address", (String)hostAddress, (Option[])new Option[0]));
        this.commonMemberOptions.add((Option)SystemProperty.of((String)"tangosol.coherence.extend.port", this.extendPort, (Option[])new Option[0]));
        this.commonMemberOptions.add((Option)Headless.enabled());
        this.commonMemberOptions.add((Option)HotSpot.Mode.SERVER);
        this.commonMemberOptions.add((Option)HeapSize.of((int)256, (HeapSize.Units)HeapSize.Units.MB, (int)1024, (HeapSize.Units)HeapSize.Units.MB));
        this.commonMemberOptions.add((Option)Console.system());
        this.storageMemberOptions = OptionsByType.empty();
        this.proxyMemberOptions = OptionsByType.empty();
        this.cluster = null;
        this.clusterCreationOptions = OptionsByType.empty();
        this.clusterClosingOptions = OptionsByType.empty();
        this.sessions = new HashMap();
    }

    public Statement apply(Statement base, Description description) {
        if (this.commonMemberOptions.get(ClusterName.class, new Object[0]) == null) {
            this.commonMemberOptions.add((Option)ClusterName.of((String)description.getClassName()));
        }
        return super.apply(base, description);
    }

    protected void before() throws Throwable {
        this.systemProperties = SystemProperties.createSnapshot();
        CoherenceClusterBuilder clusterBuilder = new CoherenceClusterBuilder();
        OptionsByType storageServerOptions = this.createStorageEnabledMemberOptions();
        storageServerOptions.addAll(this.clusterCreationOptions);
        clusterBuilder.include(this.storageMemberCount, CoherenceClusterMember.class, storageServerOptions.asArray());
        OptionsByType proxyServerOptions = this.createProxyServerOptions();
        proxyServerOptions.addAll(this.clusterCreationOptions);
        int proxyMemberCount = 1;
        clusterBuilder.include(proxyMemberCount, CoherenceClusterMember.class, proxyServerOptions.asArray());
        int preferredClusterSize = this.storageMemberCount + proxyMemberCount;
        this.cluster = (CoherenceCluster)clusterBuilder.build(new Option[0]);
        Eventually.assertThat((Object)((CoherenceCluster)DeferredHelper.invoking((Object)this.cluster)).getClusterSize(), (Matcher)Is.is((Object)preferredClusterSize), (Option[])new Option[0]);
        CoherenceClusterMember proxyServer = (CoherenceClusterMember)this.cluster.get("proxy-1");
        Set setServiceNames = (Set)proxyServer.invoke((RemoteCallable)new GetAutoStartServiceNames(), new Option[0]);
        for (String sServiceName : setServiceNames) {
            Eventually.assertThat((Object)((CoherenceClusterMember)DeferredHelper.invoking((Object)proxyServer)).isServiceRunning(sServiceName), (Matcher)Is.is((Object)true), (Option[])new Option[0]);
        }
        CacheFactory.setCacheFactoryBuilder(null);
        CacheFactory.shutdown();
        super.before();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void after() {
        HashMap<SessionBuilder, ConfigurableCacheFactory> hashMap = this.sessions;
        synchronized (hashMap) {
            for (ConfigurableCacheFactory session : this.sessions.values()) {
                CacheFactory.getCacheFactoryBuilder().release(session);
            }
        }
        CacheFactory.shutdown();
        this.cluster.close(this.clusterClosingOptions.asArray());
        SystemProperties.replaceWith((Properties)this.systemProperties);
        super.after();
    }

    protected OptionsByType createStorageEnabledMemberOptions() {
        OptionsByType optionsByType = OptionsByType.of((OptionsByType)this.commonMemberOptions);
        optionsByType.add((Option)DisplayName.of((String)"storage"));
        optionsByType.add((Option)RoleName.of((String)"storage"));
        optionsByType.add((Option)LocalStorage.enabled());
        optionsByType.addAll(this.storageMemberOptions);
        return optionsByType;
    }

    protected OptionsByType createProxyServerOptions() {
        OptionsByType optionsByType = OptionsByType.of((OptionsByType)this.commonMemberOptions);
        optionsByType.add((Option)DisplayName.of((String)"proxy"));
        optionsByType.add((Option)RoleName.of((String)"proxy"));
        optionsByType.add((Option)LocalStorage.disabled());
        optionsByType.add((Option)SystemProperty.of((String)"tangosol.coherence.extend.enabled", (Object)true, (Option[])new Option[0]));
        optionsByType.addAll(this.proxyMemberOptions);
        return optionsByType;
    }

    public CoherenceClusterOrchestration withClosingOptions(Option ... options) {
        this.clusterClosingOptions = OptionsByType.of((Option[])options);
        return this;
    }

    public CoherenceClusterOrchestration withBuilderOptions(Option ... options) {
        this.clusterCreationOptions = OptionsByType.of((Option[])options);
        return this;
    }

    public CoherenceCluster getCluster() {
        return this.cluster;
    }

    public LocalPlatform getLocalPlatform() {
        return this.platform;
    }

    public CoherenceClusterOrchestration withOptions(Option ... options) {
        this.commonMemberOptions.addAll(options);
        return this;
    }

    public CoherenceClusterOrchestration withStorageMemberOptions(Option ... options) {
        this.storageMemberOptions.addAll(options);
        return this;
    }

    public CoherenceClusterOrchestration withProxyMemberOptions(Option ... options) {
        this.proxyMemberOptions.addAll(options);
        return this;
    }

    public synchronized ConfigurableCacheFactory getSessionFor(SessionBuilder builder) {
        SystemProperties.replaceWith((Properties)this.systemProperties);
        ConfigurableCacheFactory session = this.sessions.get(builder);
        if (session == null) {
            OptionsByType optionsByType = OptionsByType.of((OptionsByType)this.commonMemberOptions);
            optionsByType.add((Option)RoleName.of((String)"client"));
            optionsByType.add((Option)LocalStorage.disabled());
            session = builder.build(this.platform, this.cluster, optionsByType);
            this.sessions.put(builder, session);
        }
        return session;
    }

    public CoherenceClusterOrchestration setStorageMemberCount(int count) {
        this.storageMemberCount = count;
        return this;
    }
}

