/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.junit;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.junit.AbstractAssemblyResource;
import com.oracle.bedrock.junit.SessionBuilder;
import com.oracle.bedrock.runtime.AssemblyBuilder;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.coherence.CoherenceCluster;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterBuilder;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterMember;
import com.oracle.bedrock.runtime.coherence.options.ClusterName;
import com.oracle.bedrock.runtime.coherence.options.LocalStorage;
import com.oracle.bedrock.runtime.coherence.options.RoleName;
import com.oracle.bedrock.runtime.java.options.Headless;
import com.oracle.bedrock.runtime.java.options.HeapSize;
import com.oracle.bedrock.runtime.java.options.HotSpot;
import com.oracle.bedrock.runtime.options.Console;
import com.oracle.bedrock.util.SystemProperties;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import java.util.HashMap;
import java.util.Properties;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CoherenceClusterResource
extends AbstractAssemblyResource<CoherenceClusterMember, CoherenceCluster, CoherenceClusterResource> {
    private Properties systemProperties;
    private HashMap<SessionBuilder, ConfigurableCacheFactory> sessions = new HashMap();

    public CoherenceClusterResource() {
        this.commonOptionsByType.add((Option)Headless.enabled());
        this.commonOptionsByType.add((Option)HotSpot.Mode.SERVER);
        this.commonOptionsByType.add((Option)HeapSize.of((int)256, (HeapSize.Units)HeapSize.Units.MB, (int)1024, (HeapSize.Units)HeapSize.Units.MB));
        this.commonOptionsByType.add((Option)Console.system());
    }

    protected AssemblyBuilder<CoherenceClusterMember, CoherenceCluster> createBuilder() {
        return new CoherenceClusterBuilder();
    }

    public CoherenceCluster getCluster() {
        return (CoherenceCluster)this.assembly;
    }

    protected void before() throws Throwable {
        if (this.launchDefinitions.isEmpty()) {
            throw new IllegalStateException("CoherenceClusterResource fails to define members to include when launching");
        }
        this.systemProperties = SystemProperties.createSnapshot();
        CacheFactory.setCacheFactoryBuilder(null);
        CacheFactory.shutdown();
        super.before();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void after() {
        HashMap<SessionBuilder, ConfigurableCacheFactory> hashMap = this.sessions;
        synchronized (hashMap) {
            for (ConfigurableCacheFactory session : this.sessions.values()) {
                CacheFactory.getCacheFactoryBuilder().release(session);
            }
        }
        CacheFactory.setCacheFactoryBuilder(null);
        CacheFactory.shutdown();
        super.after();
        SystemProperties.replaceWith((Properties)this.systemProperties);
    }

    public Statement apply(Statement base, Description description) {
        this.commonOptionsByType.addIfAbsent((Option)ClusterName.of((String)description.getClassName()));
        return super.apply(base, description);
    }

    public CoherenceClusterResource include(int count, Option ... options) {
        return (CoherenceClusterResource)this.include(count, CoherenceClusterMember.class, options);
    }

    public synchronized ConfigurableCacheFactory createSession(SessionBuilder builder) {
        SystemProperties.replaceWith((Properties)this.systemProperties);
        ConfigurableCacheFactory session = this.sessions.get(builder);
        if (session == null) {
            OptionsByType optionsByType = OptionsByType.of((OptionsByType)this.commonOptionsByType);
            optionsByType.add((Option)RoleName.of((String)"client"));
            optionsByType.add((Option)LocalStorage.disabled());
            session = builder.build(LocalPlatform.get(), this.getCluster(), optionsByType);
            this.sessions.put(builder, session);
        }
        return session;
    }
}

