/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.junit;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.junit.SessionBuilder;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.coherence.CoherenceCluster;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterBuilder;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterMember;
import com.oracle.bedrock.runtime.coherence.options.ClusterName;
import com.oracle.bedrock.runtime.coherence.options.ClusterPort;
import com.oracle.bedrock.runtime.coherence.options.LocalStorage;
import com.oracle.bedrock.runtime.coherence.options.Multicast;
import com.oracle.bedrock.runtime.coherence.options.RoleName;
import com.oracle.bedrock.runtime.java.options.Headless;
import com.oracle.bedrock.runtime.java.options.HeapSize;
import com.oracle.bedrock.runtime.java.options.HotSpot;
import com.oracle.bedrock.runtime.java.options.SystemProperty;
import com.oracle.bedrock.runtime.options.Console;
import com.oracle.bedrock.runtime.options.DisplayName;
import com.oracle.bedrock.util.Capture;
import com.oracle.bedrock.util.SystemProperties;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Deprecated
public class CoherenceClusterOrchestration
extends ExternalResource {
    private int storageMemberCount = 2;
    private final LocalPlatform platform = LocalPlatform.get();
    private final OptionsByType commonMemberOptions;
    private final OptionsByType storageMemberOptions;
    private OptionsByType clusterCreationOptions;
    private OptionsByType clusterClosingOptions;
    private CoherenceCluster cluster;
    private Properties systemProperties;
    private final HashMap<SessionBuilder, ConfigurableCacheFactory> sessions;
    private Capture<Integer> clusterPort = new Capture((Iterator)this.platform.getAvailablePorts());

    public CoherenceClusterOrchestration() {
        this.commonMemberOptions = OptionsByType.empty();
        String hostAddress = this.platform.getLoopbackAddress().getHostAddress();
        this.commonMemberOptions.add((Option)ClusterPort.of(this.clusterPort));
        this.commonMemberOptions.add((Option)Multicast.ttl((int)0));
        this.commonMemberOptions.add((Option)SystemProperty.of((String)"tangosol.coherence.extend.address", (String)hostAddress, (Option[])new Option[0]));
        this.commonMemberOptions.add((Option)SystemProperty.of((String)"tangosol.coherence.extend.port", this.clusterPort, (Option[])new Option[0]));
        this.commonMemberOptions.add((Option)SystemProperty.of((String)"tangosol.coherence.extend.enabled", (Object)true, (Option[])new Option[0]));
        this.commonMemberOptions.add((Option)Headless.enabled());
        this.commonMemberOptions.add((Option)HotSpot.Mode.SERVER);
        this.commonMemberOptions.add((Option)HeapSize.of((int)256, (HeapSize.Units)HeapSize.Units.MB, (int)1024, (HeapSize.Units)HeapSize.Units.MB));
        this.commonMemberOptions.add((Option)Console.system());
        this.storageMemberOptions = OptionsByType.empty();
        this.cluster = null;
        this.clusterCreationOptions = OptionsByType.empty();
        this.clusterClosingOptions = OptionsByType.empty();
        this.sessions = new HashMap();
    }

    public Statement apply(Statement base, Description description) {
        if (this.commonMemberOptions.get(ClusterName.class, new Object[0]) == null) {
            this.commonMemberOptions.add((Option)ClusterName.of((String)description.getClassName()));
        }
        return super.apply(base, description);
    }

    protected void before() throws Throwable {
        this.systemProperties = SystemProperties.createSnapshot();
        CoherenceClusterBuilder clusterBuilder = new CoherenceClusterBuilder();
        OptionsByType storageServerOptions = this.createStorageEnabledMemberOptions();
        storageServerOptions.addAll(this.clusterCreationOptions);
        clusterBuilder.include(this.storageMemberCount, CoherenceClusterMember.class, storageServerOptions.asArray());
        this.cluster = (CoherenceCluster)clusterBuilder.build(new Option[0]);
        CacheFactory.setCacheFactoryBuilder(null);
        CacheFactory.shutdown();
        super.before();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void after() {
        HashMap<SessionBuilder, ConfigurableCacheFactory> hashMap = this.sessions;
        synchronized (hashMap) {
            for (ConfigurableCacheFactory session : this.sessions.values()) {
                session.dispose();
                CacheFactory.getCacheFactoryBuilder().release(session);
            }
        }
        CacheFactory.shutdown();
        CacheFactory.setCacheFactoryBuilder(null);
        this.cluster.close(this.clusterClosingOptions.asArray());
        SystemProperties.replaceWith((Properties)this.systemProperties);
        super.after();
    }

    protected OptionsByType createStorageEnabledMemberOptions() {
        OptionsByType optionsByType = OptionsByType.of((OptionsByType)this.commonMemberOptions);
        optionsByType.add((Option)DisplayName.of((String)"storage"));
        optionsByType.add((Option)RoleName.of((String)"storage"));
        optionsByType.add((Option)LocalStorage.enabled());
        optionsByType.addAll(this.storageMemberOptions);
        return optionsByType;
    }

    public CoherenceClusterOrchestration withClosingOptions(Option ... options) {
        this.clusterClosingOptions = OptionsByType.of((Option[])options);
        return this;
    }

    public CoherenceClusterOrchestration withBuilderOptions(Option ... options) {
        this.clusterCreationOptions = OptionsByType.of((Option[])options);
        return this;
    }

    public CoherenceCluster getCluster() {
        return this.cluster;
    }

    public LocalPlatform getLocalPlatform() {
        return this.platform;
    }

    public CoherenceClusterOrchestration withOptions(Option ... options) {
        this.commonMemberOptions.addAll(options);
        return this;
    }

    public CoherenceClusterOrchestration withStorageMemberOptions(Option ... options) {
        this.storageMemberOptions.addAll(options);
        return this;
    }

    public synchronized ConfigurableCacheFactory getSessionFor(SessionBuilder builder) {
        SystemProperties.replaceWith((Properties)this.systemProperties);
        ConfigurableCacheFactory session = this.sessions.get(builder);
        if (session == null) {
            OptionsByType optionsByType = OptionsByType.of((OptionsByType)this.commonMemberOptions);
            optionsByType.add((Option)RoleName.of((String)"client"));
            optionsByType.add((Option)LocalStorage.disabled());
            session = builder.build(this.platform, this.getCluster(), optionsByType);
            this.sessions.put(builder, session);
        }
        return session;
    }

    public CoherenceClusterOrchestration setStorageMemberCount(int count) {
        this.storageMemberCount = count;
        return this;
    }
}

