/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.junit;

import com.oracle.bedrock.Bedrock;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.junit.SessionBuilder;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.coherence.CoherenceCluster;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterMember;
import com.oracle.bedrock.runtime.coherence.options.CacheConfig;
import com.oracle.bedrock.runtime.coherence.options.LocalStorage;
import com.oracle.bedrock.runtime.coherence.options.RoleName;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.table.Cell;
import com.oracle.bedrock.table.Row;
import com.oracle.bedrock.table.Table;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.ScopedCacheFactoryBuilder;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StorageDisabledMember
implements SessionBuilder {
    private static final Logger LOGGER = Logger.getLogger(StorageDisabledMember.class.getName());

    @Override
    public ConfigurableCacheFactory build(LocalPlatform platform, CoherenceCluster cluster, OptionsByType optionsByType) {
        Table diagnosticsTable = new Table(new Row[0]);
        diagnosticsTable.getOptions().add((Option)Table.orderByColumn((int)0));
        optionsByType.add((Option)RoleName.of((String)"client"));
        optionsByType.add((Option)LocalStorage.disabled());
        optionsByType.addIfAbsent((Option)CacheConfig.of((String)"coherence-cache-config.xml"));
        CoherenceClusterMember.MetaClass metaClass = new CoherenceClusterMember.MetaClass();
        for (Profile profile : optionsByType.getInstancesOf(Profile.class)) {
            profile.onLaunching((Platform)platform, (MetaClass)metaClass, optionsByType);
        }
        SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        Properties properties = systemProperties.resolve((Platform)platform, optionsByType);
        Table systemPropertiesTable = new Table(new Row[0]);
        systemPropertiesTable.getOptions().add((Option)Table.orderByColumn((int)0));
        systemPropertiesTable.getOptions().add((Option)Cell.Separator.of((String)""));
        systemPropertiesTable.getOptions().add((Option)Cell.DisplayNull.asEmptyString());
        for (String propertyName : properties.stringPropertyNames()) {
            String propertyValue = properties.getProperty(propertyName);
            systemPropertiesTable.addRow(new String[]{propertyName + (System.getProperties().containsKey(propertyName) ? "*" : ""), propertyValue});
            System.setProperty(propertyName, propertyValue.isEmpty() ? "" : propertyValue);
        }
        diagnosticsTable.addRow(new String[]{"System Properties", systemPropertiesTable.toString()});
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Oracle Bedrock " + Bedrock.getVersion() + ": Starting Storage Disabled Member...\n------------------------------------------------------------------------\n" + diagnosticsTable.toString() + "\n------------------------------------------------------------------------\n");
        }
        ConfigurableCacheFactory session = new ScopedCacheFactoryBuilder().getConfigurableCacheFactory(((CacheConfig)optionsByType.get(CacheConfig.class, new Object[0])).getUri(), this.getClass().getClassLoader());
        CacheFactory.ensureCluster();
        return session;
    }

    public boolean equals(Object other) {
        return other instanceof StorageDisabledMember;
    }

    public int hashCode() {
        return StorageDisabledMember.class.hashCode();
    }
}

