/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.junit;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.junit.SessionBuilder;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.coherence.CoherenceCluster;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterBuilder;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterMember;
import com.oracle.bedrock.runtime.coherence.options.LocalStorage;
import com.oracle.bedrock.runtime.coherence.options.RoleName;
import com.oracle.bedrock.runtime.java.options.Headless;
import com.oracle.bedrock.runtime.java.options.HeapSize;
import com.oracle.bedrock.runtime.java.options.HotSpot;
import com.oracle.bedrock.runtime.options.Console;
import com.oracle.bedrock.testsupport.junit.AbstractBaseAssembly;
import com.oracle.bedrock.util.SystemProperties;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import java.util.HashMap;
import java.util.Properties;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class CoherenceClusterExtension
extends AbstractBaseAssembly<CoherenceClusterMember, CoherenceCluster, CoherenceClusterExtension>
implements BeforeAllCallback,
AfterAllCallback {
    private Properties systemProperties;
    private final HashMap<SessionBuilder, ConfigurableCacheFactory> sessions = new HashMap();

    public CoherenceClusterExtension() {
        this.commonOptionsByType.add((Option)Headless.enabled());
        this.commonOptionsByType.add((Option)HotSpot.Mode.SERVER);
        this.commonOptionsByType.add((Option)HeapSize.of((int)256, (HeapSize.Units)HeapSize.Units.MB, (int)1024, (HeapSize.Units)HeapSize.Units.MB));
        this.commonOptionsByType.add((Option)Console.system());
    }

    protected CoherenceClusterBuilder createBuilder() {
        return new CoherenceClusterBuilder();
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        if (this.launchDefinitions.isEmpty()) {
            throw new IllegalStateException("CoherenceClusterResource fails to define members to include when launching");
        }
        this.systemProperties = SystemProperties.createSnapshot();
        CacheFactory.setCacheFactoryBuilder(null);
        CacheFactory.shutdown();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterAll(ExtensionContext extensionContext) throws Exception {
        HashMap<SessionBuilder, ConfigurableCacheFactory> hashMap = this.sessions;
        synchronized (hashMap) {
            for (ConfigurableCacheFactory session : this.sessions.values()) {
                CacheFactory.getCacheFactoryBuilder().release(session);
            }
        }
        CacheFactory.setCacheFactoryBuilder(null);
        CacheFactory.shutdown();
        this.close();
        SystemProperties.replaceWith((Properties)this.systemProperties);
    }

    public CoherenceCluster getCluster() {
        return (CoherenceCluster)this.assembly;
    }

    public CoherenceClusterExtension include(int count, Option ... options) {
        return (CoherenceClusterExtension)this.include(count, CoherenceClusterMember.class, options);
    }

    public synchronized ConfigurableCacheFactory createSession(SessionBuilder builder) {
        SystemProperties.replaceWith((Properties)this.systemProperties);
        ConfigurableCacheFactory session = this.sessions.get(builder);
        if (session == null) {
            OptionsByType optionsByType = OptionsByType.of((OptionsByType)this.commonOptionsByType);
            optionsByType.add((Option)RoleName.of((String)"client"));
            optionsByType.add((Option)LocalStorage.disabled());
            session = builder.build(LocalPlatform.get(), this.getCluster(), optionsByType);
            this.sessions.put(builder, session);
        }
        return session;
    }
}

