/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.matchers;

import com.tangosol.net.partition.PartitionSet;
import java.util.HashSet;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class PartitionSetMatcher
extends TypeSafeMatcher<PartitionSet> {
    private HashSet<Integer> partitionIds = new HashSet();

    private PartitionSetMatcher(int ... partitionIds) {
        if (partitionIds != null) {
            for (int partitionId : partitionIds) {
                this.partitionIds.add(partitionId);
            }
        }
    }

    protected boolean matchesSafely(PartitionSet partitionSet) {
        for (int partitionId : this.partitionIds) {
            if (partitionSet.contains(partitionId)) continue;
            return false;
        }
        return true;
    }

    protected void describeMismatchSafely(PartitionSet partitionSet, Description mismatchDescription) {
        mismatchDescription.appendText("partitionSet was " + String.valueOf(partitionSet));
    }

    public void describeTo(Description description) {
        description.appendText("partitionSet containing ").appendValueList("{", ", ", "}", this.partitionIds);
    }

    public static Matcher<PartitionSet> contains(int ... partitionIds) {
        return new PartitionSetMatcher(partitionIds);
    }
}

