/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import oracle.as.management.translation.NLSupport;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.logging.LogUtil;
import oracle.core.ojdl.logging.ODLFormatter;
import oracle.core.ojdl.logging.ODLLevel;
import oracle.core.ojdl.logging.ODLLogRecord;
import oracle.dfw.common.ApplicationContext;
import oracle.dfw.common.ArgumentMap;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.common.DiagnosticsEvent;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.common.DiagnosticsException;
import oracle.dfw.common.DiagnosticsListener;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.config.DiagnosticsConfiguration;
import oracle.dfw.config.DiagnosticsConfigurationChangedEvent;
import oracle.dfw.dump.DiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.impl.common.NamedThreadFactory;
import oracle.dfw.impl.common.SecurityContext;
import oracle.dfw.impl.common.TempFileManager;
import oracle.dfw.impl.dump.ClassHistogram;
import oracle.dfw.impl.dump.DumpManagerImpl;
import oracle.dfw.impl.incident.ADRDiskSpaceException;
import oracle.dfw.impl.incident.ADRHelper;
import oracle.dfw.impl.incident.ADRInfo;
import oracle.dfw.impl.incident.AccessCheck;
import oracle.dfw.impl.incident.DiagnosticRulesManager;
import oracle.dfw.impl.incident.FloodController;
import oracle.dfw.impl.incident.IncidentActions;
import oracle.dfw.impl.incident.IncidentDump;
import oracle.dfw.impl.incident.IncidentImpl;
import oracle.dfw.impl.incident.LogWrapper;
import oracle.dfw.impl.incident.ProblemKeyFilterChecker;
import oracle.dfw.impl.incident.WrapperException;
import oracle.dfw.incident.DiagnosticsDataExtractor;
import oracle.dfw.incident.ErrorMessage;
import oracle.dfw.incident.Incident;
import oracle.dfw.incident.IncidentCreationEvent;
import oracle.dfw.incident.IncidentCreationException;
import oracle.dfw.incident.IncidentFacts;
import oracle.dfw.incident.InvalidRulesException;
import oracle.dfw.resource.DiagnosticsResourceBundle;
import oracle.dms.context.ExecutionContext;
import oracle.dms.event.HTTPRequestTracker;

public class DiagnosticsDataExtractorImpl
implements DiagnosticsDataExtractor,
DiagnosticsListener {
    private volatile boolean m_isIncidentCreationEnabled = true;
    private ApplicationContext m_appContext;
    private SecurityContext m_secContext;
    private DumpManagerImpl m_dumpManager;
    private DiagnosticRulesManager m_rulesManager;
    private FloodController m_floodController;
    private ProblemKeyFilterChecker m_problemKeyFilterChecker;
    private ADRHelper m_adrHelper;
    private Subject m_systemSubject;
    private NLSupport m_nlSupport;
    private Logger m_logger;
    private Logger m_incidentLogger;
    private ADRInfo m_defaultADR;
    private Object m_sync = new Object();
    private boolean m_stop = false;
    private volatile boolean m_shutdown;
    private boolean m_isADREnabled = true;
    private ODLFormatter m_odl = new ODLFormatter();
    private File[] m_customRulesDirs;
    private List<String> m_customRulesFiles = new ArrayList<String>(2);
    private Map<String, String> m_customProperties;
    private IncidentCreatorThread m_incidentCreatorThread;
    private List<IncidentProcessingData> m_queue = new ArrayList<IncidentProcessingData>();
    private ConcurrentHashMap<String, ADRInfo> m_applicationADRMap = new ConcurrentHashMap(1);
    private NamedThreadFactory m_dumpExecutorThreadFactory = new NamedThreadFactory("oracle.dfw.impl.incident.DiagnosticsDataExtractorImpl - Incident Dump Executor");
    private static final String CLASS_NAME = DiagnosticsDataExtractor.class.getName();
    private static final String PROCESS_DUMP_ACTIONS = "processDumpActions";
    private static final int DEFAULT_TIMEOUT = 120000;
    private static final String DFW_USER_NAME = "DFW_USER_NAME";
    private static final String DFW_APP_NAME = "DFW_APP_NAME";
    private static final String DFW_WATCH_NAME = "DFW_WATCH_NAME";
    private static final String WATCH_HEAP_SPACE = "HeapSpace";

    public DiagnosticsDataExtractorImpl(String oracleHomePath, ADRInfo defaultADR, ApplicationContext appContext, SecurityContext secContext, DumpManagerImpl dumpManager, DiagnosticsConfiguration diagConfig, File[] customRulesDirs, Map<String, String> customProperties) {
        if (defaultADR == null || dumpManager == null) {
            throw new IllegalArgumentException("Invalid arguments defaultADR=" + defaultADR + " dumpManager=" + dumpManager + " diagConfig=" + diagConfig);
        }
        this.m_logger = LoggerFactory.getFrameworkLogger();
        this.m_incidentLogger = LoggerFactory.getIncidentLogger();
        this.m_defaultADR = defaultADR;
        this.m_isIncidentCreationEnabled = diagConfig.isIncidentCreationEnabled();
        File checkPath = new File(this.m_defaultADR.getADRBase(), "internal");
        try {
            if (!AccessCheck.exists(checkPath) && !AccessCheck.mkdirs(checkPath)) {
                this.m_isADREnabled = false;
                this.m_logger.log(Level.SEVERE, "DFW-40100", this.m_defaultADR.getADRBase());
            }
        }
        catch (SecurityException e) {
            this.m_isADREnabled = false;
            this.m_logger.log(Level.SEVERE, "DFW-40100", this.m_defaultADR.getADRBase());
        }
        try {
            if (this.m_isADREnabled) {
                this.m_adrHelper = new ADRHelper(oracleHomePath, this.m_defaultADR, diagConfig, this.m_logger);
                this.m_incidentCreatorThread = new IncidentCreatorThread();
            }
        }
        catch (DiagnosticsException e) {
            this.m_isADREnabled = false;
            LoggerFactory.getFrameworkLogger().log(Level.FINE, "failure initializing ADR", e);
        }
        if (!this.m_isADREnabled) {
            LoggerFactory.getFrameworkLogger().log(Level.FINE, "ADR unavailable; incident creation in ADR will be disabled.");
        }
        this.m_customProperties = customProperties;
        this.m_appContext = appContext;
        this.m_secContext = secContext;
        this.m_dumpManager = dumpManager;
        this.m_rulesManager = new DiagnosticRulesManager(appContext, dumpManager);
        this.m_floodController = new FloodController(diagConfig);
        this.m_nlSupport = NLSupport.getNLSupport(DiagnosticsResourceBundle.class.getName(), Thread.currentThread().getContextClassLoader());
        if (this.m_secContext != null) {
            this.m_systemSubject = this.m_secContext.getCurrentSubject();
        }
        this.m_problemKeyFilterChecker = new ProblemKeyFilterChecker(diagConfig);
        this.m_customRulesDirs = customRulesDirs;
        this.reloadCustomRules(null);
        DiagnosticsEventManager.registerListener(this);
    }

    @Override
    public boolean isADREnabled() {
        return this.m_isADREnabled;
    }

    @Override
    public Incident createIncident(IncidentFacts facts, boolean all) throws IncidentCreationException {
        HTTPRequestTracker tracker;
        ExecutionContext ectx;
        if (this.m_shutdown || !this.m_isIncidentCreationEnabled) {
            return null;
        }
        if (facts == null) {
            throw new IllegalArgumentException("facts=" + facts);
        }
        if (this.m_appContext != null && facts.getApplicationName() == null) {
            facts.setApplicationName(this.m_appContext.getApplicationName());
        }
        facts.setContextValue(DFW_APP_NAME, facts.getApplicationName());
        if (this.m_secContext != null) {
            facts.setContextValue(DFW_USER_NAME, this.m_secContext.getUserName());
        }
        if (this.m_customProperties != null) {
            for (Map.Entry<String, String> entry : this.m_customProperties.entrySet()) {
                if (entry.getValue() == null) continue;
                facts.setContextValue(entry.getKey(), entry.getValue());
            }
        }
        if (facts.isSynchronous() && facts.getThrowable() == null && facts.getIncidentSource().equals((Object)Incident.IncidentSource.SYSTEM)) {
            facts.setThrowable(new Throwable("dummy exception to generate stacktrace leading up to incident"));
        }
        if (facts.isSynchronous() && facts.getExecutionContextId() == null && facts.getIncidentSource().equals((Object)Incident.IncidentSource.SYSTEM) && (ectx = ExecutionContext.get()) != null && ectx.isActive()) {
            facts.setExecutionContextId(ectx.getECID());
            Map<String, String> contextValues = ectx.getAllValues();
            if (contextValues != null) {
                for (Map.Entry<String, String> nameValue : contextValues.entrySet()) {
                    facts.setContextValue(nameValue.getKey(), nameValue.getValue());
                }
            }
        }
        String httpRequest = null;
        if (facts.getExecutionContextId() != null && (tracker = HTTPRequestTracker.getInstance()).isActive()) {
            httpRequest = tracker.getRequest(facts.getExecutionContextId());
        }
        if (this.m_incidentLogger.isLoggable(Level.INFO)) {
            this.m_incidentLogger.log(Level.INFO, "DFW-40101", facts.toString());
        }
        ADRInfo adrInfo = this.getADRInfo(facts);
        IncidentImpl incident = null;
        if (this.m_isADREnabled) {
            incident = this.createADRIncident(facts, adrInfo);
            adrInfo.updateIncidentMetrics(incident);
            if (incident.isFloodControlled() || incident.getIncidentId() == "-3" || incident.getIncidentId() == "-4") {
                return incident;
            }
            this.createReadme(adrInfo, incident, facts, httpRequest);
            IncidentActions actions = this.executeSynchronousDumps(incident, facts, adrInfo);
            if (all) {
                ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                Subject subject = null;
                if (this.m_secContext != null) {
                    subject = this.m_secContext.getCurrentSubject();
                }
                this.processIncident(facts, incident, cl, subject, actions);
            } else {
                this.m_incidentCreatorThread.add(incident, facts, actions);
            }
        } else {
            incident = new IncidentImpl("-1", "NA", adrInfo.getADRBase(), adrInfo.getProductType(), adrInfo.getProductId(), adrInfo.getInstanceId(), "NA", facts);
            if (facts.getIncidentSource().equals((Object)Incident.IncidentSource.SYSTEM)) {
                String floodControlled = this.m_floodController.isFloodControlled(facts);
                if (floodControlled != null) {
                    incident.setFloodContolled(floodControlled);
                } else {
                    this.m_floodController.setLastIncidentId(facts.getProblemKey(), "-1");
                }
            }
            this.m_incidentLogger.log(Level.INFO, "DFW-40118");
            if (this.m_incidentLogger.isLoggable(Level.INFO) && !incident.isFloodControlled()) {
                try {
                    String argName;
                    Enumeration<String> e;
                    ArgumentMap argMap;
                    StringBuilder buf = new StringBuilder();
                    IncidentActions actions = this.m_rulesManager.evaluateRules(facts, adrInfo.getADRHome(), incident.getIncidentId(), incident.getIncidentDirectory());
                    if (actions != null && actions.getAsynchronousDumpContextList() != null) {
                        for (DumpContext ctx : actions.getAsynchronousDumpContextList()) {
                            buf.append("\n  - ");
                            buf.append(ctx.getDumpName());
                            argMap = ctx.getArguments();
                            if (argMap == null || argMap.size() <= 0) continue;
                            buf.append(" [ ");
                            e = argMap.enumerateKeys();
                            while (e.hasMoreElements()) {
                                argName = e.nextElement();
                                buf.append(argName);
                                buf.append(":");
                                buf.append(argMap.get(argName));
                                buf.append(" ");
                            }
                            buf.append("]");
                        }
                    }
                    if (actions != null && actions.getSynchronousDumpContextList() != null) {
                        for (DumpContext ctx : actions.getSynchronousDumpContextList()) {
                            buf.append("\n  - ");
                            buf.append(ctx.getDumpName());
                            argMap = ctx.getArguments();
                            if (argMap == null || argMap.size() <= 0) continue;
                            buf.append(" [ ");
                            e = argMap.enumerateKeys();
                            while (e.hasMoreElements()) {
                                argName = e.nextElement();
                                buf.append(argName);
                                buf.append(":");
                                buf.append(argMap.get(argName));
                                buf.append(" ");
                            }
                            buf.append("]");
                        }
                    }
                    this.m_incidentLogger.info("Diagnostic dumps that would have been executed for problem key " + incident.getProblemKey() + ":" + buf.toString());
                }
                catch (Exception e) {
                    this.m_logger.log(Level.FINER, "failure evaluating diagnostic rules", e);
                }
            }
            if (!incident.isFloodControlled()) {
                DiagnosticsEventManager.notifyListeners(new IncidentCreationEvent(incident), false);
            }
        }
        return incident;
    }

    private IncidentActions executeSynchronousDumps(IncidentImpl incident, IncidentFacts facts, ADRInfo adrInfo) {
        IncidentActions actions;
        block15: {
            actions = null;
            if (facts.isEvaluateDiagnosticRules()) {
                try {
                    actions = this.m_rulesManager.evaluateRules(facts, adrInfo.getADRHome(), incident.getIncidentId(), incident.getIncidentDirectory());
                }
                catch (Exception e) {
                    if (!this.m_logger.isLoggable(Level.FINE)) break block15;
                    this.m_logger.log(Level.FINE, "failure evaluating diagnostic rules", e);
                }
            }
        }
        if (actions != null && actions.getSynchronousDumpContextList() != null) {
            for (DumpContext ctx : actions.getSynchronousDumpContextList()) {
                try {
                    DumpResult dumpResult = this.m_dumpManager.executeDump(ctx, null, true, false);
                    if (dumpResult == null) continue;
                    incident.addIncidentDump(new IncidentDump(dumpResult));
                }
                catch (Throwable throwable) {
                    if (!this.m_logger.isLoggable(Level.INFO)) continue;
                    LogUtil.log((Logger)this.m_logger, (Level)Level.INFO, (String)"DFW-40105", (Object[])new String[]{ctx.getDumpName(), ctx.getIncidentID()}, (Throwable)throwable);
                }
            }
        }
        if ((facts.getDiagnosticDumps() != null || facts.getNamedDiagnosticDumps() != null) && facts.isSynchronous()) {
            HashMap<DumpContext, DiagnosticDump> dumpContextPairs = new HashMap<DumpContext, DiagnosticDump>(1);
            if (facts.getNamedDiagnosticDumps() != null) {
                for (IncidentFacts.DumpInfo dumpInfo : facts.getNamedDiagnosticDumps()) {
                    DiagnosticDump dump = this.m_dumpManager.getDump(dumpInfo.getDumpName(), dumpInfo.getApplicationName() == null, dumpInfo.getApplicationName());
                    if (dump == null || dump.getRunMode() != DiagnosticDump.DumpRunMode.SYNCHRONOUS && dump.getRunMode() != DiagnosticDump.DumpRunMode.SYNCHRONOUS_ASYNCHRONOUS) continue;
                    DumpContext factCtx = DumpContext.createDumpContext(dump.getFullDumpName(), adrInfo.getADRHome(), incident.getIncidentId(), incident.getIncidentDirectory(), facts);
                    dumpContextPairs.put(this.createDumpContext(dump, dumpInfo.getDumpArguments(), dumpInfo.getApplicationName(), incident, adrInfo, facts), dump);
                }
            }
            if (facts.getDiagnosticDumps() != null) {
                for (DiagnosticDump diagnosticDump : facts.getDiagnosticDumps()) {
                    if (diagnosticDump.getRunMode() != DiagnosticDump.DumpRunMode.SYNCHRONOUS && diagnosticDump.getRunMode() != DiagnosticDump.DumpRunMode.SYNCHRONOUS_ASYNCHRONOUS) continue;
                    dumpContextPairs.put(this.createDumpContext(diagnosticDump, null, null, incident, adrInfo, facts), diagnosticDump);
                }
            }
            for (Map.Entry entry : dumpContextPairs.entrySet()) {
                try {
                    DumpResult result = this.m_dumpManager.executeDump((DumpContext)entry.getKey(), (DiagnosticDump)entry.getValue(), true, false);
                    if (result == null) continue;
                    incident.addIncidentDump(new IncidentDump(result));
                }
                catch (Throwable t) {
                    if (!this.m_logger.isLoggable(Level.INFO)) continue;
                    LogUtil.log((Logger)this.m_logger, (Level)Level.INFO, (String)"DFW-40105", (Object[])new String[]{((DumpContext)entry.getKey()).getDumpName(), ((DumpContext)entry.getKey()).getIncidentID()}, (Throwable)t);
                }
            }
        }
        return actions;
    }

    @Override
    public Incident createIncident(LogRecord logRecord, boolean all) throws IncidentCreationException {
        LogWrapper logWrapper;
        Incident incident = null;
        if (logRecord != null && this.m_isIncidentCreationEnabled && this.m_rulesManager.evaluateLogConditions(logWrapper = new LogWrapper(logRecord, this.m_odl))) {
            LogMessage msg = logWrapper.getLogMessage();
            String messageText = this.m_odl.format(logRecord);
            ErrorMessage errorMsg = null;
            if (msg.getMessageId() != null) {
                try {
                    errorMsg = new ErrorMessage(msg.getMessageId());
                }
                catch (Throwable t) {
                    this.m_logger.log(Level.FINE, "Error message ID " + msg.getMessageId() + " could not be parsed", t);
                }
            }
            if (errorMsg == null) {
                errorMsg = new ErrorMessage("DFW", 99999);
            }
            errorMsg.setErrorMessageText(messageText);
            if (msg.getMessageArgs() != null && msg.getMessageArgs().length > 0) {
                ArrayList<String> args = new ArrayList<String>();
                int len = msg.getMessageArgs().length;
                for (int i = 0; i < len; ++i) {
                    args.add(msg.getMessageArgs()[i].getValue());
                }
                errorMsg.setErrorArguments(args);
            }
            errorMsg.setErrorMessageText(msg.getMessageText());
            IncidentFacts facts = IncidentFacts.createSystemIncidentFacts(msg.getTimestamp(), errorMsg, msg.getComponentId(), msg.getModuleId());
            facts.setThrowable(logRecord.getThrown());
            facts.setLogRecord(logRecord);
            facts.setDescription("\nThe following log message matched one or more log detection conditions:\n\n" + messageText);
            facts.setSynchronous(true);
            incident = this.createIncident(facts, all);
        }
        return incident;
    }

    @Override
    public void registerRules(Reader rules, String id, boolean systemScope, String appName) throws InvalidRulesException {
        this.m_rulesManager.registerRules(rules, id, systemScope, appName);
    }

    @Override
    public void unregisterRules(String id, boolean systemScope, String appName) {
        this.m_rulesManager.unregisterRules(id, systemScope, appName);
    }

    public DiagnosticRulesManager getRulesManager() {
        return this.m_rulesManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIncident(IncidentFacts facts, IncidentImpl incident, ClassLoader loader, Subject subject, IncidentActions actions) throws IncidentCreationException {
        block27: {
            try {
                List<IncidentDump> incidentDumps;
                ADRInfo adrInfo = this.getADRInfo(facts);
                if (incident.isFloodControlled()) break block27;
                DumpContext jvmHistogramCtx = null;
                String errorId = null;
                if (facts.getErrorMessage() != null) {
                    errorId = facts.getErrorMessage().getErrorFacilityAndNumber();
                }
                String dfwWatchName = facts.getContextValue(DFW_WATCH_NAME);
                if (facts.isEvaluateDiagnosticRules() && errorId != null && errorId.equals(ErrorMessage.SystemErrorMessage.OOME_ERROR_MESSAGE.getErrorMessage().getErrorFacilityAndNumber()) || dfwWatchName != null && dfwWatchName.equals(WATCH_HEAP_SPACE)) {
                    ClassHistogram.releaseReservedMemory();
                    jvmHistogramCtx = DumpContext.createDumpContext("jvm.classhistogram", adrInfo.getADRHome(), incident.getIncidentId(), incident.getIncidentDirectory(), facts);
                }
                if (actions == null && facts.isEvaluateDiagnosticRules()) {
                    actions = this.m_rulesManager.evaluateRules(facts, adrInfo.getADRHome(), incident.getIncidentId(), incident.getIncidentDirectory());
                }
                ArrayList<DumpContext> contextActions = null;
                if (actions != null && actions.getAsynchronousDumpContextList() != null && actions.getAsynchronousDumpContextList().size() > 0) {
                    contextActions = actions.getAsynchronousDumpContextList();
                }
                if (jvmHistogramCtx != null) {
                    if (contextActions == null) {
                        contextActions = new ArrayList<DumpContext>(1);
                    }
                    contextActions.add(jvmHistogramCtx);
                }
                HashMap<DumpContext, DiagnosticDump> dumpContextPairs = null;
                if (facts.getDiagnosticDumps() != null || facts.getNamedDiagnosticDumps() != null) {
                    dumpContextPairs = new HashMap<DumpContext, DiagnosticDump>(1);
                    if (facts.getNamedDiagnosticDumps() != null) {
                        for (IncidentFacts.DumpInfo dumpInfo : facts.getNamedDiagnosticDumps()) {
                            DiagnosticDump diagnosticDump = this.m_dumpManager.getDump(dumpInfo.getDumpName(), dumpInfo.getApplicationName() == null, dumpInfo.getApplicationName());
                            if (diagnosticDump == null || diagnosticDump.getRunMode() != DiagnosticDump.DumpRunMode.ASYNCHRONOUS && (facts.isSynchronous() || diagnosticDump.getRunMode() != DiagnosticDump.DumpRunMode.SYNCHRONOUS_ASYNCHRONOUS)) continue;
                            DumpContext factCtx = DumpContext.createDumpContext(diagnosticDump.getFullDumpName(), adrInfo.getADRHome(), incident.getIncidentId(), incident.getIncidentDirectory(), facts);
                            dumpContextPairs.put(this.createDumpContext(diagnosticDump, dumpInfo.getDumpArguments(), dumpInfo.getApplicationName(), incident, adrInfo, facts), diagnosticDump);
                        }
                    }
                    if (facts.getDiagnosticDumps() != null) {
                        for (DiagnosticDump factDump : facts.getDiagnosticDumps()) {
                            if (factDump.getRunMode() != DiagnosticDump.DumpRunMode.ASYNCHRONOUS && (facts.isSynchronous() || factDump.getRunMode() != DiagnosticDump.DumpRunMode.SYNCHRONOUS_ASYNCHRONOUS)) continue;
                            dumpContextPairs.put(this.createDumpContext(factDump, null, null, incident, adrInfo, facts), factDump);
                        }
                    }
                }
                if ((contextActions != null || dumpContextPairs != null) && (incidentDumps = this.processDumpActions(contextActions, dumpContextPairs, incident, loader, subject)) != null) {
                    for (IncidentDump incidentDump : incidentDumps) {
                        incident.addIncidentDump(incidentDump);
                    }
                }
                StringBuilder dumpInfo = this.registerDumps(adrInfo, incident);
                OutputStreamWriter writer = null;
                try {
                    File file = new File(incident.getIncidentDirectory(), "readme.txt");
                    writer = AccessCheck.createFileWriter(file, true);
                    writer.append(dumpInfo.toString());
                    writer.flush();
                }
                catch (IOException iOException) {
                    this.m_logger.log(Level.INFO, "Exception caught adding file list to incident readme", iOException);
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Exception exception) {
                            this.m_logger.log(Level.FINEST, "Exception caught closing incident readme stream", exception);
                        }
                    }
                }
            }
            catch (Throwable e) {
                throw new IncidentCreationException("DFW-40102", incident.getIncidentId(), e);
            }
        }
        DiagnosticsEventManager.notifyListeners(new IncidentCreationEvent(incident), false);
    }

    private DumpContext createDumpContext(DiagnosticDump dump, Map<String, Serializable> dumpArgs, String appName, Incident incident, ADRInfo adrInfo, IncidentFacts facts) {
        DumpContext ctx = DumpContext.createDumpContext(dump.getFullDumpName(), adrInfo.getADRHome(), incident.getIncidentId(), incident.getIncidentDirectory(), facts);
        if (dumpArgs != null) {
            for (Map.Entry<String, Serializable> arg : dumpArgs.entrySet()) {
                ctx.addArgument(arg.getKey(), arg.getValue());
            }
        }
        if (appName != null) {
            ctx.setAppScoped(appName);
        }
        return ctx;
    }

    private IncidentImpl createADRIncident(IncidentFacts facts, ADRInfo adrInfo) throws IncidentCreationException {
        String floodControlled;
        if (facts.getIncidentSource().equals((Object)Incident.IncidentSource.SYSTEM) && this.m_problemKeyFilterChecker.isFiltered(facts.getProblemKey())) {
            IncidentImpl incident = new IncidentImpl("-4", "NA", adrInfo.getADRBase(), adrInfo.getProductType(), adrInfo.getProductId(), adrInfo.getInstanceId(), "NA", facts);
            this.m_incidentLogger.log(Level.WARNING, "DFW-40127", facts.getProblemKey());
            return incident;
        }
        if (facts.getIncidentSource().equals((Object)Incident.IncidentSource.SYSTEM) && (floodControlled = this.m_floodController.isFloodControlled(facts)) != null) {
            IncidentImpl incident = new IncidentImpl("-2", "NA", adrInfo.getADRBase(), adrInfo.getProductType(), adrInfo.getProductId(), adrInfo.getInstanceId(), "NA", facts);
            incident.setFloodContolled(floodControlled);
            this.m_incidentLogger.log(Level.WARNING, "DFW-40125", facts.getProblemKey());
            return incident;
        }
        String[] result = null;
        String problemId = "UNKNOWN";
        try {
            result = this.m_adrHelper.createIncident(adrInfo, facts);
            Incident createdIncident = this.m_adrHelper.getIncident(adrInfo, result[0]);
            if (createdIncident != null) {
                this.m_floodController.setLastIncidentId(facts.getProblemKey(), createdIncident.getIncidentId());
                problemId = createdIncident.getProblemId();
            }
        }
        catch (DiagnosticsException e) {
            throw new IncidentCreationException("DFW-40116", e);
        }
        catch (ADRDiskSpaceException e) {
            IncidentImpl incident = new IncidentImpl("-3", "NA", adrInfo.getADRBase(), adrInfo.getProductType(), adrInfo.getProductId(), adrInfo.getInstanceId(), "NA", facts);
            this.m_incidentLogger.log(Level.WARNING, "DFW-40126", new Object[]{facts.getProblemKey(), e.getMaxTotalIncidentSize(), e.getActualTotalIncidentSize()});
            return incident;
        }
        IncidentImpl incident = new IncidentImpl(result[0], result[1], adrInfo.getADRBase(), adrInfo.getProductType(), adrInfo.getProductId(), adrInfo.getInstanceId(), problemId, facts);
        if (this.m_logger.isLoggable(ODLLevel.INCIDENT_ERROR)) {
            String msg = null;
            try {
                msg = this.m_nlSupport.getTranslation("DFW-40104", new Object[]{incident.getIncidentId(), incident.getProblemKey()});
            }
            catch (Exception e) {
                msg = "Incident \"" + incident.getIncidentId() + "\" created";
            }
            ODLLogRecord logRec = new ODLLogRecord(ODLLevel.INCIDENT_ERROR, msg);
            logRec.setMessageId("DFW-40104");
            logRec.setProblemKey(facts.getProblemKey());
            logRec.setErrorInstanceId(incident.getIncidentId());
            logRec.setLoggerName("oracle.dfw.incident");
            logRec.setDetailLocation(incident.getIncidentDirectory());
            this.m_logger.log((LogRecord)logRec);
        }
        return incident;
    }

    /*
     * WARNING - void declaration
     */
    private List<IncidentDump> processDumpActions(List<DumpContext> actions, Map<DumpContext, DiagnosticDump> dumpContextPairs, IncidentImpl incident, ClassLoader loader, Subject subject) {
        void var9_14;
        ArrayList<IncidentDump> executedDumps = new ArrayList<IncidentDump>();
        ArrayList<SingleDumpExecutor> dumpers = new ArrayList<SingleDumpExecutor>();
        if (actions != null) {
            for (DumpContext dumpContext : actions) {
                dumpers.add(new SingleDumpExecutor(dumpContext, null, loader, subject));
            }
        }
        if (dumpContextPairs != null) {
            for (Map.Entry entry : dumpContextPairs.entrySet()) {
                dumpers.add(new SingleDumpExecutor((DumpContext)entry.getKey(), (DiagnosticDump)entry.getValue(), loader, subject));
            }
        }
        final ExecutorService pool = Executors.newFixedThreadPool(3, this.m_dumpExecutorThreadFactory);
        Object var9_12 = null;
        try {
            List list = pool.invokeAll(dumpers);
        }
        catch (Throwable t) {
            LogUtil.log((Logger)this.m_logger, (Level)Level.WARNING, (String)"DFW-40103", (Object)incident.getIncidentId(), (Throwable)t);
        }
        if (var9_14 != null) {
            for (Future future : var9_14) {
                try {
                    DumpResult result = (DumpResult)future.get(120000L, TimeUnit.MILLISECONDS);
                    if (result == null) continue;
                    executedDumps.add(new IncidentDump(result));
                    if (!this.m_logger.isLoggable(Level.FINEST)) continue;
                    this.m_logger.logp(Level.FINEST, CLASS_NAME, PROCESS_DUMP_ACTIONS, "Dump executed successfully: " + result.getDumpContext().getDumpName());
                }
                catch (Throwable t) {
                    LogUtil.log((Logger)this.m_logger, (Level)Level.WARNING, (String)"DFW-40103", (Object)incident.getIncidentId(), (Throwable)t);
                }
            }
            if (pool != null && !pool.isShutdown()) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        pool.shutdownNow();
                        return null;
                    }
                });
            }
        }
        return executedDumps;
    }

    private ADRInfo getADRInfo(IncidentFacts facts) {
        if (facts.getApplicationName() != null && this.m_applicationADRMap.containsKey(facts.getApplicationName())) {
            return this.m_applicationADRMap.get(facts.getApplicationName());
        }
        if (facts.getProductType() != null) {
            return ADRInfo.getADRInfo(this.m_defaultADR.getADRBase(), facts.getProductType(), facts.getProductId(), facts.getInstanceId());
        }
        return this.m_defaultADR;
    }

    private StringBuilder registerDumps(ADRInfo adrInfo, IncidentImpl incident) throws DiagnosticsException {
        StringBuilder readme = new StringBuilder();
        List<IncidentDump> dumps = incident.getIncidentDumps();
        if (dumps == null) {
            return readme;
        }
        ArrayList<String> files = new ArrayList<String>();
        readme.append('\n');
        readme.append("Diagnostic Dumps");
        readme.append('\n');
        readme.append("----------------");
        for (IncidentDump dump : dumps) {
            readme.append('\n');
            readme.append('\n');
            readme.append("Name:");
            readme.append(' ');
            readme.append(dump.getDumpName());
            if (dump.getDumpArguments() != null && dump.getDumpArguments().length() > 0) {
                readme.append('\n');
                readme.append("Dump Arguments:");
                readme.append(' ');
                readme.append(dump.getDumpArguments());
            }
            if (dump.getApplicationName() != null && dump.getApplicationName().length() > 0) {
                readme.append('\n');
                readme.append("Application Name:");
                readme.append(' ');
                readme.append(dump.getApplicationName());
            }
            readme.append('\n');
            readme.append("Dump Files:");
            readme.append(' ');
            boolean first = true;
            for (String filename : dump.getDumpFiles()) {
                if (filename.length() > 64) {
                    String originalFile = filename;
                    int extPos = filename.lastIndexOf(".");
                    if (extPos > 0) {
                        File dest;
                        String extension = filename.substring(extPos + 1);
                        int extLen = extension.length();
                        filename = filename.substring(0, 63 - (extLen + 1)) + "." + extension;
                        File source = new File(incident.getIncidentDirectory(), originalFile);
                        if (!AccessCheck.renameTo(source, dest = new File(incident.getIncidentDirectory(), filename))) {
                            this.m_logger.fine("Unable to rename incident file " + AccessCheck.getAbsolutePath(source) + " to " + AccessCheck.getAbsolutePath(dest) + " in order to truncate to 64 characters to " + " meet ADR requirements");
                            continue;
                        }
                    } else {
                        filename = filename.substring(0, 63);
                    }
                }
                if (!first) {
                    readme.append(',');
                }
                readme.append(filename);
                files.add(filename);
                first = false;
            }
        }
        if (files.size() > 0) {
            String[] incFiles = files.toArray(new String[0]);
            incident.addIncidentFiles(incFiles);
            this.m_adrHelper.addIncidentFiles(adrInfo, incident.getIncidentId(), incFiles);
        }
        return readme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createReadme(ADRInfo adrInfo, Incident incident, IncidentFacts facts, String httpRequest) {
        StringBuilder readme = new StringBuilder();
        readme.append("Incident Id:");
        readme.append(' ');
        readme.append(incident.getIncidentId());
        readme.append('\n');
        readme.append("Incident Source:");
        readme.append(' ');
        readme.append((Object)incident.getIncidentSource());
        readme.append('\n');
        readme.append("Create Time:");
        readme.append(' ');
        readme.append(new Date(incident.getTimeOfIncident()));
        readme.append('\n');
        readme.append("Problem Key:");
        readme.append(' ');
        readme.append(incident.getProblemKey());
        if (facts.getExecutionContextId() != null) {
            readme.append('\n');
            readme.append("ECID:");
            readme.append(' ');
            readme.append(facts.getExecutionContextId());
        }
        if (facts.getApplicationName() != null) {
            readme.append('\n');
            readme.append("Application Name:");
            readme.append(' ');
            readme.append(facts.getApplicationName());
        }
        if (facts.getContextValues().get(DFW_USER_NAME) != null) {
            readme.append('\n');
            readme.append("User Name:");
            readme.append(' ');
            readme.append(facts.getContextValues().get(DFW_USER_NAME));
        }
        if (incident.getProblemImpacts() != null) {
            StringBuilder buf = new StringBuilder();
            for (DiagnosticsCategory impact : incident.getProblemImpacts()) {
                buf.append((Object)impact);
                buf.append(' ');
            }
            if (buf.length() > 0) {
                readme.append('\n');
                readme.append("Problem Impacts:");
                readme.append(' ');
                readme.append((CharSequence)buf);
            }
        }
        if (incident.getErrorMessage() != null) {
            readme.append('\n');
            readme.append("Error Message Id:");
            readme.append(' ');
            readme.append(incident.getErrorMessage().getOriginalErrorMessageId());
        }
        if (facts.getContextValues().size() > 0) {
            readme.append('\n');
            readme.append('\n');
            readme.append("Context Values");
            readme.append('\n');
            readme.append("--------------");
            readme.append('\n');
            for (Map.Entry<String, String> values : facts.getContextValues().entrySet()) {
                if (ADRHelper.isIgnoringContextKey(values.getKey())) continue;
                readme.append(values.getKey());
                readme.append(" : ");
                readme.append(values.getValue());
                readme.append('\n');
            }
        }
        if (httpRequest != null) {
            readme.append('\n');
            readme.append('\n');
            readme.append("HTTP Request");
            readme.append('\n');
            readme.append("------------");
            readme.append('\n');
            readme.append(httpRequest);
        }
        if (incident.getDescription() != null) {
            readme.append('\n');
            readme.append('\n');
            readme.append("Description");
            readme.append('\n');
            readme.append("-----------");
            readme.append('\n');
            readme.append(incident.getDescription());
        }
        if (facts.getThrowable() != null) {
            readme.append('\n');
            readme.append('\n');
            readme.append("Stack Trace");
            readme.append('\n');
            readme.append("-----------");
            readme.append('\n');
            if (facts.getThrowable() instanceof WrapperException) {
                WrapperException we = (WrapperException)facts.getThrowable();
                readme.append(we.getWrappedStackTrace());
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                facts.getThrowable().printStackTrace(pw);
                readme.append(sw.toString());
            }
        }
        OutputStreamWriter writer = null;
        try {
            File readmeFile = new File(incident.getIncidentDirectory(), "readme.txt");
            writer = AccessCheck.createFileWriter(readmeFile);
            writer.write(readme.toString());
            writer.flush();
            this.m_adrHelper.addIncidentFiles(adrInfo, incident.getIncidentId(), "readme.txt");
        }
        catch (Exception e) {
            LogUtil.log((Logger)this.m_logger, (Level)Level.WARNING, (String)"DFW-40109", (Object)incident.getIncidentId(), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    this.m_logger.log(Level.FINEST, "Exception caught closing incident readme stream", e);
                }
            }
        }
    }

    public String setApplicationADRHome(String appName, String productType, String productId, String instanceId) {
        if (appName == null || appName.length() == 0 || productType == null || productType.length() == 0 || productId == null || productId.length() == 0 || instanceId == null || instanceId.length() == 0) {
            throw new IllegalArgumentException("invalid arguments to setApplicationADRHome; appName=" + appName + " productType=" + productType + " productId=" + productId + " instanceId=" + instanceId);
        }
        ADRInfo adrInfo = ADRInfo.getADRInfo(this.m_defaultADR.getADRBase(), productType, productId, instanceId);
        this.m_applicationADRMap.put(appName, adrInfo);
        if (this.m_isADREnabled) {
            try {
                this.m_adrHelper.createADRHome(adrInfo);
            }
            catch (DiagnosticsException e) {
                this.m_logger.log(Level.FINE, "Unable to create an ADR Home for " + adrInfo, e);
            }
        }
        return adrInfo.getADRHome();
    }

    public String getApplicationADRHome(String appName) {
        ADRInfo info = this.m_applicationADRMap.get(appName);
        return info != null ? info.getADRHome() : null;
    }

    ADRHelper getADRHelper() {
        return this.m_adrHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> reloadCustomRules(String specificRulesFile) {
        HashMap<String, String> result = new HashMap<String, String>(this.m_customRulesFiles.size() + 1);
        if (this.m_customRulesDirs == null) {
            return result;
        }
        if (specificRulesFile == null) {
            Iterator<String> i$ = this.m_customRulesFiles.iterator();
            while (i$.hasNext()) {
                String registeredRulesFile;
                File rulesFile = new File(registeredRulesFile = i$.next());
                String appName = this.getAppNameFromRulesFilename(rulesFile.getName());
                this.unregisterRules(registeredRulesFile, appName == null, appName);
            }
            this.m_customRulesFiles.clear();
        } else {
            for (File rulesDir : this.m_customRulesDirs) {
                String removeFile = AccessCheck.getAbsolutePath(rulesDir) + File.separator + specificRulesFile;
                String appName = this.getAppNameFromRulesFilename(specificRulesFile);
                this.unregisterRules(removeFile, appName == null, appName);
                this.m_customRulesFiles.remove(removeFile);
            }
        }
        for (File rulesDir : this.m_customRulesDirs) {
            if (!AccessCheck.exists(rulesDir) || !AccessCheck.isDirectory(rulesDir)) continue;
            for (File rulesFile : AccessCheck.listFiles(rulesDir)) {
                if (AccessCheck.isDirectory(rulesFile) || !rulesFile.getName().endsWith(".xml") || specificRulesFile != null && !specificRulesFile.equals(rulesFile.getName())) continue;
                String rulesFilePath = AccessCheck.getAbsolutePath(rulesFile);
                FileReader reader = null;
                try {
                    reader = new FileReader(rulesFile);
                    String appName = this.getAppNameFromRulesFilename(rulesFile.getName());
                    this.registerRules(reader, rulesFilePath, appName == null, appName);
                    this.m_customRulesFiles.add(rulesFilePath);
                    result.put(rulesFilePath, null);
                    this.m_incidentLogger.log(Level.FINE, "custom rules file " + rulesFilePath + " registered");
                }
                catch (Exception e) {
                    this.m_incidentLogger.log(Level.WARNING, "DFW-40130", new String[]{rulesFilePath, e.getMessage()});
                    result.put(rulesFilePath, e.getMessage());
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        return result;
    }

    private String getAppNameFromRulesFilename(String filename) {
        int index = filename.lastIndexOf("#");
        if (index > 0) {
            return filename.substring(0, index);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.m_shutdown) {
            return;
        }
        this.m_rulesManager.shutdown();
        this.m_floodController.shutdown();
        if (this.m_incidentCreatorThread != null) {
            Object object = this.m_sync;
            synchronized (object) {
                this.m_stop = true;
                this.m_sync.notify();
            }
        }
        this.m_shutdown = true;
    }

    @Override
    public void handleEvent(DiagnosticsEvent event) {
        if (event instanceof DiagnosticsConfigurationChangedEvent) {
            DiagnosticsConfiguration config = ((DiagnosticsConfigurationChangedEvent)event).getDiagnosticsConfiguration();
            this.m_isIncidentCreationEnabled = config.isIncidentCreationEnabled();
            TempFileManager.setMaxSize(config.getTempDirMaxSizeInBytes());
            TempFileManager.setMinCheckInterval(config.getTempDirIntervalInMilli());
        }
    }

    @Override
    public Class<? extends DiagnosticsEvent>[] getHandledEventClasses() {
        return new Class[]{DiagnosticsConfigurationChangedEvent.class};
    }

    static class IncidentProcessingData {
        IncidentImpl m_incident;
        IncidentFacts m_facts;
        ClassLoader m_loader;
        Subject m_subject;
        IncidentActions m_actions;

        IncidentProcessingData(IncidentImpl incident, IncidentFacts facts, SecurityContext secContext, IncidentActions actions) {
            this.m_incident = incident;
            this.m_facts = facts;
            this.m_actions = actions;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    IncidentProcessingData.this.m_loader = Thread.currentThread().getContextClassLoader();
                    return null;
                }
            });
            if (secContext != null) {
                this.m_subject = secContext.getCurrentSubject();
            }
        }
    }

    private class IncidentCreatorThread
    implements Runnable {
        protected IncidentCreatorThread() {
            Thread th = new Thread(this);
            th.setDaemon(true);
            th.setName("oracle.dfw.incident.IncidentCreatorThread");
            th.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                IncidentProcessingData pair;
                Object object = DiagnosticsDataExtractorImpl.this.m_sync;
                synchronized (object) {
                    if (DiagnosticsDataExtractorImpl.this.m_stop) {
                        break;
                    }
                }
                List list = DiagnosticsDataExtractorImpl.this.m_queue;
                synchronized (list) {
                    if (DiagnosticsDataExtractorImpl.this.m_queue.size() == 0) {
                        block13: {
                            try {
                                DiagnosticsDataExtractorImpl.this.m_queue.wait();
                            }
                            catch (Exception e) {
                                if (!DiagnosticsDataExtractorImpl.this.m_logger.isLoggable(Level.FINE)) break block13;
                                DiagnosticsDataExtractorImpl.this.m_logger.logp(Level.FINE, "IncidentCreatorThread", "run", "Caught exception processing incident queue", e);
                            }
                        }
                        continue;
                    }
                    pair = (IncidentProcessingData)DiagnosticsDataExtractorImpl.this.m_queue.remove(0);
                }
                try {
                    DiagnosticsDataExtractorImpl.this.processIncident(pair.m_facts, pair.m_incident, pair.m_loader, pair.m_subject, pair.m_actions);
                }
                catch (Throwable t) {
                    LogUtil.log((Logger)DiagnosticsDataExtractorImpl.this.m_logger, (Level)Level.INFO, (String)"DFW-40362", (Object)pair.m_incident.getIncidentId(), (Throwable)t);
                }
                object = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void add(IncidentImpl incident, IncidentFacts facts, IncidentActions actions) {
            List list = DiagnosticsDataExtractorImpl.this.m_queue;
            synchronized (list) {
                DiagnosticsDataExtractorImpl.this.m_queue.add(new IncidentProcessingData(incident, facts, DiagnosticsDataExtractorImpl.this.m_secContext, actions));
                DiagnosticsDataExtractorImpl.this.m_queue.notify();
            }
        }
    }

    private class SingleDumpExecutor
    implements Callable<DumpResult> {
        private final DumpContext m_context;
        private final DiagnosticDump m_dump;
        private ClassLoader m_loader;
        private final Subject m_subject;

        SingleDumpExecutor(DumpContext context, DiagnosticDump dump, ClassLoader loader, Subject subject) {
            this.m_subject = context.getDumpName().equals("wls.image") || context.getDumpName().equals("odl.logs") ? DiagnosticsDataExtractorImpl.this.m_systemSubject : subject;
            this.m_context = context;
            this.m_dump = dump;
            this.m_loader = loader;
        }

        @Override
        public DumpResult call() {
            DumpResult result;
            block8: {
                if (DiagnosticsDataExtractorImpl.this.m_logger.isLoggable(Level.FINE)) {
                    DiagnosticsDataExtractorImpl.this.m_logger.logp(Level.FINE, "SingleDumpExecutor", "call", "Executing dump " + this.m_context.getDumpName() + " during creation of incident " + this.m_context.getIncidentID());
                }
                result = null;
                try {
                    if (this.m_loader != null && !this.m_context.getDumpName().equals("wls.image")) {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                Thread.currentThread().setContextClassLoader(SingleDumpExecutor.this.m_loader);
                                return null;
                            }
                        });
                    }
                    if (this.m_subject != null && DiagnosticsDataExtractorImpl.this.m_secContext != null) {
                        final PrivilegedExceptionAction<DumpResult> action = new PrivilegedExceptionAction<DumpResult>(){

                            @Override
                            public DumpResult run() throws Exception {
                                return DiagnosticsDataExtractorImpl.this.m_dumpManager.executeDump(SingleDumpExecutor.this.m_context, SingleDumpExecutor.this.m_dump, true, true);
                            }
                        };
                        try {
                            result = AccessController.doPrivileged(new PrivilegedExceptionAction<DumpResult>(){

                                @Override
                                public DumpResult run() throws PrivilegedActionException {
                                    return (DumpResult)DiagnosticsDataExtractorImpl.this.m_secContext.executeAs(SingleDumpExecutor.this.m_subject, action);
                                }
                            });
                            break block8;
                        }
                        catch (PrivilegedActionException e) {
                            if (e.getException() instanceof PrivilegedActionException) {
                                throw ((PrivilegedActionException)e.getException()).getException();
                            }
                            throw e.getException();
                        }
                    }
                    result = DiagnosticsDataExtractorImpl.this.m_dumpManager.executeDump(this.m_context, this.m_dump, true, true);
                }
                catch (Throwable t) {
                    if (!DiagnosticsDataExtractorImpl.this.m_logger.isLoggable(Level.INFO)) break block8;
                    LogUtil.log((Logger)DiagnosticsDataExtractorImpl.this.m_logger, (Level)Level.INFO, (String)"DFW-40105", (Object[])new String[]{this.m_context.getDumpName(), this.m_context.getIncidentID()}, (Throwable)t);
                }
            }
            return result;
        }
    }
}

