/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event.impl;

import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;
import oracle.dms.event.Event;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventFactory;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.impl.EventImpl;
import oracle.dms.event.impl.EventManagerImpl;

public class EventFactoryImpl
implements EventFactory {
    private volatile boolean mSetContextWhenEventCreated = false;
    private volatile boolean mSetStackTraceWhenEvenCreated = false;
    private EventManagerImpl mEventManagerImpl;

    EventFactoryImpl(EventManagerImpl eventManager) {
        this.mEventManagerImpl = eventManager;
    }

    void setContextOnEventCreation(boolean b) {
        this.mSetContextWhenEventCreated = b;
    }

    void setStackTraceOnEventCreation(boolean b) {
        this.mSetStackTraceWhenEvenCreated = b;
    }

    @Override
    public Event createEvent(Object source, EventSourceType sourceType, EventActionType actionType, long timeOfEvent, ExecutionContext ctx, Object[] subsidiaryObjects) {
        EventImpl retVal = null;
        if (ctx == null && this.mSetContextWhenEventCreated) {
            ctx = DMSContextManager.getActiveContext();
        }
        StackTraceElement[] stackTrace = null;
        if (this.mSetStackTraceWhenEvenCreated) {
            stackTrace = Thread.currentThread().getStackTrace();
        }
        retVal = new EventImpl(source, sourceType, actionType, timeOfEvent, ctx, stackTrace, subsidiaryObjects);
        return retVal;
    }
}

