/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument.state;

import oracle.dms.instrument.state.Value;

public class IntegerValue
extends Value {
    private int _value = 0;
    private int _min = Integer.MAX_VALUE;
    private int _max = Integer.MIN_VALUE;

    private void setValue(int newval) {
        this._value = newval;
        if (this.MAX && this._value > this._max) {
            this._max = newval;
        }
        if (this.MIN && this._value < this._min) {
            this._min = newval;
        }
    }

    @Override
    public void update(int newval) {
        this.setValue(newval);
    }

    @Override
    public void update(double newval) {
        int ival = 0;
        ival = newval >= 0.0 ? (int)Math.round(newval) : -((int)Math.round(-newval));
        this.setValue(ival);
    }

    @Override
    public void update(long newval) {
        int ival = (int)newval;
        this.setValue(ival);
    }

    @Override
    public void increment() {
        int ival = this._value + 1;
        this.setValue(ival);
    }

    @Override
    public void increment(int inc) {
        int ival = this._value + inc;
        this.setValue(ival);
    }

    @Override
    public void increment(long inc) {
        int ival = (int)inc;
        this.setValue(ival += this._value);
    }

    @Override
    public void increment(double inc) {
        int ival = (int)Math.round(inc);
        this.setValue(ival += this._value);
    }

    @Override
    void initMinMax() {
        if (this._initialized) {
            if (this.MIN && this._min > this._value) {
                this._min = this._value;
            }
            if (this.MAX && this._max < this._value) {
                this._max = this._value;
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.MIN) {
            this._min = this._value;
        }
        if (this.MAX) {
            this._max = this._value;
        }
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    @Override
    public byte getType() {
        return 3;
    }

    @Override
    public Object getMin() {
        if (!this.MIN) {
            return null;
        }
        if (this._min != Integer.MAX_VALUE) {
            return this._min;
        }
        return 0;
    }

    @Override
    public Object getMax() {
        if (!this.MAX) {
            return null;
        }
        if (this._max != Integer.MIN_VALUE) {
            return this._max;
        }
        return 0;
    }

    @Override
    public String toString() {
        return Integer.toString(this._value);
    }

    @Override
    public Object clone() {
        IntegerValue retVal = (IntegerValue)super.clone();
        return retVal;
    }
}

