/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.dms.context.ExecutionContext;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounRefresh;
import oracle.dms.instrument.State;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.Time;

public class ThreadMonitor
implements GroupRefresh {
    private static ConcurrentHashMap<Long, ThreadMonitor> s_statMap = new ConcurrentHashMap();
    private static ThreadMXBean s_bean = ManagementFactory.getThreadMXBean();
    private static boolean s_cpuSupported = false;
    private static boolean s_contentionSupported = false;
    private static Noun s_baseNoun = null;
    private static final long MAX_STALE_DEFAULT = 20L;
    private static long s_maxStale = 20000L;
    private static boolean s_init = false;
    private long m_id = 0L;
    private Noun m_noun = null;
    private State m_cpuTime = null;
    private State m_threadState = null;
    private State m_blockedTime = null;
    private State m_blockedCount = null;
    private State m_lockName = null;
    private State m_lockOwnerID = null;
    private State m_lockOwnerName = null;
    private State m_waitedCount = null;
    private State m_waitedTime = null;
    private State m_ecid = null;
    private State m_rid = null;
    private volatile boolean m_isReady = false;
    static String JVM_THREAD = "JVM_Thread";

    private ThreadMonitor() {
    }

    private static void init() {
        String propValue = DMSProperties.getProperty("oracle.dms.spy.jvm.ThreadMonitor.threadListRefresh", Long.toString(20L));
        try {
            s_maxStale = Long.parseLong(propValue) * 1000L;
        }
        catch (NumberFormatException nfe) {
            s_maxStale = 20000L;
        }
        s_contentionSupported = s_bean.isThreadContentionMonitoringSupported();
        if (s_contentionSupported && !s_bean.isThreadContentionMonitoringEnabled()) {
            Boolean enabledContentionMonitoring = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    s_bean.setThreadContentionMonitoringEnabled(true);
                    return Boolean.TRUE;
                }
            });
        }
        RuntimeMXBean rxbean = ManagementFactory.getRuntimeMXBean();
        String vmName = rxbean.getVmVendor();
        String vmVersion = rxbean.getVmVersion();
        s_cpuSupported = vmVersion != null && vmVersion.startsWith("1.5") && vmName != null && vmName.equals("Sun Microsystems Inc.") ? false : s_bean.isThreadCpuTimeSupported();
        if (s_cpuSupported && !s_bean.isThreadCpuTimeEnabled()) {
            Boolean enabledCPUTime = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    s_bean.setThreadCpuTimeEnabled(true);
                    return Boolean.TRUE;
                }
            });
        }
        s_init = true;
    }

    private ThreadMonitor(Noun noun, long id) {
        Noun baseNoun = null;
        baseNoun = noun == null ? Noun.create("/JVM/MxBeans/threads") : Noun.create(noun, "threads", "");
        this.m_noun = Noun.create(baseNoun, "Thread-" + Long.toString(id), JVM_THREAD);
        this.m_id = id;
        ThreadInfo info = ThreadMonitor.getThreadInfo(id);
        State name = State.create(this.m_noun, "name", (byte)5, "", "name of thread");
        if (info != null) {
            name.update(info.getThreadName());
        } else {
            name.update("UNKNOWN");
        }
        this.m_threadState = State.create(this.m_noun, "state", (byte)5, "", "The current state of this thread");
        this.m_threadState.setRefresh(this);
        this.m_lockName = State.create(this.m_noun, "lockName", (byte)5, "", "name of the lock that the thread is waiting on");
        this.m_lockOwnerID = State.create(this.m_noun, "lockOwnerID", (byte)5, "", "ID of the thread which holds the lock blocking this thread");
        this.m_lockOwnerName = State.create(this.m_noun, "lockOwnerName", (byte)5, "", "name of the thread which holds the lock blocking this thread");
        this.m_blockedCount = State.create(this.m_noun, "blockedCount", (byte)2, "times", "times this thread has been blocked");
        this.m_waitedCount = State.create(this.m_noun, "waitedCount", (byte)2, "times", "times this thread waited for notification");
        if (s_cpuSupported) {
            this.m_cpuTime = State.create(this.m_noun, "cpu", (byte)2, "msecs", "CPU time used by this thread");
        }
        if (s_contentionSupported) {
            this.m_blockedTime = State.create(this.m_noun, "blocked", (byte)2, "msec", "total milliseconds this thread has been blocked");
            this.m_waitedTime = State.create(this.m_noun, "waited", (byte)2, "msec", "total milliseconds this thread has been waiting");
        }
        this.m_ecid = State.create(this.m_noun, "ECID", (byte)5, "", "The ECID activated for this thread");
        this.m_rid = State.create(this.m_noun, "RID", (byte)5, "", "The RID for this thread");
        this.m_lockName.setRefresh(this);
        this.m_lockOwnerID.setRefresh(this);
        this.m_lockOwnerName.setRefresh(this);
        this.m_blockedCount.setRefresh(this);
        this.m_waitedCount.setRefresh(this);
        if (s_cpuSupported) {
            this.m_cpuTime.setRefresh(this);
        }
        if (s_contentionSupported) {
            this.m_blockedTime.setRefresh(this);
            this.m_waitedTime.setRefresh(this);
        }
        this.m_ecid.setRefresh(this);
        this.m_rid.setRefresh(this);
        this.m_isReady = true;
        this.refresh();
    }

    public static void create(Noun base) {
        String propVal = DMSProperties.getProperty("oracle.dms.spy.jvm.ThreadMonitor.enable", "true");
        if ("false".equals(propVal) || DMSConsole.getSensorWeight() == 0) {
            return;
        }
        if (!s_init) {
            ThreadMonitor.init();
        }
        if (s_statMap.size() > 0) {
            return;
        }
        ThreadMonitor tm = null;
        long[] ids = ThreadMonitor.getThreadIds();
        if (ids != null && ids.length > 0) {
            tm = new ThreadMonitor(base, ids[0]);
            s_statMap.put(ids[0], tm);
        }
        Noun.setNounRefresh(JVM_THREAD, new RefreshThreadMonitor());
    }

    public static void exit() {
        if (!s_init) {
            return;
        }
        s_statMap.clear();
        s_baseNoun = null;
        s_maxStale = 20000L;
        Noun.removeNounRefresh(JVM_THREAD);
    }

    private static long[] getThreadIds() {
        long[] ids = new long[]{};
        ids = AccessController.doPrivileged(new PrivilegedAction<long[]>(){

            @Override
            public long[] run() {
                return s_bean.getAllThreadIds();
            }
        });
        return ids;
    }

    private static ThreadInfo getThreadInfo(final long id) {
        ThreadInfo info = null;
        info = AccessController.doPrivileged(new PrivilegedAction<ThreadInfo>(){

            @Override
            public ThreadInfo run() {
                return s_bean.getThreadInfo(id);
            }
        });
        return info;
    }

    @Override
    public void refresh() {
        ExecutionContext ctx;
        if (!this.m_isReady) {
            return;
        }
        ThreadInfo info = ThreadMonitor.getThreadInfo(this.m_id);
        if (info == null) {
            this.m_threadState.update("TERMINATED");
            return;
        }
        this.m_threadState.update((Object)info.getThreadState());
        this.m_blockedCount.update(info.getBlockedCount());
        this.m_waitedCount.update(info.getWaitedCount());
        this.m_lockName.update(info.getLockName());
        this.m_lockOwnerID.update(info.getLockOwnerId());
        this.m_lockOwnerName.update(info.getLockOwnerName());
        if (this.m_cpuTime != null) {
            if (s_bean.isThreadCpuTimeEnabled()) {
                long nsecs = s_bean.getThreadCpuTime(this.m_id);
                if (nsecs >= 0L) {
                    long msecs = (nsecs + 500000L) / 1000000L;
                    this.m_cpuTime.update(msecs);
                } else {
                    this.m_cpuTime.update(-1);
                }
            } else {
                this.m_cpuTime.update(-1);
            }
        }
        if (this.m_blockedTime != null && this.m_waitedTime != null) {
            if (s_bean.isThreadContentionMonitoringEnabled()) {
                this.m_blockedTime.update(info.getBlockedTime());
                this.m_waitedTime.update(info.getWaitedTime());
            } else {
                this.m_blockedTime.update(-1);
                this.m_waitedTime.update(-1);
            }
        }
        if ((ctx = ExecutionContext.getActiveContext(this.m_id)) == null) {
            this.m_ecid.update("null");
            this.m_rid.update("null");
        } else {
            this.m_ecid.update(ctx.getECID());
            this.m_rid.update(ctx.getRIDasString());
        }
    }

    private static boolean isMember(long[] ids, long test) {
        for (int i = 0; i < ids.length; ++i) {
            if (test != ids[i]) continue;
            return true;
        }
        return false;
    }

    private static void clean(ThreadMonitor tm) {
        if (tm == null) {
            return;
        }
        long id = tm.m_id;
        s_statMap.remove(id);
        tm.m_cpuTime.removeRefresh();
        tm.m_threadState.removeRefresh();
        if (s_contentionSupported) {
            tm.m_blockedCount.removeRefresh();
            tm.m_blockedTime.removeRefresh();
        }
        tm.m_noun.destroy();
    }

    private static class RefreshThreadMonitor
    implements NounRefresh {
        private volatile long m_lastRefresh = 0L;

        private RefreshThreadMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void refresh(Set<String> nountypes) {
            long timestamp = Time.currentTimeMillis();
            RefreshThreadMonitor refreshThreadMonitor = this;
            synchronized (refreshThreadMonitor) {
                if (timestamp - this.m_lastRefresh < s_maxStale) {
                    return;
                }
                this.m_lastRefresh = timestamp;
            }
            long[] ids = ThreadMonitor.getThreadIds();
            HashSet keys = new HashSet(s_statMap.keySet());
            boolean present = false;
            for (int i = 0; i < ids.length; ++i) {
                present = keys.remove(ids[i]);
                if (present) continue;
                ThreadMonitor tm = new ThreadMonitor(null, ids[i]);
                s_statMap.put(ids[i], tm);
            }
            for (Long key : keys) {
                ThreadMonitor tm = (ThreadMonitor)s_statMap.get(key);
                ThreadMonitor.clean(tm);
            }
        }
    }
}

